; LWP testcases from 2010/03/22 binutils change: no more 16-bit variants
;------------------------------------------------------------------------

%define testcase3(x) x
%define testcase3(x,y) y,x
%define testcase3(x,y,z) z,y,x

%macro testcase 3.nolist	; uncomment one of the two, and compare the -f bin and -l output between them
%ifdef BIN
    db %1
%endif
%ifdef SRC
    %2 testcase3(%3)
%endif
%endmacro

bits 32

testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc0									  }, { llwpcb }, { eax }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc1									  }, { llwpcb }, { ecx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc2									  }, { llwpcb }, { edx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc3									  }, { llwpcb }, { ebx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc4									  }, { llwpcb }, { esp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc5									  }, { llwpcb }, { ebp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc6									  }, { llwpcb }, { esi }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc7									  }, { llwpcb }, { edi }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcf									  }, { slwpcb }, { edi }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xce									  }, { slwpcb }, { esi }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcd									  }, { slwpcb }, { ebp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcc									  }, { slwpcb }, { esp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcb									  }, { slwpcb }, { ebx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xca									  }, { slwpcb }, { edx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc9									  }, { slwpcb }, { ecx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc8									  }, { slwpcb }, { eax }
testcase { 0x8f, 0xea, 0x78, 0x12, 0xc7, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,edi,eax }
testcase { 0x8f, 0xea, 0x70, 0x12, 0xc6, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,esi,ecx }
testcase { 0x8f, 0xea, 0x68, 0x12, 0xc5, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,ebp,edx }
testcase { 0x8f, 0xea, 0x60, 0x12, 0xc4, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,esp,ebx }
testcase { 0x8f, 0xea, 0x58, 0x12, 0xc3, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,ebx,esp }
testcase { 0x8f, 0xea, 0x50, 0x12, 0xc2, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,edx,ebp }
testcase { 0x8f, 0xea, 0x48, 0x12, 0xc1, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,ecx,esi }
testcase { 0x8f, 0xea, 0x40, 0x12, 0xc0, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,eax,edi }
testcase { 0x8f, 0xea, 0x78, 0x12, 0xcf, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,edi,eax }
testcase { 0x8f, 0xea, 0x70, 0x12, 0xce, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,esi,ecx }
testcase { 0x8f, 0xea, 0x68, 0x12, 0xcd, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,ebp,edx }
testcase { 0x8f, 0xea, 0x60, 0x12, 0xcc, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,esp,ebx }
testcase { 0x8f, 0xea, 0x58, 0x12, 0xcb, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,ebx,esp }
testcase { 0x8f, 0xea, 0x50, 0x12, 0xca, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,edx,ebp }
testcase { 0x8f, 0xea, 0x48, 0x12, 0xc9, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,ecx,esi }
testcase { 0x8f, 0xea, 0x40, 0x12, 0xc8, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,eax,edi }
testcase { 0x8f, 0xea, 0x78, 0x12, 0x07, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,[edi],eax }
testcase { 0x8f, 0xea, 0x70, 0x12, 0x06, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,[esi],ecx }
testcase { 0x8f, 0xea, 0x68, 0x12, 0x45, 0x00, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[ebp],edx }
testcase { 0x8f, 0xea, 0x60, 0x12, 0x04, 0x24, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[esp],ebx }
testcase { 0x8f, 0xea, 0x58, 0x12, 0x03, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,[ebx],esp }
testcase { 0x8f, 0xea, 0x50, 0x12, 0x02, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,[edx],ebp }
testcase { 0x8f, 0xea, 0x48, 0x12, 0x01, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,[ecx],esi }
testcase { 0x8f, 0xea, 0x40, 0x12, 0x00, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,[eax],edi }
testcase { 0x8f, 0xea, 0x78, 0x12, 0x0f, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,[edi],eax }
testcase { 0x8f, 0xea, 0x70, 0x12, 0x0e, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,[esi],ecx }
testcase { 0x8f, 0xea, 0x68, 0x12, 0x4d, 0x00, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[ebp],edx }
testcase { 0x8f, 0xea, 0x60, 0x12, 0x0c, 0x24, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[esp],ebx }
testcase { 0x8f, 0xea, 0x58, 0x12, 0x0b, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,[ebx],esp }
testcase { 0x8f, 0xea, 0x50, 0x12, 0x0a, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,[edx],ebp }
testcase { 0x8f, 0xea, 0x48, 0x12, 0x09, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,[ecx],esi }
testcase { 0x8f, 0xea, 0x40, 0x12, 0x08, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,[eax],edi }
testcase { 0x8f, 0xea, 0x78, 0x12, 0x87, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpins }, { 0x12345678,[0xcafe+edi],eax }
testcase { 0x8f, 0xea, 0x70, 0x12, 0x86, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpins }, { 0x12345678,[0xcafe+esi],ecx }
testcase { 0x8f, 0xea, 0x68, 0x12, 0x85, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpins }, { 0x12345678,[0xcafe+ebp],edx }
testcase { 0x8f, 0xea, 0x60, 0x12, 0x84, 0x24, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+esp],ebx }
testcase { 0x8f, 0xea, 0x58, 0x12, 0x83, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpins }, { 0x12345678,[0xcafe+ebx],esp }
testcase { 0x8f, 0xea, 0x50, 0x12, 0x82, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpins }, { 0x12345678,[0xcafe+edx],ebp }
testcase { 0x8f, 0xea, 0x48, 0x12, 0x81, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpins }, { 0x12345678,[0xcafe+ecx],esi }
testcase { 0x8f, 0xea, 0x40, 0x12, 0x80, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpins }, { 0x12345678,[0xcafe+eax],edi }
testcase { 0x8f, 0xea, 0x78, 0x12, 0x8f, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpval }, { 0x12345678,[0xcafe+edi],eax }
testcase { 0x8f, 0xea, 0x70, 0x12, 0x8e, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpval }, { 0x12345678,[0xcafe+esi],ecx }
testcase { 0x8f, 0xea, 0x68, 0x12, 0x8d, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpval }, { 0x12345678,[0xcafe+ebp],edx }
testcase { 0x8f, 0xea, 0x60, 0x12, 0x8c, 0x24, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+esp],ebx }
testcase { 0x8f, 0xea, 0x58, 0x12, 0x8b, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpval }, { 0x12345678,[0xcafe+ebx],esp }
testcase { 0x8f, 0xea, 0x50, 0x12, 0x8a, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpval }, { 0x12345678,[0xcafe+edx],ebp }
testcase { 0x8f, 0xea, 0x48, 0x12, 0x89, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpval }, { 0x12345678,[0xcafe+ecx],esi }
testcase { 0x8f, 0xea, 0x40, 0x12, 0x88, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12			  }, { lwpval }, { 0x12345678,[0xcafe+eax],edi }

bits 64

testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc0									  }, { llwpcb }, { eax }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc1									  }, { llwpcb }, { ecx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc2									  }, { llwpcb }, { edx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc3									  }, { llwpcb }, { ebx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc4									  }, { llwpcb }, { esp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc5									  }, { llwpcb }, { ebp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc6									  }, { llwpcb }, { esi }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc7									  }, { llwpcb }, { edi }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc0									  }, { llwpcb }, { r8d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc1									  }, { llwpcb }, { r9d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc2									  }, { llwpcb }, { r10d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc3									  }, { llwpcb }, { r11d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc4									  }, { llwpcb }, { r12d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc5									  }, { llwpcb }, { r13d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc6									  }, { llwpcb }, { r14d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc7									  }, { llwpcb }, { r15d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xcf									  }, { slwpcb }, { r15d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xce									  }, { slwpcb }, { r14d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xcd									  }, { slwpcb }, { r13d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xcc									  }, { slwpcb }, { r12d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xcb									  }, { slwpcb }, { r11d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xca									  }, { slwpcb }, { r10d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc9									  }, { slwpcb }, { r9d }
testcase { 0x8f, 0xc9, 0x78, 0x12, 0xc8									  }, { slwpcb }, { r8d }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcf									  }, { slwpcb }, { edi }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xce									  }, { slwpcb }, { esi }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcd									  }, { slwpcb }, { ebp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcc									  }, { slwpcb }, { esp }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xcb									  }, { slwpcb }, { ebx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xca									  }, { slwpcb }, { edx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc9									  }, { slwpcb }, { ecx }
testcase { 0x8f, 0xe9, 0x78, 0x12, 0xc8									  }, { slwpcb }, { eax }
testcase { 0x8f, 0xca, 0x78, 0x12, 0xc7, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r15d,eax }
testcase { 0x8f, 0xca, 0x70, 0x12, 0xc6, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r14d,ecx }
testcase { 0x8f, 0xca, 0x68, 0x12, 0xc5, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r13d,edx }
testcase { 0x8f, 0xca, 0x60, 0x12, 0xc4, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r12d,ebx }
testcase { 0x8f, 0xca, 0x58, 0x12, 0xc3, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r11d,esp }
testcase { 0x8f, 0xca, 0x50, 0x12, 0xc2, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r10d,ebp }
testcase { 0x8f, 0xca, 0x48, 0x12, 0xc1, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r9d,esi }
testcase { 0x8f, 0xca, 0x40, 0x12, 0xc0, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,r8d,edi }
testcase { 0x8f, 0xea, 0x38, 0x12, 0xc7, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,edi,r8d }
testcase { 0x8f, 0xea, 0x30, 0x12, 0xc6, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,esi,r9d }
testcase { 0x8f, 0xea, 0x28, 0x12, 0xc5, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,ebp,r10d }
testcase { 0x8f, 0xea, 0x20, 0x12, 0xc4, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,esp,r11d }
testcase { 0x8f, 0xea, 0x18, 0x12, 0xc3, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,ebx,r12d }
testcase { 0x8f, 0xea, 0x10, 0x12, 0xc2, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,edx,r13d }
testcase { 0x8f, 0xea, 0x08, 0x12, 0xc1, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,ecx,r14d }
testcase { 0x8f, 0xea, 0x00, 0x12, 0xc0, 0x78, 0x56, 0x34, 0x12						  }, { lwpins }, { 0x12345678,eax,r15d }
testcase { 0x8f, 0xca, 0x78, 0x12, 0xcf, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r15d,eax }
testcase { 0x8f, 0xca, 0x70, 0x12, 0xce, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r14d,ecx }
testcase { 0x8f, 0xca, 0x68, 0x12, 0xcd, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r13d,edx }
testcase { 0x8f, 0xca, 0x60, 0x12, 0xcc, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r12d,ebx }
testcase { 0x8f, 0xca, 0x58, 0x12, 0xcb, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r11d,esp }
testcase { 0x8f, 0xca, 0x50, 0x12, 0xca, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r10d,ebp }
testcase { 0x8f, 0xca, 0x48, 0x12, 0xc9, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r9d,esi }
testcase { 0x8f, 0xca, 0x40, 0x12, 0xc8, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,r8d,edi }
testcase { 0x8f, 0xea, 0x38, 0x12, 0xcf, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,edi,r8d }
testcase { 0x8f, 0xea, 0x30, 0x12, 0xce, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,esi,r9d }
testcase { 0x8f, 0xea, 0x28, 0x12, 0xcd, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,ebp,r10d }
testcase { 0x8f, 0xea, 0x20, 0x12, 0xcc, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,esp,r11d }
testcase { 0x8f, 0xea, 0x18, 0x12, 0xcb, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,ebx,r12d }
testcase { 0x8f, 0xea, 0x10, 0x12, 0xca, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,edx,r13d }
testcase { 0x8f, 0xea, 0x08, 0x12, 0xc9, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,ecx,r14d }
testcase { 0x8f, 0xea, 0x00, 0x12, 0xc8, 0x78, 0x56, 0x34, 0x12						  }, { lwpval }, { 0x12345678,eax,r15d }
testcase { 0x67, 0x8f, 0xca, 0x78, 0x12, 0x07, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[r15d],eax }
testcase { 0x67, 0x8f, 0xca, 0x70, 0x12, 0x06, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[r14d],ecx }
testcase { 0x67, 0x8f, 0xca, 0x68, 0x12, 0x45, 0x00, 0x78, 0x56, 0x34, 0x12				  }, { lwpins }, { 0x12345678,[r13d],edx }
testcase { 0x67, 0x8f, 0xca, 0x60, 0x12, 0x04, 0x24, 0x78, 0x56, 0x34, 0x12				  }, { lwpins }, { 0x12345678,[r12d],ebx }
testcase { 0x67, 0x8f, 0xca, 0x58, 0x12, 0x03, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[r11d],esp }
testcase { 0x67, 0x8f, 0xca, 0x50, 0x12, 0x02, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[r10d],ebp }
testcase { 0x67, 0x8f, 0xca, 0x48, 0x12, 0x01, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[r9d],esi }
testcase { 0x67, 0x8f, 0xca, 0x40, 0x12, 0x00, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[r8d],edi }
testcase { 0x67, 0x8f, 0xea, 0x38, 0x12, 0x07, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[edi],r8d }
testcase { 0x67, 0x8f, 0xea, 0x30, 0x12, 0x06, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[esi],r9d }
testcase { 0x67, 0x8f, 0xea, 0x28, 0x12, 0x45, 0x00, 0x78, 0x56, 0x34, 0x12				  }, { lwpins }, { 0x12345678,[ebp],r10d }
testcase { 0x67, 0x8f, 0xea, 0x20, 0x12, 0x04, 0x24, 0x78, 0x56, 0x34, 0x12				  }, { lwpins }, { 0x12345678,[esp],r11d }
testcase { 0x67, 0x8f, 0xea, 0x18, 0x12, 0x03, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[ebx],r12d }
testcase { 0x67, 0x8f, 0xea, 0x10, 0x12, 0x02, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[edx],r13d }
testcase { 0x67, 0x8f, 0xea, 0x08, 0x12, 0x01, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[ecx],r14d }
testcase { 0x67, 0x8f, 0xea, 0x00, 0x12, 0x00, 0x78, 0x56, 0x34, 0x12					  }, { lwpins }, { 0x12345678,[eax],r15d }
testcase { 0x67, 0x8f, 0xca, 0x78, 0x12, 0x0f, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[r15d],eax }
testcase { 0x67, 0x8f, 0xca, 0x70, 0x12, 0x0e, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[r14d],ecx }
testcase { 0x67, 0x8f, 0xca, 0x68, 0x12, 0x4d, 0x00, 0x78, 0x56, 0x34, 0x12				  }, { lwpval }, { 0x12345678,[r13d],edx }
testcase { 0x67, 0x8f, 0xca, 0x60, 0x12, 0x0c, 0x24, 0x78, 0x56, 0x34, 0x12				  }, { lwpval }, { 0x12345678,[r12d],ebx }
testcase { 0x67, 0x8f, 0xca, 0x58, 0x12, 0x0b, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[r11d],esp }
testcase { 0x67, 0x8f, 0xca, 0x50, 0x12, 0x0a, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[r10d],ebp }
testcase { 0x67, 0x8f, 0xca, 0x48, 0x12, 0x09, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[r9d],esi }
testcase { 0x67, 0x8f, 0xca, 0x40, 0x12, 0x08, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[r8d],edi }
testcase { 0x67, 0x8f, 0xea, 0x38, 0x12, 0x0f, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[edi],r8d }
testcase { 0x67, 0x8f, 0xea, 0x30, 0x12, 0x0e, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[esi],r9d }
testcase { 0x67, 0x8f, 0xea, 0x28, 0x12, 0x4d, 0x00, 0x78, 0x56, 0x34, 0x12				  }, { lwpval }, { 0x12345678,[ebp],r10d }
testcase { 0x67, 0x8f, 0xea, 0x20, 0x12, 0x0c, 0x24, 0x78, 0x56, 0x34, 0x12				  }, { lwpval }, { 0x12345678,[esp],r11d }
testcase { 0x67, 0x8f, 0xea, 0x18, 0x12, 0x0b, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[ebx],r12d }
testcase { 0x67, 0x8f, 0xea, 0x10, 0x12, 0x0a, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[edx],r13d }
testcase { 0x67, 0x8f, 0xea, 0x08, 0x12, 0x09, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[ecx],r14d }
testcase { 0x67, 0x8f, 0xea, 0x00, 0x12, 0x08, 0x78, 0x56, 0x34, 0x12					  }, { lwpval }, { 0x12345678,[eax],r15d }
testcase { 0x67, 0x8f, 0xca, 0x78, 0x12, 0x87, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+r15d],eax }
testcase { 0x67, 0x8f, 0xca, 0x70, 0x12, 0x86, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+r14d],ecx }
testcase { 0x67, 0x8f, 0xca, 0x68, 0x12, 0x85, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+r13d],edx }
testcase { 0x67, 0x8f, 0xca, 0x60, 0x12, 0x84, 0x24, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12	  }, { lwpins }, { 0x12345678,[0xcafe+r12d],ebx }
testcase { 0x67, 0x8f, 0xca, 0x58, 0x12, 0x83, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+r11d],esp }
testcase { 0x67, 0x8f, 0xca, 0x50, 0x12, 0x82, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+r10d],ebp }
testcase { 0x67, 0x8f, 0xca, 0x48, 0x12, 0x81, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+r9d],esi }
testcase { 0x67, 0x8f, 0xca, 0x40, 0x12, 0x80, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+r8d],edi }
testcase { 0x67, 0x8f, 0xea, 0x38, 0x12, 0x87, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+edi],r8d }
testcase { 0x67, 0x8f, 0xea, 0x30, 0x12, 0x86, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+esi],r9d }
testcase { 0x67, 0x8f, 0xea, 0x28, 0x12, 0x85, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+ebp],r10d }
testcase { 0x67, 0x8f, 0xea, 0x20, 0x12, 0x84, 0x24, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12	  }, { lwpins }, { 0x12345678,[0xcafe+esp],r11d }
testcase { 0x67, 0x8f, 0xea, 0x18, 0x12, 0x83, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+ebx],r12d }
testcase { 0x67, 0x8f, 0xea, 0x10, 0x12, 0x82, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+edx],r13d }
testcase { 0x67, 0x8f, 0xea, 0x08, 0x12, 0x81, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+ecx],r14d }
testcase { 0x67, 0x8f, 0xea, 0x00, 0x12, 0x80, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpins }, { 0x12345678,[0xcafe+eax],r15d }
testcase { 0x67, 0x8f, 0xca, 0x78, 0x12, 0x8f, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+r15d],eax }
testcase { 0x67, 0x8f, 0xca, 0x70, 0x12, 0x8e, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+r14d],ecx }
testcase { 0x67, 0x8f, 0xca, 0x68, 0x12, 0x8d, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+r13d],edx }
testcase { 0x67, 0x8f, 0xca, 0x60, 0x12, 0x8c, 0x24, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12	  }, { lwpval }, { 0x12345678,[0xcafe+r12d],ebx }
testcase { 0x67, 0x8f, 0xca, 0x58, 0x12, 0x8b, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+r11d],esp }
testcase { 0x67, 0x8f, 0xca, 0x50, 0x12, 0x8a, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+r10d],ebp }
testcase { 0x67, 0x8f, 0xca, 0x48, 0x12, 0x89, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+r9d],esi }
testcase { 0x67, 0x8f, 0xca, 0x40, 0x12, 0x88, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+r8d],edi }
testcase { 0x67, 0x8f, 0xea, 0x38, 0x12, 0x8f, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+edi],r8d }
testcase { 0x67, 0x8f, 0xea, 0x30, 0x12, 0x8e, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+esi],r9d }
testcase { 0x67, 0x8f, 0xea, 0x28, 0x12, 0x8d, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+ebp],r10d }
testcase { 0x67, 0x8f, 0xea, 0x20, 0x12, 0x8c, 0x24, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12	  }, { lwpval }, { 0x12345678,[0xcafe+esp],r11d }
testcase { 0x67, 0x8f, 0xea, 0x18, 0x12, 0x8b, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+ebx],r12d }
testcase { 0x67, 0x8f, 0xea, 0x10, 0x12, 0x8a, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+edx],r13d }
testcase { 0x67, 0x8f, 0xea, 0x08, 0x12, 0x89, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+ecx],r14d }
testcase { 0x67, 0x8f, 0xea, 0x00, 0x12, 0x88, 0xfe, 0xca, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12		  }, { lwpval }, { 0x12345678,[0xcafe+eax],r15d }
