/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Event;
import java.awt.Font;
import java.awt.MenuContainer;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuComponentPeer;
import java.io.Serializable;

public abstract class MenuComponent
implements Serializable {
    transient MenuComponentPeer peer;
    transient MenuContainer parent;
    Font font;
    String name;
    boolean newEventsOnly = false;
    static final String actionListenerK = "actionL";
    static final String itemListenerK = "itemL";
    private static final long serialVersionUID = -4536902356223894379L;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public MenuContainer getParent() {
        return this.parent;
    }

    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            return menuContainer.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void removeNotify() {
        MenuComponentPeer menuComponentPeer = this.peer;
        if (menuComponentPeer != null) {
            this.peer = null;
            menuComponentPeer.dispose();
        }
    }

    public boolean postEvent(Event event) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            menuContainer.postEvent(event);
        }
        return false;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.newEventsOnly || this.parent != null && this.parent instanceof MenuComponent && ((MenuComponent)((Object)this.parent)).newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
                return;
            }
            if (aWTEvent instanceof ActionEvent && this.parent != null) {
                ((MenuComponent)((Object)this.parent)).dispatchEvent(new ActionEvent(this.parent, aWTEvent.getID(), ((ActionEvent)aWTEvent).getActionCommand()));
                return;
            }
        } else {
            Event event = aWTEvent.convertToOld();
            if (event != null) {
                this.postEvent(event);
            }
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        return false;
    }

    protected void processEvent(AWTEvent aWTEvent) {
    }

    protected String paramString() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

