#ifndef _SYS_STAT_H
#define _SYS_STAT_H

#include <features.h>
#include <sys/types.h>
#include <linux/time.h>
#undef __NOT_KERNEL
#define __NOT_KERNEL
#include <linux/stat.h>
#undef __NOT_KERNEL

__BEGIN_DECLS

#ifdef COFF_LIBRARY
#define old_stat stat
#endif

typedef unsigned short old_ino_t;

struct old_stat {
	dev_t   st_dev;
	old_ino_t   st_ino;
	umode_t st_mode;
	nlink_t st_nlink;
	uid_t   st_uid;
	gid_t   st_gid;
	dev_t   st_rdev;
	off_t   st_size;
	time_t  st_atime;
	time_t  st_mtime;
	time_t  st_ctime;
};

#ifdef ELF_LIBRARY

#define R3_MKNOD_VERSION 1     /* SVr3 */
#define R4_MKNOD_VERSION 2     /* SVr4 */
#define R3_STAT_VERSION 1      /* SVr3 */
#define R4_STAT_VERSION 2      /* SVr4 */

typedef unsigned long ABI_dev_t;
typedef unsigned long ABI_ino_t;
typedef unsigned long ABI_mode_t;
typedef unsigned long ABI_nlink_t;
typedef long ABI_uid_t;
typedef long ABI_off_t;
typedef struct timeval ABI_timestruc_t;


/*
 * This is the general form of the stat structure in an ABI compliant system.
 */

struct stat {
	ABI_dev_t	st_dev;
	long	st_pad1[3];	 
	ABI_ino_t	st_ino;
	ABI_mode_t	st_mode;
	ABI_nlink_t st_nlink;
	ABI_uid_t 	st_uid;
	ABI_uid_t 	st_gid;
	ABI_dev_t	st_rdev;
	long	st_pad2[2];
	ABI_off_t	st_size;
	long	st_pad3;	 
	ABI_timestruc_t st_atim;	
	ABI_timestruc_t st_mtim;	
	ABI_timestruc_t st_ctim;	
	long	st_blksize;
	long	st_blocks;
	char	st_fstype[ 16 ] ;
	long	st_pad4[8];	 
};

#endif

/* Some synonyms used historically in the kernel and elsewhere */
#define S_IREAD		S_IRUSR /* read permission, owner */
#define S_IWRITE	S_IWUSR /* write permission, owner */
#define S_IEXEC		S_IXUSR /* execute/search permission, owner */

extern int	__chmod __P ((__const char *__path, mode_t __mode));
extern int	chmod __P ((__const char *__path, mode_t __mode));

extern int	__fchmod __P ((int __fildes, mode_t __mode));
extern int	fchmod __P ((int __fildes, mode_t __mode));

extern int	__fstat __P ((int __fildes, struct stat *__stat_buf));
extern int	fstat __P ((int __fildes, struct stat *__stat_buf));

extern int	__mkdir __P ((__const char *__path, mode_t __mode));
extern int	mkdir __P ((__const char *__path, mode_t __mode));

extern int	__mknod __P ((__const char *__path, mode_t __mode,
			dev_t __dev));
extern int	mknod __P ((__const char *__path, mode_t __mode,
			dev_t __dev));

extern int	mkfifo __P ((__const char *__path, mode_t __mode));

extern int	__stat __P ((__const char *__filename,
			struct stat *__stat_buf));
extern int	stat __P ((__const char *__filename,
			struct stat *__stat_buf));

extern int	__lstat __P ((__const char *__filename,
			struct stat *__stat_buf));
extern int	lstat __P ((__const char *__filename,
			struct stat *__stat_buf));

extern mode_t	__umask __P ((mode_t __mask));
extern mode_t	umask __P ((mode_t __mask));

#ifdef ELF_LIBRARY

extern inline int stat(const char * path, struct stat * statbuf)
{
  return _xstat(R4_STAT_VERSION, path, statbuf);
}

extern inline int lstat(const char * path, struct stat * statbuf)
{
  return _lxstat(R4_STAT_VERSION, path, statbuf);
}

extern inline int fstat(int fd, struct stat * statbuf)
{
  return _fxstat(R4_STAT_VERSION, fd, statbuf);
}

#endif

__END_DECLS

#endif
