.TH XSPREAD 1 LOCAL
.SH NAME
xspread \- X Windows spreadsheet
.SH COMMAND LINE
xspread [-h] [-c] [-m] [-n] [-r] [-x] [-fn font] [
.I file
]
.SH SUMMARY DESCRIPTION
    The program xspread is a public domain spreadsheet which runs under X 
Windows.  You must be using an X Windows terminal to be able to run this 
program.  We are working on makeing it use the ascii screen if it cannot
find an X display to use.

.na    The
.B Xspread Reference Manual
gives complete documentation for the program.  The LaTeX source copy
for this manual is in the file xspread.tex. 
.ad b

    Xspread supports many standard spreadsheet features.  
    Among these are:
    * Cell entry and editing.
    * Worksheet size:  702 columns by unlimited rows.
    * File reading and writing.
    * File encryption.
    * Absolute and relative cell references.
    * Numeric and label (i.e.character string) data in 
      cells.
    * Left or right justification for labels.
    * Row and column insertion and deletion.
    * Hiding and unhiding of rows and columns.
    * Range names.
    * Manual or automatic recalculation.
    * Numeric operators (+, -, *, /, ^(exponentiation), 
      %(remaindering))
    * Relational operators (<, <=, >, >=, =, !=(not equal))
    * Logical (or, Boolean) operators (&(and), |(or), 
      ~(not))
    * Function references.
    * Graphs (XY, Bar, Stack Bar, Pie and Line graphs)
    * Matrix Operations (Transpose, Multiply, Add, Subtract
      and Inversion)
    * Cursor positioning with mouse
    * Menu item selection with mouse
    * References to external programs.  These are called 
      external functions. 

    The structure and operation of the spreadsheet is similar to but not 
identical with popular spreadsheets such as Lotus 1-2-3 and its clones.  Like 
other spreadsheets, the workspace is arranged into rows and columns of cells.  
Each cell can contain a number, a label (i.e. character string), or a formula 
which evaluates to a number or label.

    You can start the program with or without specifying a file to be read in.  
This file must be a saved worksheet.  If a file is specified on the command 
line, xspread attempts to locate and read in the file.  If it is successful, 
xspread starts with the file's contents in the workspace.  If it is 
unsuccessful or no file is specified on the command line, xspread starts with 
the workspace empty.

    For a tutorial of the spreadsheet program, run one of the demo
files: demo, demo_math, demo_matrix, see the file Sample_Run in the 
doc directory.
.SH Options 
.TP 8
\-c
Recalculation is done in column order.  When xspread recalculates, it will 
start at the top of the leftmost column, and recalculate the all the cells 
from top to bottom.  Then, it will recalculate the next column in the same 
order.  It will continue in this fashion until it has recalculated the 
rightmost column.
Xspread does NOT support natural order recalculation.

Default:  Row order recalculation.
.TP
\-h
Display command line help.
.TP
\-m
Start with manual recalculation.  With this option, the spreadsheet will 
recalculate values only when the "@" command is used.  With automatic 
recalculation, the spreadsheet recalculates values whenever a cells contents 
change.

Default:  Automatic recalculation.
.TP
\-n
Standard Data entry mode.  In this mode the user must specify if the
data entry item is numeric or a label.  To single Xspread that
the item is a number, the first character has to be a "=".  To specify
that the data is a label, the first character has to be a quote (").

* If the first character is a numeral, a "+" sign, or a "-" sign, the cell 
contains a number.

* If the first character is a greater than sign (>), less than sign (<), or 
double quote ("), the cell contains a label.

* If it is anything else, the character is a command to xspread.

With standard entry mode, you must use the first character to tell xspread 
whether the cell is a number or a label.

* If the cell is to be a number, the first character must be an "=" sign.

* If the cell is to be a label, the first character must be a double quote 
("), less than sign (<), or greater than sign (>).

Default:  Standard data entry mode.
.TP
\-r
Recalculation is done in row order.  When xspread recalculates, it will start 
at the left of the topmost row, and recalculate all the cells from left to 
right.  Then, it will recalculate the next row in the same order.  It will 
continue in this fashion until it has recalculated the bottommost row.
Xspread does NOT support natural order recalculation.

Default:  Row order recalculation.
.TP
\-x
Use encryption when reading and writing files.

Default:  Do not use encryption.
.SH SEE ALSO
    sc(1), bc(1), dc(1), crypt(1)
.SH BUGS
    Xspread saves only one value from any call to external functions via 
@ext().  If @ext() is used more than once in a spreadsheet and external 
functions are enabled and then disabled, the last returned value pops up in 
several places.
