.TH Perspective 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Perspective \- visible portion of an interactor
.SH SYNOPSIS
.B #include <InterViews/perspective.h>
.SH DESCRIPTION
A perspective object describes which part of an interactor's total display
area is visible in the interactor's canvas.
The main use of perspectives is for
scrolling, panning, and zooming interactors.
The member variables (\fIx0\fP,\ \fIy0\fP) define 
the origin of the interactor's display area; \fIwidth\fP and \fIheight\fP
define the total height of the area.
The member variables (\fIcurx\fP,\ \fIcury\fP) define
the lower-left corner of the interactor's canvas relative
to the total area;
\fIcurwidth\fP and \fIcurheight\fP define how much of the total area
is displayed in the canvas.
.PP
The member variables \fIsx\fP, \fIsy\fP, \fIlx\fP, and \fIly\fP
specify small and large increments in each dimension.
These increments are used by a scroller to implement line and page scrolling.
.SH PUBLIC OPERATIONS
.TP
.B "Perspective()"
Define a new perspective with all member variables initialized to zero.
.TP
.B "void Attach(Interactor*)"
Add to the list of interactors that are interested in updates
to the perspective.
These interactors reflect the perspective visually;
examples include scrollers and sliders.
.TP
.B "void Detach(Interactor*)"
Remove an interactor from the list of those interested in updates.
This operation should be called from the interactor's destructor.
.TP
.B "void Init(Coord x0, Coord y0, Coord width, Coord height)"
Initialize the perspective display area.
.TP
.B "void Update()"
Notify all the interactors interested in the perspective
that it has changed.
The perspective's interactor should call Update after modifying
its perspective.
.SH SEE ALSO
Adjuster(3I), Interactor(3I), Panner(3I), Scroller(3I)
