.TH Resource 3I "" "InterViews Reference Manual"
.SH NAME
Resource \- shared object
.SH SYNOPSIS
.B #include <InterViews/resource.h>
.SH DESCRIPTION
.B Resource
is a class that provides a simple form of reference counting for
shared objects.
Every resource has a reference count that is initially set to zero and
must be explicitly incremented through a call to Reference.
A resource should not be deleted like other objects; instead, the static
member function unref should be used to unreference the object.
.PP
When a resource is unreferenced, the reference count is decremented
unless it is already zero.  If the count is zero, the object is destroyed.
.SH PUBLIC OPERATIONS
.TP
.B "Resource()"
Create a new resource object with its reference count set to zero.
.TP
.B "void ref()"
Increment the resource's reference count.
.TP
.B "void unref()"
Decrement the resource's reference count, if it is positive, and
delete this if the count is zero.
.TP
.B "static void ref(Resource*)"
If the resource is not nil, call ref on it.
Otherwise do nothing.
.TP
.B "static void unref(Resource*)"
If the resource is not nil, call unref on it.
Otherwise do nothing.
.TP
.B "void Reference()"
This function is equivalent to ref and is provided solely
for backward compatibility.
It will be removed in a future version.
.TP
.B "void Unreference()"
This function is equivalent to unref and is provided solely
for backward compatibility.
It will be removed in a future version.
.SH FRIEND OPERATIONS
.TP
.B "void Unref(Resource*)"
This function is equivalent to static unref and is provided
solely for backward compatibility.
It will be removed in a future version.
.SH BUGS
This scheme relies on manual referencing, which is more efficient,
but also more dangerous.
.PP
When garbage collection is supported by the runtime system,
resources will be unnecessary.
