/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils.lite;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.jmlc.Connection;
import org.apache.sysml.api.jmlc.PreparedScript;
import org.apache.sysml.api.jmlc.ResultVariables;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.utils.lite.BuildLite;

public class BuildLiteExecution {
    private static Logger log = Logger.getLogger(BuildLiteExecution.class);
    private static final String ROOT = "functions/jmlc/temp/";
    private static String _rootPrefix = null;

    public static void setRootPrefix(String prefix) {
        _rootPrefix = prefix;
    }

    public static String getRoot() {
        return _rootPrefix != null ? _rootPrefix + ROOT : ROOT;
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        log.setLevel(Level.DEBUG);
        BuildLiteExecution.jmlcHelloWorld();
        BuildLiteExecution.jmlcScoringExample();
        BuildLiteExecution.jmlcUnivariateStatistics();
        BuildLiteExecution.jmlcWriteMatrix();
        BuildLiteExecution.jmlcReadMatrix();
        BuildLiteExecution.jmlcBasics();
        BuildLiteExecution.jmlcL2SVM();
        BuildLiteExecution.jmlcLinReg();
        BuildLiteExecution.jmlcALS();
        BuildLiteExecution.jmlcKmeans();
        BuildLiteExecution.jmlcTests();
        BuildLite.createLiteJar(true);
    }

    public static void jmlcHelloWorld() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        PreparedScript script = conn.prepareScript("print('hello world');", new String[0], new String[0], false);
        script.executeScript();
        conn.close();
    }

    public static void jmlcScoringExample() throws Exception {
        String scriptString = "X = read(\"./tmp/X\", rows=-1, cols=-1);\nW = read(\"./tmp/W\", rows=-1, cols=-1);\n\nnumRows = nrow(X);\nnumCols = ncol(X);\nb = W[numCols+1,]\nscores = X %*% W[1:numCols,] + b;\npredicted_y = rowIndexMax(scores);\n\nprint('pred:' + toString(predicted_y))\n\nwrite(predicted_y, \"./tmp\", format=\"text\");\n";
        File file = new File(BuildLiteExecution.getRoot() + "scoring-example.dml");
        System.out.println(file.toString());
        FileUtils.writeStringToFile(file, scriptString);
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        String dml = conn.readScript(BuildLiteExecution.getRoot() + "scoring-example.dml");
        PreparedScript script = conn.prepareScript(dml, new String[]{"W", "X"}, new String[]{"predicted_y"}, false);
        double[][] mtx = BuildLiteExecution.matrix(4, 3, new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        double[][] result = null;
        script.setMatrix("W", mtx);
        script.setMatrix("X", BuildLiteExecution.randomMatrix(3, 3, -1.0, 1.0, 0.7));
        result = script.executeScript().getMatrix("predicted_y");
        log.debug(BuildLiteExecution.displayMatrix(result));
        script.setMatrix("W", mtx);
        script.setMatrix("X", BuildLiteExecution.randomMatrix(3, 3, -1.0, 1.0, 0.7));
        result = script.executeScript().getMatrix("predicted_y");
        log.debug(BuildLiteExecution.displayMatrix(result));
        script.setMatrix("W", mtx);
        script.setMatrix("X", BuildLiteExecution.randomMatrix(3, 3, -1.0, 1.0, 0.7));
        result = script.executeScript().getMatrix("predicted_y");
        log.debug(BuildLiteExecution.displayMatrix(result));
        conn.close();
    }

    public static void jmlcUnivariateStatistics() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        String dml = conn.readScript("scripts/algorithms/Univar-Stats.dml");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("$CONSOLE_OUTPUT", "TRUE");
        PreparedScript script = conn.prepareScript(dml, m, new String[]{"A", "K"}, new String[]{"baseStats"}, false);
        double[][] data = new double[100][4];
        for (int i = 0; i < 100; ++i) {
            int one = ThreadLocalRandom.current().nextInt(0, 101);
            int two = ThreadLocalRandom.current().nextInt(0, 101);
            int three = ThreadLocalRandom.current().nextInt(0, 101);
            int four = ThreadLocalRandom.current().nextInt(1, 3);
            double[] row = new double[]{one, two, three, four};
            data[i] = row;
        }
        log.debug(BuildLiteExecution.displayMatrix(data));
        double[][] types = BuildLiteExecution.matrix(1, 4, new double[]{1.0, 1.0, 1.0, 2.0});
        script.setMatrix("A", data);
        script.setMatrix("K", types);
        double[][] baseStats = script.executeScript().getMatrix("baseStats");
        log.debug(BuildLiteExecution.displayMatrix(baseStats));
        conn.close();
    }

    public static void jmlcWriteMatrix() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        PreparedScript script = conn.prepareScript("x=matrix('1 2 3 4',rows=2,cols=2);write(x,'" + BuildLiteExecution.getRoot() + "x.csv',format='csv');", new String[0], new String[0], false);
        script.executeScript();
        String scriptString = "m = matrix('1 2 3 0 0 0 7 8 9 0 0 0', rows=4, cols=3)\nwrite(m, '" + BuildLiteExecution.getRoot() + "m.txt', format='text')\nwrite(m, '" + BuildLiteExecution.getRoot() + "m.mm', format='mm')\nwrite(m, '" + BuildLiteExecution.getRoot() + "m.csv', format='csv')\nwrite(m, '" + BuildLiteExecution.getRoot() + "m.binary', format='binary')\n";
        script = conn.prepareScript(scriptString, new String[0], new String[0], false);
        script.executeScript();
        conn.close();
    }

    public static void jmlcReadMatrix() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        PreparedScript script = conn.prepareScript("x=read('" + BuildLiteExecution.getRoot() + "x.csv',format='csv');y=x*2;print(toString(y));", new String[0], new String[0], false);
        script.executeScript();
        String scriptString = "m = read('" + BuildLiteExecution.getRoot() + "m.csv',format='csv')\nprint(toString(m))\nprint('min:' + min(m))\nprint('max:' + max(m))\nprint('sum:' + sum(m))\nmRowSums = rowSums(m)\nfor (i in 1:nrow(mRowSums)) {\n    print('row ' + i + ' sum:' + as.scalar(mRowSums[i,1]))\n}\nmColSums = colSums(m)\nfor (i in 1:ncol(mColSums)) {\n    print('col ' + i + ' sum:' + as.scalar(mColSums[1,i]))\n}\n";
        script = conn.prepareScript(scriptString, new String[0], new String[0], false);
        script.executeScript();
        conn.close();
    }

    public static void jmlcBasics() throws Exception {
        String dml = "A = matrix(\"1 2 3 4 5 6\", rows=3, cols=2)\nprint(toString(A))\nB = A + 4\nB = t(B)\nprint(toString(B))\nC = A %*% B\nprint(toString(C))\nD = matrix(5, rows=nrow(C), cols=ncol(C))\nD = (C - D) / 2\nprint(toString(D))\n\nA = matrix(\"1 2 3 4 5 6 7 8 9\", rows=3, cols=3)\nprint(toString(A))\nB = A[3,3]\nprint(toString(B))\nC = A[2,]\nprint(toString(C))\nD = A[,3]\nprint(toString(D))\nE = A[2:3,1:2]\nprint(toString(E))\n\ni = 1\nwhile (i <= 3) {\n if (i == 1) {\n print('hello')\n } else if (i == 2) {\n print('world')\n } else {\n print('!!!')\n }\n i = i + 1\n}\n\nA = matrix(\"1 2 3 4 5 6\", rows=3, cols=2)\n\nfor (i in 1:nrow(A)) {\n print(\"for A[\" + i + \",1]:\" + as.scalar(A[i,1]))\n}\n\nparfor(i in 1:nrow(A)) {\n print(\"parfor A[\" + i + \",1]:\" + as.scalar(A[i,1]))\n}\n\ndoSomething = function(matrix[double] mat) return (matrix[double] ret) {\n additionalCol = matrix(1, rows=nrow(mat), cols=1) # 1x3 matrix with 1 values\n ret = cbind(mat, additionalCol) # concatenate column to matrix\n ret = cbind(ret, seq(0, 2, 1)) # concatenate column (0,1,2) to matrix\n ret = cbind(ret, rowMaxs(ret)) # concatenate column of max row values to matrix\n ret = cbind(ret, rowSums(ret)) # concatenate column of row sums to matrix\n}\n\nA = rand(rows=3, cols=2, min=0, max=2) # random 3x2 matrix with values 0 to 2\nB = doSomething(A)\nwrite(A, \"" + BuildLiteExecution.getRoot() + "A.csv\", format=\"csv\")\nwrite(B, \"" + BuildLiteExecution.getRoot() + "B.csv\", format=\"csv\")\n";
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        PreparedScript script = conn.prepareScript(dml, new String[0], new String[0], false);
        script.executeScript();
        conn.close();
    }

    public static void jmlcL2SVM() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        String dml = conn.readScript("scripts/algorithms/l2-svm.dml");
        PreparedScript l2svm = conn.prepareScript(dml, new String[]{"X", "Y", "fmt", "Log"}, new String[]{"w", "debug_str"}, false);
        double[][] trainData = new double[150][3];
        for (int i = 0; i < 150; ++i) {
            int one = ThreadLocalRandom.current().nextInt(0, 101);
            int two = ThreadLocalRandom.current().nextInt(0, 101);
            int three = ThreadLocalRandom.current().nextInt(0, 101);
            double[] row = new double[]{one, two, three};
            trainData[i] = row;
        }
        l2svm.setMatrix("X", trainData);
        log.debug(BuildLiteExecution.displayMatrix(trainData));
        double[][] trainLabels = new double[150][1];
        for (int i = 0; i < 150; ++i) {
            int one = ThreadLocalRandom.current().nextInt(1, 3);
            double[] row = new double[]{one};
            trainLabels[i] = row;
        }
        l2svm.setMatrix("Y", trainLabels);
        log.debug(BuildLiteExecution.displayMatrix(trainLabels));
        l2svm.setScalar("fmt", "csv");
        l2svm.setScalar("Log", "temp/l2-svm-log.csv");
        ResultVariables l2svmResults = l2svm.executeScript();
        double[][] model = l2svmResults.getMatrix("w");
        log.debug("MODEL:");
        log.debug(BuildLiteExecution.displayMatrix(model));
        String debugString = l2svmResults.getString("debug_str");
        log.debug("DEBUG STRING:");
        log.debug(debugString);
        String s = conn.readScript("scripts/algorithms/l2-svm-predict.dml");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("$Y", "temp/1.csv");
        m.put("$confusion", "temp/2.csv");
        m.put("$scores", "temp/3.csv");
        PreparedScript l2svmPredict = conn.prepareScript(s, m, new String[]{"X", "Y", "w", "fmt"}, new String[]{"scores", "confusion_mat"}, false);
        double[][] testData = new double[150][3];
        for (int i = 0; i < 150; ++i) {
            int one = ThreadLocalRandom.current().nextInt(0, 101);
            int two = ThreadLocalRandom.current().nextInt(0, 101);
            int three = ThreadLocalRandom.current().nextInt(0, 101);
            double[] row = new double[]{one, two, three};
            testData[i] = row;
        }
        l2svmPredict.setMatrix("X", testData);
        double[][] testLabels = new double[150][1];
        for (int i = 0; i < 150; ++i) {
            int one = ThreadLocalRandom.current().nextInt(1, 3);
            double[] row = new double[]{one};
            testLabels[i] = row;
        }
        l2svmPredict.setMatrix("Y", testLabels);
        l2svmPredict.setMatrix("w", model);
        l2svmPredict.setScalar("fmt", "csv");
        ResultVariables l2svmPredictResults = l2svmPredict.executeScript();
        double[][] scores = l2svmPredictResults.getMatrix("scores");
        log.debug("SCORES:");
        log.debug(BuildLiteExecution.displayMatrix(scores));
        double[][] confusionMatrix = l2svmPredictResults.getMatrix("confusion_mat");
        log.debug("CONFUSION MATRIX:");
        log.debug(BuildLiteExecution.displayMatrix(confusionMatrix));
        conn.close();
    }

    public static void jmlcLinReg() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        String linRegDS = conn.readScript("scripts/algorithms/LinearRegDS.dml");
        PreparedScript linRegDSScript = conn.prepareScript(linRegDS, new String[]{"X", "y"}, new String[]{"beta_out"}, false);
        double[][] trainData = new double[500][3];
        for (int i = 0; i < 500; ++i) {
            double one = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double two = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double three = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double[] row = new double[]{one, two, three};
            trainData[i] = row;
        }
        linRegDSScript.setMatrix("X", trainData);
        log.debug(BuildLiteExecution.displayMatrix(trainData));
        double[][] trainLabels = new double[500][1];
        for (int i = 0; i < 500; ++i) {
            double one = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double[] row = new double[]{one};
            trainLabels[i] = row;
        }
        linRegDSScript.setMatrix("y", trainLabels);
        log.debug(BuildLiteExecution.displayMatrix(trainLabels));
        ResultVariables linRegDSResults = linRegDSScript.executeScript();
        double[][] dsBetas = linRegDSResults.getMatrix("beta_out");
        log.debug("DS BETAS:");
        log.debug(BuildLiteExecution.displayMatrix(dsBetas));
        String linRegCG = conn.readScript("scripts/algorithms/LinearRegCG.dml");
        PreparedScript linRegCGScript = conn.prepareScript(linRegCG, new String[]{"X", "y"}, new String[]{"beta_out"}, false);
        linRegCGScript.setMatrix("X", trainData);
        linRegCGScript.setMatrix("y", trainLabels);
        ResultVariables linRegCGResults = linRegCGScript.executeScript();
        double[][] cgBetas = linRegCGResults.getMatrix("beta_out");
        log.debug("CG BETAS:");
        log.debug(BuildLiteExecution.displayMatrix(cgBetas));
        String glmPredict = conn.readScript("scripts/algorithms/GLM-predict.dml");
        PreparedScript glmPredictScript = conn.prepareScript(glmPredict, new String[]{"X", "Y", "B_full"}, new String[]{"means"}, false);
        double[][] testData = new double[500][3];
        for (int i = 0; i < 500; ++i) {
            double one = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double two = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double three = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double[] row = new double[]{one, two, three};
            testData[i] = row;
        }
        glmPredictScript.setMatrix("X", testData);
        double[][] testLabels = new double[500][1];
        for (int i = 0; i < 500; ++i) {
            double one = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            double[] row = new double[]{one};
            testLabels[i] = row;
        }
        glmPredictScript.setMatrix("Y", testLabels);
        glmPredictScript.setMatrix("B_full", cgBetas);
        ResultVariables glmPredictResults = glmPredictScript.executeScript();
        double[][] means = glmPredictResults.getMatrix("means");
        log.debug("GLM PREDICT MEANS:");
        log.debug(BuildLiteExecution.displayMatrix(means));
        conn.close();
    }

    public static void jmlcALS() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        String dataGen = conn.readScript("scripts/datagen/genRandData4ALS.dml");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("$rows", "1000");
        m.put("$cols", "1000");
        m.put("$rank", "100");
        m.put("$nnz", "10000");
        PreparedScript dataGenScript = conn.prepareScript(dataGen, m, new String[0], new String[]{"X", "W", "H"}, false);
        ResultVariables dataGenResults = dataGenScript.executeScript();
        double[][] x = dataGenResults.getMatrix("X");
        log.debug(BuildLiteExecution.displayMatrix(x));
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("$rank", "100");
        String alsCg = conn.readScript("scripts/algorithms/ALS-CG.dml");
        PreparedScript alsCgScript = conn.prepareScript(alsCg, m2, new String[]{"X"}, new String[]{"U", "V"}, false);
        alsCgScript.setMatrix("X", x);
        ResultVariables alsCgResults = alsCgScript.executeScript();
        double[][] u = alsCgResults.getMatrix("U");
        log.debug("u:" + u);
        log.debug(BuildLiteExecution.displayMatrix(u));
        double[][] v = alsCgResults.getMatrix("V");
        log.debug("v:" + v);
        log.debug(BuildLiteExecution.displayMatrix(v));
        String alsDs = conn.readScript("scripts/algorithms/ALS-DS.dml");
        PreparedScript alsDsScript = conn.prepareScript(alsDs, m2, new String[]{"V"}, new String[]{"L", "Rt"}, false);
        alsDsScript.setMatrix("V", x);
        ResultVariables alsDsResults = alsDsScript.executeScript();
        double[][] l = alsDsResults.getMatrix("L");
        log.debug("l:" + l);
        log.debug(BuildLiteExecution.displayMatrix(l));
        double[][] rt = alsDsResults.getMatrix("Rt");
        log.debug("rt:" + rt);
        log.debug(BuildLiteExecution.displayMatrix(rt));
        conn.close();
    }

    public static void jmlcKmeans() throws Exception {
        Connection conn = BuildLiteExecution.getConfiguredConnection();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("$k", "5");
        m.put("$isY", "TRUE");
        m.put("$verb", "TRUE");
        String kMeans = conn.readScript("scripts/algorithms/Kmeans.dml");
        PreparedScript kMeansScript = conn.prepareScript(kMeans, m, new String[]{"X"}, new String[]{"C", "Y"}, false);
        double[][] x = BuildLiteExecution.randomMatrix(50, 50, -1.0, 1.0, 0.1);
        kMeansScript.setMatrix("X", x);
        log.debug("X:");
        log.debug(BuildLiteExecution.displayMatrix(x));
        ResultVariables kMeansResults = kMeansScript.executeScript();
        double[][] c = kMeansResults.getMatrix("C");
        log.debug("C:");
        log.debug(BuildLiteExecution.displayMatrix(c));
        double[][] y = kMeansResults.getMatrix("Y");
        log.debug("Y:");
        log.debug(BuildLiteExecution.displayMatrix(y));
        conn.close();
    }

    public static void jmlcTests() {
        try {
            File jmlcTestDir = new File("target/test-classes");
            if (!jmlcTestDir.exists()) {
                log.error("Test class directory could not be found");
                return;
            }
            URL url = jmlcTestDir.toURI().toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader cl = new URLClassLoader(urls);
            Class<?> clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.FrameCastingTest");
            Object obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.FrameDecodeTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.FrameEncodeTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.FrameIndexingAppendTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.FrameLeftIndexingTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.FrameReadMetaTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseSpec");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuseSpec");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReadFrame");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuseReadFrame");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.FrameTransformTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCTransformSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.JMLCInputOutputTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarInputInt");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarInputDouble");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarInputBoolean");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarInputLong");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarInputStringExplicitValueType");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarOutputLong");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarOutputDouble");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarOutputString");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarOutputBoolean");
            BuildLiteExecution.invokeMethod(clazz, obj, "testScalarOutputScalarObject");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.JMLCInputStreamReadTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadMatrixDenseCSV");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadMatrixDenseText");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadMatrixSparseCSV");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadMatrixSparseText");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameDenseCSV");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameDenseText");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameSparseCSV");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameSparseText");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameDenseCSVMeta");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameDenseTextMeta");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameSparseCSVMeta");
            BuildLiteExecution.invokeMethod(clazz, obj, "testInputStreamReadFrameSparseTextMeta");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.MulticlassSVMScoreTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCMulticlassScoreDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCMulticlassScoreSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
            clazz = cl.loadClass("org.apache.sysml.test.integration.functions.jmlc.ReuseModelVariablesTest");
            obj = clazz.newInstance();
            BuildLiteExecution.invokeMethod(clazz, obj, "setUpBase");
            BuildLiteExecution.invokeMethod(clazz, obj, "setUp");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreGLMDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreGLMSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreGLMDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreGLMSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreMSVMDense");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreMSVMSparse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreMSVMDenseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "testJMLCScoreMSVMSparseReuse");
            BuildLiteExecution.invokeMethod(clazz, obj, "tearDown");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void invokeMethod(Class clazz, Object obj, String methodName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = clazz.getMethod(methodName, new Class[0]);
        m.invoke(obj, new Object[0]);
    }

    public static double[][] matrix(int rows, int cols, double[] vals) {
        double[][] matrix = new double[rows][cols];
        if (vals == null || vals.length == 0) {
            return matrix;
        }
        for (int i = 0; i < vals.length; ++i) {
            matrix[i / cols][i % cols] = vals[i];
        }
        return matrix;
    }

    public static double[][] randomMatrix(int rows, int cols, double min, double max, double sparsity) {
        double[][] matrix = new double[rows][cols];
        Random random = new Random(System.currentTimeMillis());
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (random.nextDouble() > sparsity) continue;
                matrix[i][j] = random.nextDouble() * (max - min) + min;
            }
        }
        return matrix;
    }

    public static String displayMatrix(double[][] matrix) {
        try {
            return DataConverter.toString(DataConverter.convertToMatrixBlock(matrix));
        }
        catch (DMLRuntimeException e) {
            return "N/A";
        }
    }

    private static Connection getConfiguredConnection() {
        Connection conn = new Connection(CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION, CompilerConfig.ConfigType.PARALLEL_LOCAL_OR_REMOTE_PARFOR, CompilerConfig.ConfigType.PARALLEL_CP_MATRIX_OPERATIONS);
        return conn;
    }
}

