/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.MetaDataNumItemsByEachReducer;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.util.IndexRange;

public class UtilFunctions {
    public static final double DOUBLE_EPS = Math.pow(2.0, -53.0);
    public static final long ADD_PRIME1 = 99991L;
    public static final int DIVIDE_PRIME = 1405695061;

    public static int intHashCode(int key1, int key2) {
        return 31 * (31 + key1) + key2;
    }

    public static int longHashCode(long key1) {
        return (int)(key1 ^ key1 >>> 32);
    }

    public static int longHashCode(long key1, long key2) {
        int h = 31 + (int)(key1 ^ key1 >>> 32);
        return h * 31 + (int)(key2 ^ key2 >>> 32);
    }

    public static int longHashCode(long key1, long key2, long key3) {
        int h1 = 31 + (int)(key1 ^ key1 >>> 32);
        int h2 = h1 * 31 + (int)(key2 ^ key2 >>> 32);
        return h2 * 31 + (int)(key3 ^ key3 >>> 32);
    }

    public static int nextIntPow2(int in) {
        int expon = in == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(in - 1);
        long pow2 = UtilFunctions.pow(2, expon);
        return (int)(pow2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : pow2);
    }

    public static long pow(int base, int exp) {
        return base == 2 && 0 <= exp && exp < 63 ? 1L << exp : (long)Math.pow(base, exp);
    }

    public static long computeBlockIndex(long cellIndex, int blockSize) {
        return (cellIndex - 1L) / (long)blockSize + 1L;
    }

    public static int computeCellInBlock(long cellIndex, int blockSize) {
        return (int)((cellIndex - 1L) % (long)blockSize);
    }

    public static long computeCellIndex(long blockIndex, int blockSize, int cellInBlock) {
        return (blockIndex - 1L) * (long)blockSize + 1L + (long)cellInBlock;
    }

    public static int computeBlockSize(long len, long blockIndex, long blockSize) {
        long remain = len - (blockIndex - 1L) * blockSize;
        return (int)Math.min(blockSize, remain);
    }

    public static boolean isInBlockRange(MatrixIndexes ix, int brlen, int bclen, long rl, long ru, long cl, long cu) {
        long bRLowerIndex = (ix.getRowIndex() - 1L) * (long)brlen + 1L;
        long bRUpperIndex = ix.getRowIndex() * (long)brlen;
        long bCLowerIndex = (ix.getColumnIndex() - 1L) * (long)bclen + 1L;
        long bCUpperIndex = ix.getColumnIndex() * (long)bclen;
        if (rl > bRUpperIndex || ru < bRLowerIndex) {
            return false;
        }
        return cl <= bCUpperIndex && cu >= bCLowerIndex;
    }

    public static boolean isInFrameBlockRange(Long ix, int brlen, long rl, long ru) {
        return rl <= ix + (long)brlen - 1L && ru >= ix;
    }

    public static boolean isInBlockRange(MatrixIndexes ix, int brlen, int bclen, IndexRange ixrange) {
        return UtilFunctions.isInBlockRange(ix, brlen, bclen, ixrange.rowStart, ixrange.rowEnd, ixrange.colStart, ixrange.colEnd);
    }

    public static boolean isInFrameBlockRange(Long ix, int brlen, int bclen, IndexRange ixrange) {
        return UtilFunctions.isInFrameBlockRange(ix, brlen, ixrange.rowStart, ixrange.rowEnd);
    }

    public static IndexRange getSelectedRangeForZeroOut(IndexedMatrixValue in, int blockRowFactor, int blockColFactor, IndexRange indexRange) {
        IndexRange tempRange = new IndexRange(-1L, -1L, -1L, -1L);
        long topBlockRowIndex = UtilFunctions.computeBlockIndex(indexRange.rowStart, blockRowFactor);
        int topRowInTopBlock = UtilFunctions.computeCellInBlock(indexRange.rowStart, blockRowFactor);
        long bottomBlockRowIndex = UtilFunctions.computeBlockIndex(indexRange.rowEnd, blockRowFactor);
        int bottomRowInBottomBlock = UtilFunctions.computeCellInBlock(indexRange.rowEnd, blockRowFactor);
        long leftBlockColIndex = UtilFunctions.computeBlockIndex(indexRange.colStart, blockColFactor);
        int leftColInLeftBlock = UtilFunctions.computeCellInBlock(indexRange.colStart, blockColFactor);
        long rightBlockColIndex = UtilFunctions.computeBlockIndex(indexRange.colEnd, blockColFactor);
        int rightColInRightBlock = UtilFunctions.computeCellInBlock(indexRange.colEnd, blockColFactor);
        if (in.getIndexes().getRowIndex() < topBlockRowIndex || in.getIndexes().getRowIndex() > bottomBlockRowIndex || in.getIndexes().getColumnIndex() < leftBlockColIndex || in.getIndexes().getColumnIndex() > rightBlockColIndex) {
            tempRange.set(-1L, -1L, -1L, -1L);
            return tempRange;
        }
        tempRange.set(0L, in.getValue().getNumRows() - 1, 0L, in.getValue().getNumColumns() - 1);
        if (topBlockRowIndex == in.getIndexes().getRowIndex()) {
            tempRange.rowStart = topRowInTopBlock;
        }
        if (bottomBlockRowIndex == in.getIndexes().getRowIndex()) {
            tempRange.rowEnd = bottomRowInBottomBlock;
        }
        if (leftBlockColIndex == in.getIndexes().getColumnIndex()) {
            tempRange.colStart = leftColInLeftBlock;
        }
        if (rightBlockColIndex == in.getIndexes().getColumnIndex()) {
            tempRange.colEnd = rightColInRightBlock;
        }
        return tempRange;
    }

    public static IndexRange getSelectedRangeForZeroOut(Pair<Long, FrameBlock> in, int blockRowFactor, int blockColFactor, IndexRange indexRange, long lSrcRowIndex, long lDestRowIndex) {
        int iRowStart = indexRange.rowStart <= lDestRowIndex ? 0 : (int)(indexRange.rowStart - in.getKey());
        int iRowEnd = (int)Math.min(indexRange.rowEnd - lSrcRowIndex, (long)blockRowFactor) - 1;
        int iColStart = UtilFunctions.computeCellInBlock(indexRange.colStart, blockColFactor);
        int iColEnd = UtilFunctions.computeCellInBlock(indexRange.colEnd, blockColFactor);
        return new IndexRange(iRowStart, iRowEnd, iColStart, iColEnd);
    }

    public static long getTotalLength(MetaDataNumItemsByEachReducer metadata) {
        long[] counts = metadata.getNumItemsArray();
        long total = 0L;
        for (long count : counts) {
            total += count;
        }
        return total;
    }

    public static long getLengthForInterQuantile(MetaDataNumItemsByEachReducer metadata, double p) {
        long total = UtilFunctions.getTotalLength(metadata);
        long lpos = (long)Math.ceil((double)total * p);
        long upos = (long)Math.ceil((double)total * (1.0 - p));
        return upos - lpos + 1L;
    }

    public static double parseToDouble(String str) {
        return Double.parseDouble(str);
    }

    public static int parseToInt(String str) {
        int ret = -1;
        ret = str.contains(".") ? UtilFunctions.toInt(Double.parseDouble(str)) : Integer.parseInt(str);
        return ret;
    }

    public static long parseToLong(String str) {
        long ret = -1L;
        ret = str.contains(".") ? UtilFunctions.toLong(Double.parseDouble(str)) : Long.parseLong(str);
        return ret;
    }

    public static int toInt(double val) {
        return (int)Math.floor(val + DOUBLE_EPS);
    }

    public static long toLong(double val) {
        return (long)Math.floor(val + DOUBLE_EPS);
    }

    public static int toInt(Object obj) {
        return obj instanceof Long ? ((Long)obj).intValue() : ((Integer)obj).intValue();
    }

    public static float[] toFloat(double[] data) {
        float[] ret = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = (float)data[i];
        }
        return ret;
    }

    public static long getSeqLength(double from, double to, double incr) {
        return UtilFunctions.getSeqLength(from, to, incr, true);
    }

    public static long getSeqLength(double from, double to, double incr, boolean check) {
        if (check && (Double.isNaN(from) || Double.isNaN(to) || Double.isNaN(incr) || from > to && incr > 0.0 || from < to && incr < 0.0)) {
            throw new RuntimeException("Invalid seq parameters: (" + from + ", " + to + ", " + incr + ")");
        }
        return 1L + (long)Math.floor(to / incr - from / incr);
    }

    public static List<Integer> getSeqList(int low, int up, int incr) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = low; i <= up; i += incr) {
            ret.add(i);
        }
        return ret;
    }

    public static int[] getSeqArray(int low, int up, int incr) {
        int len = (int)UtilFunctions.getSeqLength(low, up, incr);
        int[] ret = new int[len];
        int i = 0;
        int val = low;
        while (i < len) {
            ret[i] = val;
            ++i;
            val += incr;
        }
        return ret;
    }

    public static int roundToNext(int val, int factor) {
        int pval = Math.max(val, factor);
        return (pval + factor - 1) / factor * factor;
    }

    public static Object doubleToObject(Expression.ValueType vt, double in) {
        return UtilFunctions.doubleToObject(vt, in, true);
    }

    public static Object doubleToObject(Expression.ValueType vt, double in, boolean sparse) {
        if (in == 0.0 && sparse) {
            return null;
        }
        switch (vt) {
            case STRING: {
                return String.valueOf(in);
            }
            case BOOLEAN: {
                return in != 0.0;
            }
            case INT: {
                return UtilFunctions.toLong(in);
            }
            case DOUBLE: {
                return in;
            }
        }
        throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static Object stringToObject(Expression.ValueType vt, String in) {
        if (in == null) {
            return null;
        }
        switch (vt) {
            case STRING: {
                return in;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(in);
            }
            case INT: {
                return Long.parseLong(in);
            }
            case DOUBLE: {
                return Double.parseDouble(in);
            }
        }
        throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static double objectToDouble(Expression.ValueType vt, Object in) {
        if (in == null) {
            return 0.0;
        }
        switch (vt) {
            case STRING: {
                return !((String)in).isEmpty() ? Double.parseDouble((String)in) : 0.0;
            }
            case BOOLEAN: {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            case INT: {
                return ((Long)in).longValue();
            }
            case DOUBLE: {
                return (Double)in;
            }
        }
        throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static String objectToString(Object in) {
        return in != null ? in.toString() : null;
    }

    public static String objectToString(Object in, boolean ignoreNull) {
        String strReturn = UtilFunctions.objectToString(in);
        if (strReturn == null) {
            return strReturn;
        }
        if (ignoreNull) {
            if (in instanceof Double && (Double)in == 0.0) {
                return null;
            }
            if (in instanceof Long && (Long)in == 0L) {
                return null;
            }
            if (in instanceof Boolean && !((Boolean)in).booleanValue()) {
                return null;
            }
            if (in instanceof String && ((String)in).trim().length() == 0) {
                return null;
            }
            return strReturn;
        }
        return strReturn;
    }

    public static Object objectToObject(Expression.ValueType vt, Object in) {
        if (in instanceof Double && vt == Expression.ValueType.DOUBLE || in instanceof Long && vt == Expression.ValueType.INT || in instanceof Boolean && vt == Expression.ValueType.BOOLEAN || in instanceof String && vt == Expression.ValueType.STRING) {
            return in;
        }
        return UtilFunctions.stringToObject(vt, UtilFunctions.objectToString(in));
    }

    public static Object objectToObject(Expression.ValueType vt, Object in, boolean ignoreNull) {
        String str = UtilFunctions.objectToString(in, ignoreNull);
        if (str == null || vt == Expression.ValueType.STRING) {
            return str;
        }
        return UtilFunctions.stringToObject(vt, str);
    }

    public static int compareTo(Expression.ValueType vt, Object in1, Object in2) {
        if (in1 == null && in2 == null) {
            return 0;
        }
        if (in1 == null) {
            return -1;
        }
        if (in2 == null) {
            return 1;
        }
        switch (vt) {
            case STRING: {
                return ((String)in1).compareTo((String)in2);
            }
            case BOOLEAN: {
                return ((Boolean)in1).compareTo((Boolean)in2);
            }
            case INT: {
                return ((Long)in1).compareTo((Long)in2);
            }
            case DOUBLE: {
                return ((Double)in1).compareTo((Double)in2);
            }
        }
        throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
    }

    public static int compareVersion(String version1, String version2) {
        String[] partsv1 = version1.split("\\.");
        String[] partsv2 = version2.split("\\.");
        int len = Math.min(partsv1.length, partsv2.length);
        for (int i = 0; i < partsv1.length && i < len; ++i) {
            Integer iv2;
            Integer iv1 = Integer.parseInt(partsv1[i]);
            if (iv1.compareTo(iv2 = Integer.valueOf(Integer.parseInt(partsv2[i]))) == 0) continue;
            return iv1.compareTo(iv2);
        }
        return 0;
    }

    public static boolean isIntegerNumber(String str) {
        byte[] c = str.getBytes();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= 48 && c[i] <= 57) continue;
            return false;
        }
        return true;
    }

    public static byte max(byte[] array) {
        byte ret = -128;
        for (int i = 0; i < array.length; ++i) {
            ret = array[i] > ret ? array[i] : ret;
        }
        return ret;
    }

    public static String unquote(String s) {
        if (s != null && s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public static long parseMemorySize(String arg) {
        if (arg.endsWith("g") || arg.endsWith("G")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L * 1024L;
        }
        if (arg.endsWith("m") || arg.endsWith("M")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L * 1024L;
        }
        if (arg.endsWith("k") || arg.endsWith("K")) {
            return Long.parseLong(arg.substring(0, arg.length() - 1)) * 1024L;
        }
        return Long.parseLong(arg.substring(0, arg.length()));
    }

    public static String formatMemorySize(long arg) {
        if (arg >= 0x40000000L) {
            return String.format("%d GB", arg / 0x40000000L);
        }
        if (arg >= 0x100000L) {
            return String.format("%d MB", arg / 0x100000L);
        }
        if (arg >= 1024L) {
            return String.format("%d KB", arg / 1024L);
        }
        return String.format("%d", arg);
    }

    public static double getDouble(Object obj) {
        return obj instanceof Double ? (Double)obj : Double.parseDouble(obj.toString());
    }

    public static boolean isNonZero(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj != 0.0;
        }
        String sobj = obj.toString();
        return !sobj.equals("0") && !sobj.equals("0.0");
    }

    public static int computeNnz(double[] a, int ai, int len) {
        int lnnz = 0;
        for (int i = ai; i < ai + len; ++i) {
            lnnz += a[i] != 0.0 ? 1 : 0;
        }
        return lnnz;
    }

    public static Expression.ValueType[] nCopies(int n, Expression.ValueType vt) {
        Expression.ValueType[] ret = new Expression.ValueType[n];
        Arrays.fill((Object[])ret, (Object)vt);
        return ret;
    }

    public static int frequency(Expression.ValueType[] schema, Expression.ValueType vt) {
        int count = 0;
        for (Expression.ValueType tmp : schema) {
            count += tmp.equals((Object)vt) ? 1 : 0;
        }
        return count;
    }

    public static Expression.ValueType[] copyOf(Expression.ValueType[] schema1, Expression.ValueType[] schema2) {
        return (Expression.ValueType[])ArrayUtils.addAll((Object[])schema1, (Object[])schema2);
    }

    public static int countNonZeros(double[] data, int pos, int len) {
        int ret = 0;
        for (int i = pos; i < pos + len; ++i) {
            ret += data[i] != 0.0 ? 1 : 0;
        }
        return ret;
    }

    public static boolean containsZero(double[] data, int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            if (data[i] != 0.0) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> List<T> asList(List<T> ... inputs) {
        ArrayList<T> ret = new ArrayList<T>();
        for (List<T> list : inputs) {
            ret.addAll(list);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(List<T> ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        for (List<T> list : inputs) {
            ret.addAll(list);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T[] ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        T[][] TArray = inputs;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] input;
            for (T element : input = TArray[i]) {
                ret.add(element);
            }
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        for (T element : inputs) {
            ret.add(element);
        }
        return ret;
    }
}

