/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import org.apache.hadoop.io.Writable;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.FastBufferedDataInputStream;
import org.apache.sysml.runtime.util.FastBufferedDataOutputStream;

public class LocalFileUtils {
    public static final int BUFFER_SIZE = 8192;
    private static IDSequence _seq = null;
    private static String _workingDir = null;
    public static final String CATEGORY_CACHE = "cache";
    public static final String CATEGORY_PARTITIONING = "partitioning";
    public static final String CATEGORY_RESULTMERGE = "resultmerge";
    public static final String CATEGORY_WORK = "work";
    public static final String CATEGORY_CODEGEN = "codegen";

    public static MatrixBlock readMatrixBlockFromLocal(String fname) throws IOException {
        return (MatrixBlock)LocalFileUtils.readWritableFromLocal(fname, new MatrixBlock());
    }

    public static MatrixBlock readMatrixBlockFromLocal(String fname, MatrixBlock reuse) throws IOException {
        return (MatrixBlock)LocalFileUtils.readWritableFromLocal(fname, reuse);
    }

    public static FrameBlock readFrameBlockFromLocal(String fname) throws IOException {
        return (FrameBlock)LocalFileUtils.readWritableFromLocal(fname, new FrameBlock());
    }

    public static CacheBlock readCacheBlockFromLocal(String fname, boolean matrix) throws IOException {
        return (CacheBlock)LocalFileUtils.readWritableFromLocal(fname, matrix ? new MatrixBlock() : new FrameBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writable readWritableFromLocal(String fname, Writable ret) throws IOException {
        FileInputStream fis = new FileInputStream(fname);
        FilterInputStream in = !(ret instanceof MatrixBlock) ? new DataInputStream(new BufferedInputStream(fis, 8192)) : new FastBufferedDataInputStream(fis, 8192);
        try {
            ret.readFields((DataInput)((Object)in));
        }
        finally {
            IOUtilFunctions.closeSilently(in);
            IOUtilFunctions.closeSilently(fis);
        }
        return ret;
    }

    public static MatrixBlock readMatrixBlockFromStream(InputStream is) throws IOException {
        return (MatrixBlock)LocalFileUtils.readWritableFromStream(is, new MatrixBlock());
    }

    public static FrameBlock readFrameBlockFromStream(InputStream is) throws IOException {
        return (FrameBlock)LocalFileUtils.readWritableFromStream(is, new FrameBlock());
    }

    public static Writable readWritableFromStream(InputStream is, Writable ret) throws IOException {
        FilterInputStream in = !(ret instanceof MatrixBlock) ? new DataInputStream(new BufferedInputStream(is, 8192)) : new FastBufferedDataInputStream(is, 8192);
        try {
            ret.readFields((DataInput)((Object)in));
        }
        finally {
            IOUtilFunctions.closeSilently(in);
            IOUtilFunctions.closeSilently(is);
        }
        return ret;
    }

    public static void writeMatrixBlockToLocal(String fname, MatrixBlock mb) throws IOException {
        LocalFileUtils.writeWritableToLocal(fname, mb);
    }

    public static void writeFrameBlockToLocal(String fname, FrameBlock fb) throws IOException {
        LocalFileUtils.writeWritableToLocal(fname, fb);
    }

    public static void writeCacheBlockToLocal(String fname, CacheBlock cb) throws IOException {
        LocalFileUtils.writeWritableToLocal(fname, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWritableToLocal(String fname, Writable mb) throws IOException {
        FileOutputStream fos = new FileOutputStream(fname);
        FastBufferedDataOutputStream out = new FastBufferedDataOutputStream(fos, 8192);
        try {
            mb.write(out);
        }
        finally {
            IOUtilFunctions.closeSilently(out);
            IOUtilFunctions.closeSilently(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToLocal(String fname, byte[] data) throws IOException {
        FileChannel channel = null;
        try {
            Path path = Paths.get(fname, new String[0]);
            channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            channel.write(ByteBuffer.wrap(data));
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(channel);
            throw throwable;
        }
        IOUtilFunctions.closeSilently(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readBlockSequenceFromLocal(String fname, Pair<MatrixIndexes, MatrixValue>[] outValues, HashMap<MatrixIndexes, Integer> outMap) throws IOException {
        FileInputStream fis = new FileInputStream(fname);
        FastBufferedDataInputStream in = new FastBufferedDataInputStream(fis, 8192);
        int bufferSize = 0;
        try {
            int len = in.readInt();
            for (int i = 0; i < len; ++i) {
                outValues[i].getKey().readFields(in);
                outValues[i].getValue().readFields(in);
                if (outMap == null) continue;
                outMap.put(outValues[i].getKey(), i);
            }
            bufferSize = len;
        }
        finally {
            IOUtilFunctions.closeSilently(in);
            IOUtilFunctions.closeSilently(fis);
        }
        return bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBlockSequenceToLocal(String fname, Pair<MatrixIndexes, MatrixValue>[] inValues, int len) throws IOException {
        if (len > inValues.length) {
            throw new IOException("Invalid length of block sequence: len=" + len + " vs data=" + inValues.length);
        }
        FileOutputStream fos = new FileOutputStream(fname);
        FastBufferedDataOutputStream out = new FastBufferedDataOutputStream(fos, 8192);
        try {
            out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                inValues[i].getKey().write(out);
                inValues[i].getValue().write(out);
            }
        }
        finally {
            IOUtilFunctions.closeSilently(out);
            IOUtilFunctions.closeSilently(fos);
        }
    }

    public static boolean createLocalFileIfNotExist(String dir) {
        boolean ret = true;
        File fdir = new File(dir);
        if (!fdir.exists()) {
            ret = fdir.mkdirs();
        }
        return ret;
    }

    public static void deleteFileIfExists(String dir) {
        LocalFileUtils.deleteFileIfExists(dir, false);
    }

    public static void deleteFileIfExists(String dir, boolean fileOnly) {
        File fdir = new File(dir);
        if (fdir.exists()) {
            if (fileOnly) {
                fdir.delete();
            } else {
                LocalFileUtils.rDelete(fdir);
            }
        }
    }

    public static boolean isExisting(String dir) {
        File fdir = new File(dir);
        return fdir.exists();
    }

    public static boolean createLocalFileIfNotExist(String dir, String permission) {
        boolean ret = true;
        File fdir = new File(dir);
        if (!fdir.exists()) {
            ret = fdir.mkdirs();
            LocalFileUtils.setLocalFilePermissions(fdir, "777");
        }
        return ret;
    }

    public static void setLocalFilePermissions(File file, String permissions) {
        char[] c = permissions.toCharArray();
        short sU = (short)(c[0] - 48);
        short sO = (short)(c[2] - 48);
        file.setExecutable((sU & 1) == 1, (sO & 1) == 0);
        file.setWritable((sU & 2) == 2, (sO & 2) == 0);
        file.setReadable((sU & 4) == 4, (sO & 4) == 0);
    }

    public static String checkAndCreateStagingDir(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        return dir;
    }

    public static String createWorkingDirectory() throws DMLRuntimeException {
        return LocalFileUtils.createWorkingDirectoryWithUUID(DMLScript.getUUID());
    }

    public static String createWorkingDirectoryWithUUID(String uuid) throws DMLRuntimeException {
        String dirRoot = null;
        DMLConfig conf = ConfigurationManager.getDMLConfig();
        dirRoot = conf != null ? conf.getTextValue("sysml.localtmpdir") : DMLConfig.getDefaultTextValue("sysml.localtmpdir");
        if (!LocalFileUtils.createLocalFileIfNotExist(dirRoot, "777")) {
            throw new DMLRuntimeException("Failed to create non-existing local working directory: " + dirRoot);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dirRoot);
        sb.append("/");
        sb.append("_p");
        sb.append(uuid);
        sb.append("/");
        _workingDir = sb.toString();
        if (!LocalFileUtils.createLocalFileIfNotExist(_workingDir)) {
            throw new DMLRuntimeException("Failed to create local working directory: " + _workingDir);
        }
        return _workingDir;
    }

    public static void cleanupWorkingDirectory() {
        if (_workingDir != null) {
            LocalFileUtils.cleanupWorkingDirectory(_workingDir);
        }
    }

    public static void cleanupWorkingDirectory(String dir) {
        File f = new File(dir);
        if (f.exists()) {
            LocalFileUtils.rDelete(f);
        }
    }

    public static int cleanupRcWorkingDirectory(String dir) {
        int ret = 0;
        File f = new File(dir);
        if (f.exists()) {
            ret += LocalFileUtils.rcDelete(f);
        }
        return ret;
    }

    public static void rDelete(File dir) {
        if (dir.isDirectory()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                LocalFileUtils.rDelete(f);
            }
        }
        dir.delete();
    }

    public static int rcDelete(File dir) {
        int count = 0;
        if (dir.isDirectory()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                count += LocalFileUtils.rcDelete(f);
            }
        }
        return count += dir.delete() ? 1 : 0;
    }

    public static String getWorkingDir(String category) throws DMLRuntimeException {
        if (_workingDir == null) {
            LocalFileUtils.createWorkingDirectory();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(_workingDir);
        sb.append("/");
        sb.append(category);
        sb.append("/");
        return sb.toString();
    }

    public static String getUniqueWorkingDir(String category) throws DMLRuntimeException {
        if (_workingDir == null) {
            LocalFileUtils.createWorkingDirectory();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(_workingDir);
        sb.append("/");
        sb.append(category);
        sb.append("/");
        sb.append("tmp");
        sb.append(_seq.getNextID());
        return sb.toString();
    }

    public static void writeTextFile(File file, String text) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(text);
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(writer);
            throw throwable;
        }
        IOUtilFunctions.closeSilently(writer);
    }

    static {
        _seq = new IDSequence();
    }
}

