/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.meta;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.api.jmlc.Connection;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.transform.decode.DecoderRecode;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class TfMetaUtils {
    public static boolean isIDSpec(String spec) throws DMLRuntimeException {
        try {
            JSONObject jSpec = new JSONObject(spec);
            return TfMetaUtils.isIDSpec(jSpec);
        }
        catch (JSONException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static boolean isIDSpec(JSONObject spec) throws JSONException {
        return spec.containsKey("ids") && spec.getBoolean("ids");
    }

    public static boolean containsOmitSpec(String spec, String[] colnames) throws DMLRuntimeException {
        return TfMetaUtils.parseJsonIDList(spec, colnames, "omit").length > 0;
    }

    public static int[] parseJsonIDList(String spec, String[] colnames, String group) throws DMLRuntimeException {
        try {
            JSONObject jSpec = new JSONObject(spec);
            return TfMetaUtils.parseJsonIDList(jSpec, colnames, group);
        }
        catch (JSONException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static int[] parseJsonIDList(JSONObject spec, String[] colnames, String group) throws JSONException {
        boolean ids;
        int[] colList = new int[]{};
        boolean bl = ids = spec.containsKey("ids") && spec.getBoolean("ids");
        if (spec.containsKey(group)) {
            JSONArray attrs = null;
            if (spec.get(group) instanceof JSONObject) {
                attrs = (JSONArray)((JSONObject)spec.get(group)).get("attributes");
                ids = true;
            } else {
                attrs = (JSONArray)spec.get(group);
            }
            colList = new int[attrs.size()];
            for (int i = 0; i < colList.length; ++i) {
                int n = colList[i] = ids ? UtilFunctions.toInt(attrs.get(i)) : ArrayUtils.indexOf(colnames, attrs.get(i)) + 1;
                if (colList[i] > 0) continue;
                throw new RuntimeException("Specified column '" + attrs.get(i) + "' does not exist.");
            }
            Arrays.sort(colList);
        }
        return colList;
    }

    public static int[] parseJsonObjectIDList(JSONObject spec, String[] colnames, String group) throws JSONException {
        boolean ids;
        int[] colList = new int[]{};
        boolean bl = ids = spec.containsKey("ids") && spec.getBoolean("ids");
        if (spec.containsKey(group) && spec.get(group) instanceof JSONArray) {
            JSONArray colspecs = (JSONArray)spec.get(group);
            colList = new int[colspecs.size()];
            for (int j = 0; j < colspecs.size(); ++j) {
                JSONObject colspec = (JSONObject)colspecs.get(j);
                int n = colList[j] = ids ? colspec.getInt("id") : ArrayUtils.indexOf(colnames, colspec.get("name")) + 1;
                if (colList[j] > 0) continue;
                throw new RuntimeException("Specified column '" + colspec.get(ids ? "id" : "name") + "' does not exist.");
            }
            Arrays.sort(colList);
        }
        return colList;
    }

    public static FrameBlock readTransformMetaDataFromFile(String spec, String metapath, String colDelim) throws IOException {
        String colnamesStr = MapReduceTool.readStringFromHDFSFile(metapath + File.separator + "column.names");
        String[] colnames = IOUtilFunctions.split(colnamesStr.trim(), colDelim);
        HashMap<String, String> meta = new HashMap<String, String>();
        HashMap<String, String> mvmeta = new HashMap<String, String>();
        int rows = 0;
        for (int j = 0; j < colnames.length; ++j) {
            String name3;
            String name2;
            String colName = colnames[j];
            String name = metapath + File.separator + "Recode" + File.separator + colName;
            if (MapReduceTool.existsFileOnHDFS(name + ".map")) {
                meta.put(colName, MapReduceTool.readStringFromHDFSFile(name + ".map"));
                String ndistinct = MapReduceTool.readStringFromHDFSFile(name + ".ndistinct");
                rows = Math.max(rows, Integer.parseInt(ndistinct));
            }
            if (MapReduceTool.existsFileOnHDFS((name2 = metapath + File.separator + "Bin" + File.separator + colName) + ".bin")) {
                String binmap = MapReduceTool.readStringFromHDFSFile(name2 + ".bin");
                meta.put(colName, binmap);
                rows = Math.max(rows, Integer.parseInt(binmap.split(",")[4]));
            }
            if (!MapReduceTool.existsFileOnHDFS((name3 = metapath + File.separator + "Impute" + File.separator + colName) + ".impute")) continue;
            String mvmap = MapReduceTool.readStringFromHDFSFile(name3 + ".impute");
            mvmeta.put(colName, mvmap);
        }
        List<Integer> recodeIDs = TfMetaUtils.parseRecodeColIDs(spec, colnames);
        List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(spec, colnames);
        return TfMetaUtils.convertToTransformMetaDataFrame(rows, colnames, recodeIDs, binIDs, meta, mvmeta);
    }

    public static FrameBlock readTransformMetaDataFromPath(String spec, String metapath, String colDelim) throws IOException {
        String colnamesStr = IOUtilFunctions.toString(Connection.class.getResourceAsStream(metapath + "/" + "column.names"));
        String[] colnames = IOUtilFunctions.split(colnamesStr.trim(), colDelim);
        HashMap<String, String> meta = new HashMap<String, String>();
        HashMap<String, String> mvmeta = new HashMap<String, String>();
        int rows = 0;
        for (int j = 0; j < colnames.length; ++j) {
            String name3;
            String map3;
            String name2;
            String map2;
            String colName = colnames[j];
            String name = metapath + "/Recode/" + colName;
            String map = IOUtilFunctions.toString(Connection.class.getResourceAsStream(name + ".map"));
            if (map != null) {
                meta.put(colName, map);
                String ndistinct = IOUtilFunctions.toString(Connection.class.getResourceAsStream(name + ".ndistinct"));
                rows = Math.max(rows, Integer.parseInt(ndistinct));
            }
            if ((map2 = IOUtilFunctions.toString(Connection.class.getResourceAsStream((name2 = metapath + "/Bin/" + colName) + ".bin"))) != null) {
                meta.put(colName, map2);
                rows = Math.max(rows, Integer.parseInt(map2.split(",")[4]));
            }
            if ((map3 = IOUtilFunctions.toString(Connection.class.getResourceAsStream((name3 = metapath + File.separator + "Impute" + File.separator + colName) + ".impute"))) == null) continue;
            mvmeta.put(colName, map3);
        }
        List<Integer> recodeIDs = TfMetaUtils.parseRecodeColIDs(spec, colnames);
        List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(spec, colnames);
        return TfMetaUtils.convertToTransformMetaDataFrame(rows, colnames, recodeIDs, binIDs, meta, mvmeta);
    }

    private static FrameBlock convertToTransformMetaDataFrame(int rows, String[] colnames, List<Integer> rcIDs, List<Integer> binIDs, HashMap<String, String> meta, HashMap<String, String> mvmeta) throws IOException {
        String map;
        String name;
        Expression.ValueType[] schema = UtilFunctions.nCopies(colnames.length, Expression.ValueType.STRING);
        FrameBlock ret = new FrameBlock(schema, colnames);
        ret.ensureAllocatedColumns(rows);
        for (Integer n : rcIDs) {
            String line;
            name = colnames[n - 1];
            map = meta.get(name);
            if (map == null) {
                throw new IOException("Recode map for column '" + name + "' (id=" + n + ") not existing.");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(map.getBytes("UTF-8"));
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            Pair<String, String> pair = new Pair<String, String>();
            int rpos = 0;
            while ((line = br.readLine()) != null) {
                DecoderRecode.parseRecodeMapEntry(line, pair);
                String tmp = pair.getKey() + "\u00b7" + pair.getValue();
                ret.set(rpos++, n - 1, tmp);
            }
            ret.getColumnMetadata(n - 1).setNumDistinct(rpos);
        }
        for (Integer n : binIDs) {
            name = colnames[n - 1];
            map = meta.get(name);
            if (map == null) {
                throw new IOException("Binning map for column '" + name + "' (id=" + n + ") not existing.");
            }
            String[] fields = map.split(",");
            double min = UtilFunctions.parseToDouble(fields[1]);
            double binwidth = UtilFunctions.parseToDouble(fields[3]);
            int nbins = UtilFunctions.parseToInt(fields[4]);
            for (int i = 0; i < nbins; ++i) {
                String lbound = String.valueOf(min + (double)i * binwidth);
                String ubound = String.valueOf(min + (double)(i + 1) * binwidth);
                ret.set(i, n - 1, lbound + "\u00b7" + ubound);
            }
            ret.getColumnMetadata(n - 1).setNumDistinct(nbins);
        }
        for (Map.Entry entry : mvmeta.entrySet()) {
            int colID = ArrayUtils.indexOf(colnames, entry.getKey()) + 1;
            String mvVal = ((String)entry.getValue()).split(",")[1];
            ret.getColumnMetadata(colID - 1).setMvValue(mvVal);
        }
        return ret;
    }

    private static List<Integer> parseRecodeColIDs(String spec, String[] colnames) throws IOException {
        if (spec == null) {
            throw new IOException("Missing transform specification.");
        }
        ArrayList<Integer> specRecodeIDs = null;
        try {
            JSONObject jSpec = new JSONObject(spec);
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "recode")));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "dummycode")));
            specRecodeIDs = new ArrayList<Integer>(CollectionUtils.union(rcIDs, dcIDs));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return specRecodeIDs;
    }

    public static List<Integer> parseBinningColIDs(String spec, String[] colnames) throws IOException {
        try {
            JSONObject jSpec = new JSONObject(spec);
            return TfMetaUtils.parseBinningColIDs(jSpec, colnames);
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }

    public static List<Integer> parseBinningColIDs(JSONObject jSpec, String[] colnames) throws IOException {
        try {
            if (jSpec.containsKey("bin") && jSpec.get("bin") instanceof JSONArray) {
                return Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonObjectIDList(jSpec, colnames, "bin")));
            }
            return Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "bin")));
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }
}

