/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendGInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendMInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.CumulativeAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeSplitInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.MatrixReshapeMRInstruction;
import org.apache.sysml.runtime.instructions.mr.RangeBasedReIndexInstruction;
import org.apache.sysml.runtime.instructions.mr.RemoveEmptyMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ReorgInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.ZeroOutInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.CollectMultipleConvertedOutputs;
import org.apache.sysml.runtime.matrix.mapred.DistributedCacheInput;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MMCJMRMapper;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class MRBaseForCommonInstructions
extends MapReduceBase {
    protected Class<? extends MatrixValue> valueClass;
    protected CachedValueMap cachedValues = new CachedValueMap();
    public static boolean isJobLocal = false;
    public static HashMap<Byte, DistributedCacheInput> dcValues = new HashMap();
    protected HashMap<Byte, MatrixCharacteristics> dimensions = new HashMap();
    protected IndexedMatrixValue tempValue = null;
    protected IndexedMatrixValue zeroInput = null;

    public void configure(JobConf job) {
        byte[] outputIX;
        byte[] mapOutputIX;
        byte[] inputIX;
        this.valueClass = MRJobConfiguration.getMatrixValueClass(job);
        this.tempValue = new IndexedMatrixValue(this.valueClass);
        this.zeroInput = new IndexedMatrixValue(this.valueClass);
        for (byte ix : inputIX = MRJobConfiguration.getInputIndexesInMapper(job)) {
            this.dimensions.put(ix, MRJobConfiguration.getMatrixCharacteristicsForInput(job, ix));
        }
        for (byte ix : mapOutputIX = MRJobConfiguration.getOutputIndexesInMapper(job)) {
            this.dimensions.put(ix, MRJobConfiguration.getMatrixCharacteristicsForMapOutput(job, ix));
        }
        for (byte ix : outputIX = MRJobConfiguration.getResultIndexes(job)) {
            this.dimensions.put(ix, MRJobConfiguration.getMatrixCharacteristicsForOutput(job, ix));
        }
        byte[] immediateIndexes = MRJobConfiguration.getIntermediateMatrixIndexes(job);
        if (immediateIndexes != null) {
            for (byte index : immediateIndexes) {
                this.dimensions.put(index, MRJobConfiguration.getIntermediateMatrixCharactristics(job, index));
            }
        }
    }

    protected void collectOutput_N_Increase_Counter(MatrixIndexes indexes, MatrixValue value, int i, Reporter reporter, CollectMultipleConvertedOutputs collectFinalMultipleOutputs, byte[] resultDimsUnknown, long[] resultsNonZeros, long[] resultsMaxRowDims, long[] resultsMaxColDims) throws IOException {
        collectFinalMultipleOutputs.collectOutput(indexes, value, i, reporter);
        int n = i;
        resultsNonZeros[n] = resultsNonZeros[n] + value.getNonZeros();
        if (resultDimsUnknown[i] == 1) {
            long maxrow = MRBaseForCommonInstructions.getMaxDimension(indexes, value, true);
            long maxcol = MRBaseForCommonInstructions.getMaxDimension(indexes, value, false);
            if (maxrow > resultsMaxRowDims[i]) {
                resultsMaxRowDims[i] = maxrow;
            }
            if (maxcol > resultsMaxColDims[i]) {
                resultsMaxColDims[i] = maxcol;
            }
        } else if (resultDimsUnknown[i] == 2) {
            if (indexes.getRowIndex() > resultsMaxRowDims[i]) {
                resultsMaxRowDims[i] = indexes.getRowIndex();
            }
            if (indexes.getColumnIndex() > resultsMaxColDims[i]) {
                resultsMaxColDims[i] = indexes.getColumnIndex();
            }
        }
    }

    protected void processMixedInstructions(ArrayList<MRInstruction> mixed_instructions) throws DMLRuntimeException {
        if (mixed_instructions != null) {
            for (MRInstruction ins : mixed_instructions) {
                this.processOneInstruction(ins, this.valueClass, this.cachedValues, this.tempValue, this.zeroInput);
            }
        }
    }

    protected void processOneInstruction(MRInstruction ins, Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput) throws DMLRuntimeException {
        if (ins instanceof AggregateBinaryInstruction) {
            byte input = ((AggregateBinaryInstruction)ins).input1;
            MatrixCharacteristics dim = this.dimensions.get(input);
            if (dim == null) {
                throw new DMLRuntimeException("dimension for instruction " + ins + "  is unset!!!");
            }
            ins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dim.getRowsPerBlock(), dim.getColsPerBlock());
        } else if (ins instanceof ZeroOutInstruction || ins instanceof AggregateUnaryInstruction || ins instanceof RangeBasedReIndexInstruction || ins instanceof CumulativeSplitInstruction) {
            byte input = ((UnaryMRInstructionBase)ins).input;
            MatrixCharacteristics dim = this.dimensions.get(input);
            if (dim == null) {
                throw new DMLRuntimeException("dimension for instruction " + ins + "  is unset!!!");
            }
            if (ins instanceof CumulativeAggregateInstruction) {
                ((CumulativeAggregateInstruction)ins).setMatrixCharacteristics(dim);
            }
            if (ins instanceof CumulativeSplitInstruction) {
                ((CumulativeSplitInstruction)ins).setMatrixCharacteristics(dim);
            }
            ins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dim.getRowsPerBlock(), dim.getColsPerBlock());
        } else if (ins instanceof ReorgInstruction) {
            ReorgInstruction rinst = (ReorgInstruction)ins;
            byte input = rinst.input;
            MatrixCharacteristics dim = this.dimensions.get(input);
            if (dim == null) {
                throw new DMLRuntimeException("dimension for instruction " + ins + "  is unset!!!");
            }
            rinst.setInputMatrixCharacteristics(dim);
            rinst.setOutputEmptyBlocks(!(this instanceof MMCJMRMapper));
            ins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dim.getRowsPerBlock(), dim.getColsPerBlock());
        } else if (ins instanceof MatrixReshapeMRInstruction) {
            MatrixReshapeMRInstruction mrins = (MatrixReshapeMRInstruction)ins;
            byte input = mrins.input;
            byte output = mrins.output;
            MatrixCharacteristics dimIn = this.dimensions.get(input);
            MatrixCharacteristics dimOut = this.dimensions.get(output);
            if (dimIn == null || dimOut == null) {
                throw new DMLRuntimeException("dimension for instruction " + ins + "  is unset!!!");
            }
            mrins.setMatrixCharacteristics(dimIn, dimOut);
            mrins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dimIn.getRowsPerBlock(), dimIn.getColsPerBlock());
        } else if (ins instanceof AppendMInstruction) {
            byte input = ((AppendMInstruction)ins).input1;
            MatrixCharacteristics dim = this.dimensions.get(input);
            if (dim == null) {
                throw new DMLRuntimeException("dimension for instruction " + ins + "  is unset!!!");
            }
            ins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dim.getRowsPerBlock(), dim.getColsPerBlock());
        } else if (ins instanceof BinaryMInstruction || ins instanceof RemoveEmptyMRInstruction) {
            byte input = ((BinaryMRInstructionBase)ins).input1;
            MatrixCharacteristics dim = this.dimensions.get(input);
            if (dim == null) {
                throw new DMLRuntimeException("dimension for instruction " + ins + "  is unset!!!");
            }
            ins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dim.getRowsPerBlock(), dim.getColsPerBlock());
        } else if (ins instanceof AppendGInstruction) {
            AppendGInstruction arinst = (AppendGInstruction)ins;
            byte input = arinst.input1;
            MatrixCharacteristics dimIn = this.dimensions.get(input);
            if (dimIn == null) {
                throw new DMLRuntimeException("Dimensions for instruction " + arinst + "  is unset!!!");
            }
            arinst.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dimIn.getRowsPerBlock(), dimIn.getColsPerBlock());
        } else if (ins instanceof UnaryMRInstructionBase) {
            UnaryMRInstructionBase rinst = (UnaryMRInstructionBase)ins;
            MatrixCharacteristics dimIn = this.dimensions.get(rinst.input);
            if (dimIn == null) {
                throw new DMLRuntimeException("Dimensions for instruction " + rinst + "  is unset!!!");
            }
            rinst.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dimIn.getRowsPerBlock(), dimIn.getColsPerBlock());
        } else if (ins instanceof BinaryMRInstructionBase) {
            BinaryMRInstructionBase rinst = (BinaryMRInstructionBase)ins;
            MatrixCharacteristics dimIn = this.dimensions.get(rinst.input1);
            if (dimIn != null) {
                rinst.processInstruction(valueClass, cachedValues, tempValue, zeroInput, dimIn.getRowsPerBlock(), dimIn.getColsPerBlock());
            } else {
                ins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, -1, -1);
            }
        } else {
            ins.processInstruction(valueClass, cachedValues, tempValue, zeroInput, -1, -1);
        }
    }

    public static void resetDistCache() {
        for (DistributedCacheInput dcInput : dcValues.values()) {
            dcInput.reset();
        }
        dcValues.clear();
    }

    protected void setupDistCacheFiles(JobConf job) throws IOException {
        if (MRJobConfiguration.getDistCacheInputIndices(job) == null) {
            return;
        }
        isJobLocal = InfrastructureAnalyzer.isLocalMode(job);
        String[] inputIndices = MRJobConfiguration.getInputPaths(job);
        String[] dcIndices = MRJobConfiguration.getDistCacheInputIndices(job).split("\u2021");
        Path[] dcFiles = DistributedCache.getLocalCacheFiles((Configuration)job);
        ParForProgramBlock.PDataPartitionFormat[] inputPartitionFormats = MRJobConfiguration.getInputPartitionFormats(job);
        DistributedCacheInput[] dcInputs = new DistributedCacheInput[dcIndices.length];
        for (int i = 0; i < dcIndices.length; ++i) {
            byte inputIndex = Byte.parseByte(dcIndices[i]);
            if (dcValues.containsKey(inputIndex)) continue;
            Path p = null;
            p = isJobLocal ? new Path(inputIndices[Byte.parseByte(dcIndices[i])]) : dcFiles[i];
            dcInputs[i] = new DistributedCacheInput(p, MRJobConfiguration.getNumRows(job, inputIndex), MRJobConfiguration.getNumColumns(job, inputIndex), MRJobConfiguration.getNumRowsPerBlock(job, inputIndex), MRJobConfiguration.getNumColumnsPerBlock(job, inputIndex), inputPartitionFormats[inputIndex]);
            dcValues.put(inputIndex, dcInputs[i]);
        }
    }

    private static long getMaxDimension(MatrixIndexes key, MatrixValue value, boolean row) {
        if (value instanceof MatrixCell) {
            return row ? key.getRowIndex() : key.getColumnIndex();
        }
        if (value instanceof MatrixBlock) {
            return row ? (long)value.getNumRows() : (long)value.getNumColumns();
        }
        return 0L;
    }
}

