/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.MMCJ;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.MMCJMRCombinerReducerBase;
import org.apache.sysml.runtime.matrix.mapred.MMCJMRInputCache;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.PartialAggregator;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.util.MapReduceTool;

public class MMCJMRReducerWithAggregator
extends MMCJMRCombinerReducerBase
implements Reducer<TaggedFirstSecondIndexes, MatrixValue, Writable, Writable> {
    public static long MIN_CACHE_SIZE = 0x4000000L;
    private MMCJMRInputCache cache = null;
    private PartialAggregator aggregator = null;
    private double prevFirstIndex = -1.0;
    private int prevTag = -1;
    private MatrixIndexes indexesbuffer = new MatrixIndexes();
    private MatrixValue valueBuffer = null;
    private boolean outputDummyRecords = false;

    public void reduce(TaggedFirstSecondIndexes indexes, Iterator<MatrixValue> values, OutputCollector<Writable, Writable> out, Reporter report) throws IOException {
        long start = System.currentTimeMillis();
        this.commonSetup(report);
        MatrixValue aggregateValue = null;
        if (this.valueClass == MatrixBlock.class) {
            aggregateValue = values.next();
        } else {
            aggregateValue = this.performAggregateInstructions(indexes, values);
            if (aggregateValue == null) {
                return;
            }
        }
        byte tag = indexes.getTag();
        long firstIndex = indexes.getFirstIndex();
        long secondIndex = indexes.getSecondIndex();
        if (this.prevFirstIndex != (double)firstIndex) {
            this.cache.resetCache(true);
            this.prevFirstIndex = firstIndex;
        } else if (this.prevTag > tag) {
            throw new RuntimeException("tag is not ordered correctly: " + this.prevTag + " > " + tag);
        }
        this.prevTag = tag;
        this.processJoin(tag, secondIndex, aggregateValue);
        report.incrCounter(ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
    }

    private void processJoin(int tag, long inIndex, MatrixValue inValue) throws IOException {
        try {
            if (tag == 0) {
                this.cache.put(inIndex, inValue);
            } else {
                for (int i = 0; i < this.cache.getCacheSize(); ++i) {
                    Pair<MatrixIndexes, MatrixValue> tmp = this.cache.get(i);
                    if (this.tagForLeft == 0) {
                        this.indexesbuffer.setIndexes(tmp.getKey().getRowIndex(), inIndex);
                        OperationsOnMatrixValues.performAggregateBinaryIgnoreIndexes((MatrixBlock)tmp.getValue(), (MatrixBlock)inValue, (MatrixBlock)this.valueBuffer, (AggregateBinaryOperator)this.aggBinInstruction.getOperator());
                    } else {
                        this.indexesbuffer.setIndexes(inIndex, tmp.getKey().getColumnIndex());
                        OperationsOnMatrixValues.performAggregateBinaryIgnoreIndexes((MatrixBlock)inValue, (MatrixBlock)tmp.getValue(), (MatrixBlock)this.valueBuffer, (AggregateBinaryOperator)this.aggBinInstruction.getOperator());
                    }
                    if (this.aggBinInstruction.getMMCJType() == MMCJ.MMCJType.AGG) {
                        this.aggregator.aggregateToBuffer(this.indexesbuffer, this.valueBuffer, this.tagForLeft == 0);
                        continue;
                    }
                    this.collectFinalMultipleOutputs.collectOutput(this.indexesbuffer, this.valueBuffer, 0, this.cachedReporter);
                    this.resultsNonZeros[0] = this.resultsNonZeros[0] + this.valueBuffer.getNonZeros();
                }
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void configure(JobConf job) {
        long outBufferSize;
        long inBufferSize;
        super.configure(job);
        if (this.resultIndexes.length > 1) {
            throw new RuntimeException("MMCJMR only outputs one result");
        }
        this.outputDummyRecords = MapReduceTool.getUniqueKeyPerTask(job, false).equals("0");
        try {
            this.valueBuffer = this.buffer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long cacheSize = MRJobConfiguration.getMMCJCacheSize(job);
        long memBudget = (long)OptimizerUtils.getLocalMemBudget();
        if (memBudget - cacheSize > MIN_CACHE_SIZE) {
            inBufferSize = cacheSize;
            outBufferSize = memBudget - cacheSize;
        } else {
            inBufferSize = memBudget - 2L * MIN_CACHE_SIZE;
            outBufferSize = MIN_CACHE_SIZE;
        }
        try {
            this.cache = this.tagForLeft == 0 ? new MMCJMRInputCache(job, inBufferSize, this.dim1.getRows(), this.dim1.getCols(), this.dim1.getRowsPerBlock(), this.dim1.getColsPerBlock(), true, this.valueClass) : new MMCJMRInputCache(job, inBufferSize, this.dim2.getRows(), this.dim2.getCols(), this.dim2.getRowsPerBlock(), this.dim2.getColsPerBlock(), false, this.valueClass);
            if (this.aggBinInstruction.getMMCJType() == MMCJ.MMCJType.AGG) {
                this.aggregator = new PartialAggregator(job, outBufferSize, this.dim1.getRows(), this.dim2.getCols(), this.dim1.getRowsPerBlock(), this.dim2.getColsPerBlock(), this.tagForLeft != 0, (AggregateBinaryOperator)this.aggBinInstruction.getOperator(), this.valueClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cachedReporter != null) {
            long start = System.currentTimeMillis();
            if (this.aggBinInstruction.getMMCJType() == MMCJ.MMCJType.AGG) {
                this.resultsNonZeros[0] = this.resultsNonZeros[0] + this.aggregator.outputToHadoop(this.collectFinalMultipleOutputs, 0, this.cachedReporter);
            }
            this.cachedReporter.incrCounter(ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
        }
        if (this.outputDummyRecords) {
            long rlen = this.dim1.getRows();
            long clen = this.dim2.getCols();
            int brlen = this.dim1.getRowsPerBlock();
            int bclen = this.dim2.getColsPerBlock();
            MatrixIndexes tmpIx = new MatrixIndexes();
            MatrixBlock tmpVal = new MatrixBlock();
            long i = 0L;
            long r = 1L;
            while (i < rlen) {
                long j = 0L;
                long c = 1L;
                while (j < clen) {
                    int realBrlen = (int)Math.min((long)brlen, rlen - (r - 1L) * (long)brlen);
                    int realBclen = (int)Math.min((long)bclen, clen - (c - 1L) * (long)bclen);
                    tmpIx.setIndexes(r, c);
                    if (this.aggBinInstruction.getMMCJType() == MMCJ.MMCJType.NO_AGG || !this.aggregator.getBufferMap().containsKey(tmpIx)) {
                        tmpVal.reset(realBrlen, realBclen);
                        this.collectFinalMultipleOutputs.collectOutput(tmpIx, tmpVal, 0, this.cachedReporter);
                    }
                    j += (long)bclen;
                    ++c;
                }
                i += (long)brlen;
                ++r;
            }
        }
        this.cache.close();
        super.close();
    }
}

