/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.DataPartitionerRemoteMR;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class DataPartitionMR {
    private DataPartitionMR() {
    }

    public static JobReturn runJob(MRJobInstruction jobinst, MatrixObject[] inputMatrices, String shuffleInst, byte[] resultIndices, MatrixObject[] outputMatrices, int numReducers, int replication) throws DMLRuntimeException {
        MatrixCharacteristics[] sts = new MatrixCharacteristics[outputMatrices.length];
        DataPartitionMR.processPartitionInstructions(shuffleInst, inputMatrices, resultIndices, outputMatrices, numReducers, replication, sts);
        JobReturn ret = new JobReturn(sts, true);
        return ret;
    }

    private static void processPartitionInstructions(String shuffleInst, MatrixObject[] inputMatrices, byte[] resultIndices, MatrixObject[] outputMatrices, int numReducers, int replication, MatrixCharacteristics[] sts) throws DMLRuntimeException {
        int i = 0;
        for (String inst : shuffleInst.split("\u2021")) {
            if (!InstructionUtils.getOpCode(inst).equalsIgnoreCase("partition")) continue;
            String[] parts = InstructionUtils.getInstructionParts(inst);
            int input_index = Integer.parseInt(parts[1]);
            int output_index = Integer.parseInt(parts[2]);
            MatrixObject in = inputMatrices[input_index];
            MatrixObject out = outputMatrices[DataPartitionMR.findResultIndex(resultIndices, output_index)];
            ParForProgramBlock.PDataPartitionFormat pformat = ParForProgramBlock.PDataPartitionFormat.valueOf(parts[3]);
            long rlen = in.getNumRows();
            long clen = in.getNumColumns();
            long brlen = in.getNumRowsPerBlock();
            long bclen = in.getNumColumnsPerBlock();
            long N = -1L;
            switch (pformat) {
                case ROW_BLOCK_WISE_N: {
                    long numRowBlocks = (long)Math.ceil(4000000.0 / (double)clen / (double)brlen);
                    N = numRowBlocks * brlen;
                    break;
                }
                case COLUMN_BLOCK_WISE_N: {
                    long numColBlocks = (long)Math.ceil(4000000.0 / (double)rlen / (double)bclen);
                    N = numColBlocks * bclen;
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Unsupported partition format for distributed cache input: " + (Object)((Object)pformat));
                }
            }
            ParForProgramBlock.PartitionFormat pf = new ParForProgramBlock.PartitionFormat(pformat, (int)N);
            DataPartitionerRemoteMR dpart = new DataPartitionerRemoteMR(pf, -1L, numReducers, replication, false, true);
            out = dpart.createPartitionedMatrixObject(in, out, true);
            sts[i] = out.getMatrixCharacteristics();
            ++i;
        }
    }

    private static int findResultIndex(byte[] resultIndices, int output_index) {
        for (int i = 0; i < resultIndices.length; ++i) {
            if (resultIndices[i] != output_index) continue;
            return i;
        }
        return -1;
    }
}

