/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.IOException;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public abstract class MatrixWriter {
    public abstract void writeMatrixToHDFS(MatrixBlock var1, String var2, long var3, long var5, int var7, int var8, long var9) throws IOException, DMLRuntimeException;

    public abstract void writeEmptyMatrixToHDFS(String var1, long var2, long var4, int var6, int var7) throws IOException, DMLRuntimeException;

    public static MatrixBlock[] createMatrixBlocksForReuse(long rlen, long clen, int brlen, int bclen, boolean sparse, long nonZeros) throws DMLRuntimeException {
        MatrixBlock[] blocks = new MatrixBlock[4];
        double sparsity = (double)nonZeros / (double)(rlen * clen);
        long estNNZ = -1L;
        if (rlen >= (long)brlen && clen >= (long)bclen) {
            estNNZ = (long)((double)(brlen * bclen) * sparsity);
            blocks[0] = new MatrixBlock(brlen, bclen, sparse, (int)estNNZ);
        }
        if (rlen >= (long)brlen && clen % (long)bclen != 0L) {
            estNNZ = (long)((double)((long)brlen * (clen % (long)bclen)) * sparsity);
            blocks[1] = new MatrixBlock(brlen, (int)(clen % (long)bclen), sparse, (int)estNNZ);
        }
        if (rlen % (long)brlen != 0L && clen >= (long)bclen) {
            estNNZ = (long)((double)(rlen % (long)brlen * (long)bclen) * sparsity);
            blocks[2] = new MatrixBlock((int)(rlen % (long)brlen), bclen, sparse, (int)estNNZ);
        }
        if (rlen % (long)brlen != 0L && clen % (long)bclen != 0L) {
            estNNZ = (long)((double)(rlen % (long)brlen * (clen % (long)bclen)) * sparsity);
            blocks[3] = new MatrixBlock((int)(rlen % (long)brlen), (int)(clen % (long)bclen), sparse, (int)estNNZ);
        }
        for (MatrixBlock b : blocks) {
            if (b == null || sparse) continue;
            b.allocateDenseBlockUnsafe(b.getNumRows(), b.getNumColumns());
        }
        return blocks;
    }

    public static MatrixBlock getMatrixBlockForReuse(MatrixBlock[] blocks, int rows, int cols, int brlen, int bclen) {
        int index = -1;
        index = rows == brlen && cols == bclen ? 0 : (rows == brlen && cols < bclen ? 1 : (rows < brlen && cols == bclen ? 2 : 3));
        return blocks[index];
    }
}

