/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.lops.PickByCount;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class PickByCountInstruction
extends MRInstruction {
    public byte input1;
    public byte input2;
    public double cst;
    public boolean isValuePick = true;

    private PickByCountInstruction(Operator op, byte _in1, byte _in2, byte out, String istr) {
        super(MRInstruction.MRType.PickByCount, op, out);
        this.input1 = _in1;
        this.input2 = _in2;
        this.cst = 0.0;
        this.instString = istr;
        this.isValuePick = true;
    }

    private PickByCountInstruction(Operator op, byte _in1, double _cst, byte out, String istr) {
        super(MRInstruction.MRType.PickByCount, op, out);
        this.input1 = _in1;
        this.cst = _cst;
        this.instString = istr;
        this.isValuePick = false;
    }

    public static PickByCountInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 5);
        String[] parts = InstructionUtils.getInstructionParts(str);
        PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[4]);
        if (ptype == PickByCount.OperationTypes.VALUEPICK) {
            byte in1 = Byte.parseByte(parts[1]);
            byte in2 = Byte.parseByte(parts[2]);
            byte out = Byte.parseByte(parts[3]);
            return new PickByCountInstruction(null, in1, in2, out, str);
        }
        if (ptype == PickByCount.OperationTypes.RANGEPICK) {
            byte in1 = Byte.parseByte(parts[1]);
            double cstant = Double.parseDouble(parts[2]);
            byte out = Byte.parseByte(parts[3]);
            return new PickByCountInstruction(null, in1, cstant, out, str);
        }
        return null;
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        throw new DMLRuntimeException("PickByCountInstruction.processInstruction should never be called!");
    }

    @Override
    public byte[] getAllIndexes() throws DMLRuntimeException {
        if (this.isValuePick) {
            return new byte[]{this.input1, this.input2, this.output};
        }
        return new byte[]{this.input1, this.output};
    }

    @Override
    public byte[] getInputIndexes() throws DMLRuntimeException {
        if (this.isValuePick) {
            return new byte[]{this.input1, this.input2};
        }
        return new byte[]{this.input1};
    }
}

