/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ParameterizedBuiltinMRInstruction
extends UnaryInstruction {
    String _opcode = null;
    private double _pattern;
    private double _replace;
    private double _max;
    private boolean _dirRows;
    private boolean _cast;
    private boolean _ignore;

    private ParameterizedBuiltinMRInstruction(Operator op, byte in, double pattern, double replace, byte out, String opcode, String istr) {
        super(MRInstruction.MRType.ParameterizedBuiltin, op, in, out, istr);
        this.instString = istr;
        this._opcode = opcode;
        this._pattern = pattern;
        this._replace = replace;
    }

    private ParameterizedBuiltinMRInstruction(Operator op, byte in, double max, boolean dirRows, boolean cast, boolean ignore, byte out, String opcode, String istr) {
        super(MRInstruction.MRType.ParameterizedBuiltin, op, in, out, istr);
        this.instString = istr;
        this._opcode = opcode;
        this._max = max;
        this._dirRows = dirRows;
        this._cast = cast;
        this._ignore = ignore;
    }

    public void computeOutputCharacteristics(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut) {
        if (this._opcode.equalsIgnoreCase("replace")) {
            mcOut.set(mcIn);
        } else if (this._opcode.equalsIgnoreCase("rexpand")) {
            long lmax = UtilFunctions.toLong(this._max);
            if (this._dirRows) {
                mcOut.set(lmax, mcIn.getRows(), mcIn.getRowsPerBlock(), mcIn.getColsPerBlock());
            } else {
                mcOut.set(mcIn.getRows(), lmax, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock());
            }
        }
    }

    public static ParameterizedBuiltinMRInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("replace")) {
            InstructionUtils.checkNumFields(str, 4);
            byte in = Byte.parseByte(parts[1]);
            double pattern = Double.parseDouble(parts[2]);
            double replace = Double.parseDouble(parts[3]);
            byte out = Byte.parseByte(parts[4]);
            return new ParameterizedBuiltinMRInstruction(new Operator(true), in, pattern, replace, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rexpand")) {
            InstructionUtils.checkNumFields(str, 6);
            byte in = Byte.parseByte(parts[1]);
            double max = Double.parseDouble(parts[2]);
            boolean dirRows = parts[3].equals("rows");
            boolean cast = Boolean.parseBoolean(parts[4]);
            boolean ignore = Boolean.parseBoolean(parts[5]);
            byte out = Byte.parseByte(parts[6]);
            return new ParameterizedBuiltinMRInstruction(new Operator(true), in, max, dirRows, cast, ignore, out, opcode, str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing an ParameterizedBuiltinMRInstruction: " + str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue imv : blkList) {
                if (imv == null) continue;
                if (this._opcode.equalsIgnoreCase("replace")) {
                    MatrixValue in = imv.getValue();
                    MatrixIndexes inIX = imv.getIndexes();
                    IndexedMatrixValue iout = null;
                    iout = this.output == this.input ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                    iout.getIndexes().setIndexes(inIX);
                    MatrixValue out = iout.getValue();
                    in.replaceOperations(out, this._pattern, this._replace);
                    if (iout != tempValue) continue;
                    cachedValues.add(this.output, iout);
                    continue;
                }
                if (!this._opcode.equalsIgnoreCase("rexpand")) continue;
                ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
                LibMatrixReorg.rexpand(imv, this._max, this._dirRows, this._cast, this._ignore, blockRowFactor, blockColFactor, out);
                for (IndexedMatrixValue lout : out) {
                    cachedValues.add(this.output, lout);
                }
            }
        }
    }
}

