/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.BinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public class CumulativeOffsetInstruction
extends BinaryInstruction {
    private BinaryOperator _bop = null;
    private UnaryOperator _uop = null;

    private CumulativeOffsetInstruction(byte in1, byte in2, byte out, String opcode, String istr) {
        super(MRInstruction.MRType.CumsumOffset, null, in1, in2, out, istr);
        if ("bcumoffk+".equals(opcode)) {
            this._bop = new BinaryOperator(Plus.getPlusFnObject());
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucumk+"));
        } else if ("bcumoff*".equals(opcode)) {
            this._bop = new BinaryOperator(Multiply.getMultiplyFnObject());
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucum*"));
        } else if ("bcumoffmin".equals(opcode)) {
            this._bop = new BinaryOperator(Builtin.getBuiltinFnObject("min"));
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucummin"));
        } else if ("bcumoffmax".equals(opcode)) {
            this._bop = new BinaryOperator(Builtin.getBuiltinFnObject("max"));
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucummax"));
        }
    }

    public static CumulativeOffsetInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        byte out = Byte.parseByte(parts[3]);
        return new CumulativeOffsetInstruction(in1, in2, out, opcode, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        IndexedMatrixValue in1 = cachedValues.getFirst(this.input1);
        IndexedMatrixValue in2 = cachedValues.getFirst(this.input2);
        if (in1 == null || in2 == null) {
            throw new DMLRuntimeException("Unexpected empty input (left=" + (in1 == null ? "null" : in1.getIndexes()) + ", right=" + (in2 == null ? "null" : in2.getIndexes()) + ").");
        }
        IndexedMatrixValue out = cachedValues.holdPlace(this.output, valueClass);
        MatrixBlock data = (MatrixBlock)in1.getValue();
        MatrixBlock offset = (MatrixBlock)in2.getValue();
        MatrixBlock blk = (MatrixBlock)out.getValue();
        blk.reset(data.getNumRows(), data.getNumColumns());
        MatrixBlock data2 = new MatrixBlock(data);
        MatrixBlock fdata2 = data2.slice(0, 0, 0, data2.getNumColumns() - 1, new MatrixBlock());
        fdata2.binaryOperationsInPlace(this._bop, offset);
        data2.copy(0, 0, 0, data2.getNumColumns() - 1, fdata2, true);
        data2.unaryOperations(this._uop, blk);
        out.getIndexes().setIndexes(in1.getIndexes());
    }
}

