/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.AppendInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AppendRInstruction
extends AppendInstruction {
    private AppendRInstruction(Operator op, byte in1, byte in2, byte out, boolean cbind, String istr) {
        super(op, in1, in2, out, cbind, istr);
    }

    public static AppendRInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionParts(str);
        InstructionUtils.checkNumFields(parts, 4);
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        byte out = Byte.parseByte(parts[3]);
        boolean cbind = Boolean.parseBoolean(parts[4]);
        return new AppendRInstruction(null, in1, in2, out, cbind, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int brlen, int bclen) throws DMLRuntimeException {
        IndexedMatrixValue left = cachedValues.getFirst(this.input1);
        IndexedMatrixValue right = cachedValues.getFirst(this.input2);
        if (left == null || right == null) {
            throw new DMLRuntimeException("Missing append input: isNull(left): " + (left == null) + ", isNull(right): " + (right == null));
        }
        MatrixBlock mbLeft = (MatrixBlock)left.getValue();
        MatrixBlock mbRight = (MatrixBlock)right.getValue();
        MatrixBlock ret = mbLeft.append(mbRight, new MatrixBlock(), this._cbind);
        cachedValues.add(this.output, new IndexedMatrixValue(left.getIndexes(), ret));
    }
}

