/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.io.IOException;
import org.apache.sysml.lops.PickByCount;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataNumItemsByEachReducer;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;

public class QuantilePickCPInstruction
extends BinaryCPInstruction {
    private final PickByCount.OperationTypes _type;
    private final boolean _inmem;

    private QuantilePickCPInstruction(Operator op, CPOperand in, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        this(op, in, null, out, type, inmem, opcode, istr);
    }

    private QuantilePickCPInstruction(Operator op, CPOperand in, CPOperand in2, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        super(CPInstruction.CPType.QPick, op, in, in2, out, opcode, istr);
        this._type = type;
        this._inmem = inmem;
    }

    public static QuantilePickCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("qpick")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a QuantilePickCPInstruction: " + str);
        }
        if (parts.length == 4) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.IQM;
            boolean inmem = false;
            return new QuantilePickCPInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        }
        if (parts.length == 5) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand out = new CPOperand(parts[2]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[3]);
            boolean inmem = Boolean.parseBoolean(parts[4]);
            return new QuantilePickCPInstruction(null, in1, out, ptype, inmem, opcode, str);
        }
        if (parts.length == 6) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[4]);
            boolean inmem = Boolean.parseBoolean(parts[5]);
            return new QuantilePickCPInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        }
        return null;
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        switch (this._type) {
            case VALUEPICK: {
                if (this._inmem) {
                    MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
                    if (this.input2.getDataType() == Expression.DataType.SCALAR) {
                        ScalarObject quantile = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
                        double picked = matBlock.pickValue(quantile.getDoubleValue());
                        ec.setScalarOutput(this.output.getName(), new DoubleObject(picked));
                    } else {
                        MatrixBlock quantiles = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
                        MatrixBlock resultBlock = (MatrixBlock)matBlock.pickValues(quantiles, new MatrixBlock());
                        quantiles = null;
                        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
                        ec.setMatrixOutput(this.output.getName(), resultBlock, this.getExtendedOpcode());
                    }
                    ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
                    break;
                }
                MatrixObject mat = ec.getMatrixObject(this.input1.getName());
                String fname = mat.getFileName();
                MetaData mdata = mat.getMetaData();
                ScalarObject pickindex = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
                if (mdata != null) {
                    try {
                        double picked = MapReduceTool.pickValue(fname, (MetaDataNumItemsByEachReducer)mdata, pickindex.getDoubleValue());
                        ec.setVariable(this.output.getName(), new DoubleObject(picked));
                        break;
                    }
                    catch (Exception e) {
                        throw new DMLRuntimeException(e);
                    }
                }
                throw new DMLRuntimeException("Unexpected error while executing ValuePickCP: otherMetaData for file (" + fname + ") not found.");
            }
            case MEDIAN: {
                if (this._inmem) {
                    double picked = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode()).median();
                    ec.setScalarOutput(this.output.getName(), new DoubleObject(picked));
                    ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
                    break;
                }
                MatrixObject mat1 = (MatrixObject)ec.getVariable(this.input1.getName());
                String fname1 = mat1.getFileName();
                MetaData mdata1 = mat1.getMetaData();
                if (mdata1 != null) {
                    try {
                        double median = MapReduceTool.median(fname1, (MetaDataNumItemsByEachReducer)mdata1);
                        ec.setVariable(this.output.getName(), new DoubleObject(median));
                        break;
                    }
                    catch (Exception e) {
                        throw new DMLRuntimeException(e);
                    }
                }
                throw new DMLRuntimeException("Unexpected error while executing ValuePickCP: otherMetaData for file (" + fname1 + ") not found.");
            }
            case IQM: {
                if (this._inmem) {
                    MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
                    double iqm = matBlock1.interQuartileMean();
                    ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
                    ec.setScalarOutput(this.output.getName(), new DoubleObject(iqm));
                    break;
                }
                MatrixObject inputMatrix = (MatrixObject)ec.getVariable(this.input1.getName());
                ScalarObject iqsum = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
                double[] q25 = null;
                double[] q75 = null;
                try {
                    q25 = MapReduceTool.pickValueWeight(inputMatrix.getFileName(), (MetaDataNumItemsByEachReducer)inputMatrix.getMetaData(), 0.25, false);
                    q75 = MapReduceTool.pickValueWeight(inputMatrix.getFileName(), (MetaDataNumItemsByEachReducer)inputMatrix.getMetaData(), 0.75, false);
                }
                catch (IOException e1) {
                    throw new DMLRuntimeException(e1);
                }
                double sumwt = UtilFunctions.getTotalLength((MetaDataNumItemsByEachReducer)ec.getMetaData(this.input1.getName()));
                double q25d = sumwt * 0.25;
                double q75d = sumwt * 0.75;
                double q25entry_weight = q25[0] * q25[1];
                double q25portion_include = (q25[2] - q25d) * q25[0];
                double q25portion_exclude = q25entry_weight - q25portion_include;
                double q75portion_exclude = (q75[2] - q75d) * q75[0];
                double mriqm = (iqsum.getDoubleValue() - q25portion_exclude - q75portion_exclude) / (sumwt * 0.5);
                ec.setScalarOutput(this.output.getName(), new DoubleObject(mriqm));
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported qpick operation type: " + (Object)((Object)this._type));
            }
        }
    }
}

