/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class UAggOuterChain
extends Lop {
    public static final String OPCODE = "uaggouterchain";
    private Aggregate.OperationTypes _uaggOp = null;
    private PartialAggregate.DirectionTypes _uaggDir = null;
    private Binary.OperationTypes _binOp = null;

    public UAggOuterChain(Lop input1, Lop input2, Aggregate.OperationTypes uaop, PartialAggregate.DirectionTypes uadir, Binary.OperationTypes bop, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.UaggOuterChain, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._uaggOp = uaop;
        this._uaggDir = uadir;
        this._binOp = bop;
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            this.lps.addCompatibility(JobType.CSV_REBLOCK);
            this.lps.addCompatibility(JobType.MMCJ);
            this.lps.addCompatibility(JobType.MMRJ);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = UaggOuterChain";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(PartialAggregate.getOpcode(this._uaggOp, this._uaggDir));
        sb.append("\u00b0");
        sb.append(Binary.getOpcode(this._binOp));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return true;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        return new int[]{2};
    }
}

