/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashSet;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CombineTernary
extends Lop {
    OperationTypes operation;

    public CombineTernary(OperationTypes op, Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt) {
        super(Lop.Type.CombineTernary, dt, vt);
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = true;
        this.lps.addCompatibility(JobType.COMBINE);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
        this.lps.setProducesIntermediateOutput(true);
    }

    @Override
    public String toString() {
        return "combineternary";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append("combineternary");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input_index2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input_index3));
        sb.append("\u00b0");
        sb.append(this.prepInputOperand(output_index));
        return sb.toString();
    }

    public OperationTypes getOperation() {
        return this.operation;
    }

    public static CombineTernary constructCombineLop(OperationTypes op, Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt) {
        HashSet<Lop> set1 = new HashSet<Lop>();
        set1.addAll(input1.getOutputs());
        set1.retainAll(input2.getOutputs());
        set1.retainAll(input3.getOutputs());
        for (Lop lop : set1) {
            if (lop.type != Lop.Type.CombineTernary) continue;
            CombineTernary combine = (CombineTernary)lop;
            if (combine.operation != op) continue;
            return (CombineTernary)lop;
        }
        CombineTernary comn = new CombineTernary(op, input1, input2, input3, dt, vt);
        comn.setAllPositions(input1.getFilename(), input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndColumn());
        return comn;
    }

    public static enum OperationTypes {
        PreCovWeighted;

    }
}

