/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Aggregate
extends Lop {
    OperationTypes operation;
    private boolean isCorrectionUsed = false;
    private PartialAggregate.CorrectionLocationType correctionLocation = PartialAggregate.CorrectionLocationType.INVALID;

    public Aggregate(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.Aggregate, dt, vt);
        this.init(input, op, dt, vt, et);
    }

    private void init(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.addInput(input);
        input.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    public void setupCorrectionLocation(PartialAggregate.CorrectionLocationType loc) {
        if (this.operation == OperationTypes.KahanSum || this.operation == OperationTypes.KahanSumSq || this.operation == OperationTypes.KahanTrace || this.operation == OperationTypes.Mean || this.operation == OperationTypes.Var) {
            this.isCorrectionUsed = true;
            this.correctionLocation = loc;
        }
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    private String getOpcode() {
        switch (this.operation) {
            case Sum: 
            case Trace: {
                return "a+";
            }
            case Mean: {
                return "amean";
            }
            case Var: {
                return "avar";
            }
            case Product: {
                return "a*";
            }
            case Min: {
                return "amin";
            }
            case Max: {
                return "amax";
            }
            case MaxIndex: {
                return "arimax";
            }
            case MinIndex: {
                return "arimin";
            }
            case KahanSum: 
            case KahanTrace: {
                return "ak+";
            }
            case KahanSumSq: {
                return "asqk+";
            }
        }
        throw new UnsupportedOperationException(this.printErrorLocation() + "Instruction is not defined for Aggregate operation: " + (Object)((Object)this.operation));
    }

    @Override
    public String getInstructions(int input_index, int output_index) throws LopsException {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String output) throws LopsException {
        boolean isCorrectionApplicable = this.getExecType() == LopProperties.ExecType.MR && (this.operation == OperationTypes.Mean || this.operation == OperationTypes.Var || this.operation == OperationTypes.KahanSum || this.operation == OperationTypes.KahanSumSq || this.operation == OperationTypes.KahanTrace);
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (isCorrectionApplicable) {
            sb.append("\u00b0");
            sb.append(this.isCorrectionUsed);
            sb.append("\u00b0");
            sb.append((Object)this.correctionLocation);
        }
        return sb.toString();
    }

    public static enum OperationTypes {
        Sum,
        Product,
        Min,
        Max,
        Trace,
        KahanSum,
        KahanSumSq,
        KahanTrace,
        Mean,
        Var,
        MaxIndex,
        MinIndex;

    }
}

