/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;

public class RewriteRemoveReadAfterWrite
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return null;
        }
        HashMap<String, Hop> reads = new HashMap<String, Hop>();
        HashMap<String, Hop> writes = new HashMap<String, Hop>();
        for (Hop hop : roots) {
            this.collectPersistentReadWriteOps(hop, writes, reads);
        }
        Hop.resetVisitStatus(roots);
        for (Map.Entry entry : reads.entrySet()) {
            String rfname = (String)entry.getKey();
            Hop rhop = (Hop)entry.getValue();
            if (!writes.containsKey(rfname) || writes.get(rfname).getBeginLine() >= rhop.getBeginLine() && writes.get(rfname).getEndLine() >= rhop.getEndLine()) continue;
            Hop input = writes.get(rfname).getInput().get(0);
            ArrayList parents = (ArrayList)rhop.getParent().clone();
            for (Hop p : parents) {
                HopRewriteUtils.replaceChildReference(p, rhop, input);
            }
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        return root;
    }

    private void collectPersistentReadWriteOps(Hop hop, HashMap<String, Hop> pWrites, HashMap<String, Hop> pReads) throws HopsException {
        if (hop.isVisited()) {
            return;
        }
        if (!hop.getInput().isEmpty()) {
            for (Hop c : hop.getInput()) {
                this.collectPersistentReadWriteOps(c, pWrites, pReads);
            }
        }
        if (hop instanceof DataOp) {
            Hop fname;
            DataOp dop = (DataOp)hop;
            if (dop.getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD) {
                pReads.put(dop.getFileName(), dop);
            } else if (dop.getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE && (fname = dop.getInput().get(dop.getParameterIndex("iofilename"))) instanceof LiteralOp) {
                pWrites.put(((LiteralOp)fname).getStringValue(), dop);
            }
        }
        hop.setVisited();
    }
}

