/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.InputInfo;

public class RewriteRemovePersistentReadWrite
extends HopRewriteRule {
    private static final Log LOG = LogFactory.getLog(RewriteRemovePersistentReadWrite.class.getName());
    private HashSet<String> _inputs = new HashSet();
    private HashSet<String> _outputs = null;
    private HashMap<String, MetaData> _inputsMeta = null;

    public RewriteRemovePersistentReadWrite(String[] in, String[] out) {
        this(in, out, null);
    }

    public RewriteRemovePersistentReadWrite(String[] in, String[] out, LocalVariableMap vars) {
        for (String var : in) {
            this._inputs.add(var);
        }
        this._outputs = new HashSet();
        for (String var : out) {
            this._outputs.add(var);
        }
        this._inputsMeta = new HashMap();
        if (vars != null) {
            for (String varname : in) {
                Data dat = vars.get(varname);
                if (dat == null || !(dat instanceof CacheableData)) continue;
                this._inputsMeta.put(varname, ((CacheableData)dat).getMetaData());
            }
        }
    }

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return null;
        }
        for (Hop h : roots) {
            this.rule_RemovePersistentDataOp(h);
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        if (root == null) {
            return root;
        }
        this.rule_RemovePersistentDataOp(root);
        return root;
    }

    private void rule_RemovePersistentDataOp(Hop hop) throws HopsException {
        if (hop.isVisited()) {
            return;
        }
        ArrayList<Hop> inputs = hop.getInput();
        for (int i = 0; i < inputs.size(); ++i) {
            this.rule_RemovePersistentDataOp(inputs.get(i));
        }
        if (hop instanceof DataOp) {
            DataOp dop = (DataOp)hop;
            Hop.DataOpTypes dotype = dop.getDataOpType();
            switch (dotype) {
                case PERSISTENTREAD: {
                    if (this._inputs.contains(dop.getName())) {
                        boolean matchingBlksz;
                        dop.setDataOpType(Hop.DataOpTypes.TRANSIENTREAD);
                        if (hop.getDataType() == Expression.DataType.SCALAR) {
                            dop.removeInput("iofilename");
                        }
                        if (!dop.requiresReblock() || !this._inputsMeta.containsKey(dop.getName()) || !(this._inputsMeta.get(dop.getName()) instanceof MetaDataFormat)) break;
                        MetaDataFormat meta = (MetaDataFormat)this._inputsMeta.get(dop.getName());
                        MatrixCharacteristics mc = meta.getMatrixCharacteristics();
                        boolean bl = matchingBlksz = (long)mc.getRowsPerBlock() == dop.getRowsInBlock() && (long)mc.getColsPerBlock() == dop.getColsInBlock();
                        if (meta.getInputInfo() != InputInfo.BinaryBlockInputInfo || !matchingBlksz && dop.getDataType() != Expression.DataType.FRAME) break;
                        dop.setRequiresReblock(false);
                        break;
                    }
                    LOG.warn("Non-registered persistent read of variable '" + dop.getName() + "' (line " + dop.getBeginLine() + ").");
                    break;
                }
                case PERSISTENTWRITE: {
                    if (this._outputs.contains(dop.getName())) {
                        dop.setDataOpType(Hop.DataOpTypes.TRANSIENTWRITE);
                        dop.setRowsInBlock(dop.getInput().get(0).getRowsInBlock());
                        dop.setColsInBlock(dop.getInput().get(0).getColsInBlock());
                        if (hop.getDataType() != Expression.DataType.SCALAR) break;
                        dop.removeInput("iofilename");
                        break;
                    }
                    LOG.warn("Non-registered persistent write of variable '" + dop.getName() + "' (line " + dop.getBeginLine() + ").");
                    break;
                }
            }
        }
        hop.setVisited();
    }
}

