/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LeftIndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.NaryOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public class HopRewriteUtils {
    public static boolean isValueTypeCast(Hop.OpOp1 op) {
        return op == Hop.OpOp1.CAST_AS_BOOLEAN || op == Hop.OpOp1.CAST_AS_INT || op == Hop.OpOp1.CAST_AS_DOUBLE;
    }

    public static boolean getBooleanValue(LiteralOp op) throws HopsException {
        switch (op.getValueType()) {
            case DOUBLE: {
                return op.getDoubleValue() != 0.0;
            }
            case INT: {
                return op.getLongValue() != 0L;
            }
            case BOOLEAN: {
                return op.getBooleanValue();
            }
        }
        throw new HopsException("Invalid boolean value: " + (Object)((Object)op.getValueType()));
    }

    public static boolean getBooleanValueSafe(LiteralOp op) {
        try {
            switch (op.getValueType()) {
                case DOUBLE: {
                    return op.getDoubleValue() != 0.0;
                }
                case INT: {
                    return op.getLongValue() != 0L;
                }
                case BOOLEAN: {
                    return op.getBooleanValue();
                }
            }
            throw new HopsException("Invalid boolean value: " + (Object)((Object)op.getValueType()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static double getDoubleValue(LiteralOp op) throws HopsException {
        switch (op.getValueType()) {
            case DOUBLE: {
                return op.getDoubleValue();
            }
            case INT: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1.0 : 0.0;
            }
        }
        throw new HopsException("Invalid double value: " + (Object)((Object)op.getValueType()));
    }

    public static double getDoubleValueSafe(LiteralOp op) {
        try {
            switch (op.getValueType()) {
                case DOUBLE: {
                    return op.getDoubleValue();
                }
                case INT: {
                    return op.getLongValue();
                }
                case BOOLEAN: {
                    return op.getBooleanValue() ? 1.0 : 0.0;
                }
            }
            throw new HopsException("Invalid double value: " + (Object)((Object)op.getValueType()));
        }
        catch (Exception exception) {
            return Double.MAX_VALUE;
        }
    }

    public static long getIntValue(LiteralOp op) throws HopsException {
        switch (op.getValueType()) {
            case DOUBLE: {
                return UtilFunctions.toLong(op.getDoubleValue());
            }
            case INT: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1L : 0L;
            }
        }
        throw new HopsException("Invalid int value: " + (Object)((Object)op.getValueType()));
    }

    public static long getIntValueSafe(LiteralOp op) {
        try {
            switch (op.getValueType()) {
                case DOUBLE: {
                    return UtilFunctions.toLong(op.getDoubleValue());
                }
                case INT: {
                    return op.getLongValue();
                }
                case BOOLEAN: {
                    return op.getBooleanValue() ? 1L : 0L;
                }
            }
            throw new RuntimeException("Invalid int value: " + (Object)((Object)op.getValueType()));
        }
        catch (Exception exception) {
            return Long.MAX_VALUE;
        }
    }

    public static boolean isLiteralOfValue(Hop hop, double val) {
        return hop instanceof LiteralOp && (hop.getValueType() == Expression.ValueType.DOUBLE || hop.getValueType() == Expression.ValueType.INT) && HopRewriteUtils.getDoubleValueSafe((LiteralOp)hop) == val;
    }

    public static boolean isLiteralOfValue(Hop hop, String val) {
        return hop instanceof LiteralOp && ((LiteralOp)hop).getStringValue().equals(val);
    }

    public static boolean isLiteralOfValue(Hop hop, boolean val) {
        try {
            return hop instanceof LiteralOp && hop.getValueType() == Expression.ValueType.BOOLEAN && ((LiteralOp)hop).getBooleanValue() == val;
        }
        catch (HopsException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ScalarObject getScalarObject(LiteralOp op) {
        try {
            return ScalarObjectFactory.createScalarObject(op.getValueType(), op);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create scalar object for constant. Continue.", ex);
        }
    }

    public static int getChildReferencePos(Hop parent, Hop child) {
        return parent.getInput().indexOf(child);
    }

    public static void removeChildReference(Hop parent, Hop child) {
        parent.getInput().remove(child);
        child.getParent().remove(parent);
    }

    public static void removeChildReferenceByPos(Hop parent, Hop child, int posChild) {
        parent.getInput().remove(posChild);
        child.getParent().remove(parent);
    }

    public static void removeAllChildReferences(Hop parent) {
        for (Hop child : parent.getInput()) {
            child.getParent().remove(parent);
        }
        parent.getInput().clear();
    }

    public static void addChildReference(Hop parent, Hop child) {
        parent.getInput().add(child);
        child.getParent().add(parent);
    }

    public static void addChildReference(Hop parent, Hop child, int pos) {
        parent.getInput().add(pos, child);
        child.getParent().add(parent);
    }

    public static Hop rewireAllParentChildReferences(Hop hold, Hop hnew) {
        ArrayList<Hop> parents = hold.getParent();
        while (!parents.isEmpty()) {
            HopRewriteUtils.replaceChildReference(parents.get(0), hold, hnew);
        }
        return hnew;
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew) {
        int pos = HopRewriteUtils.getChildReferencePos(parent, inOld);
        HopRewriteUtils.removeChildReferenceByPos(parent, inOld, pos);
        HopRewriteUtils.addChildReference(parent, inNew, pos);
        parent.refreshSizeInformation();
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew, int pos) {
        HopRewriteUtils.replaceChildReference(parent, inOld, inNew, pos, true);
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew, int pos, boolean refresh) {
        HopRewriteUtils.removeChildReferenceByPos(parent, inOld, pos);
        HopRewriteUtils.addChildReference(parent, inNew, pos);
        if (refresh) {
            parent.refreshSizeInformation();
        }
    }

    public static void cleanupUnreferenced(Hop ... inputs) {
        for (Hop input : inputs) {
            if (!input.getParent().isEmpty()) continue;
            HopRewriteUtils.removeAllChildReferences(input);
        }
    }

    public static Hop getOtherInput(Hop hop, Hop input) {
        for (Hop c : hop.getInput()) {
            if (c == input) continue;
            return c;
        }
        return null;
    }

    public static Hop getLargestInput(Hop hop) {
        return hop.getInput().stream().max(Comparator.comparing(h -> h.getLength())).orElse(null);
    }

    public static Hop createDataGenOp(Hop input, double value) throws HopsException {
        Hop rows = input.rowsKnown() ? new LiteralOp(input.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, input);
        Hop cols = input.colsKnown() ? new LiteralOp(input.getDim2()) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, input);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static DataGenOp copyDataGenOp(DataGenOp inputGen, double scale, double shift) throws HopsException {
        HashMap<String, Integer> params = inputGen.getParamIndexMap();
        Hop rows = inputGen.getInput().get(params.get("rows"));
        Hop cols = inputGen.getInput().get(params.get("cols"));
        Hop min = inputGen.getInput().get(params.get("min"));
        Hop max = inputGen.getInput().get(params.get("max"));
        Hop pdf = inputGen.getInput().get(params.get("pdf"));
        Hop mean = inputGen.getInput().get(params.get("lambda"));
        Hop sparsity = inputGen.getInput().get(params.get("sparsity"));
        Hop seed = inputGen.getInput().get(params.get("seed"));
        if (!(min instanceof LiteralOp) || !(max instanceof LiteralOp)) {
            return null;
        }
        double smin = HopRewriteUtils.getDoubleValue((LiteralOp)min);
        double smax = HopRewriteUtils.getDoubleValue((LiteralOp)max);
        smin = smin * scale + shift;
        smax = smax * scale + shift;
        LiteralOp sminHop = new LiteralOp(smin);
        LiteralOp smaxHop = new LiteralOp(smax);
        HashMap<String, Hop> params2 = new HashMap<String, Hop>();
        params2.put("rows", rows);
        params2.put("cols", cols);
        params2.put("min", sminHop);
        params2.put("max", smaxHop);
        params2.put("pdf", pdf);
        params2.put("lambda", mean);
        params2.put("sparsity", sparsity);
        params2.put("seed", seed);
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params2);
        datagen.setOutputBlocksizes(inputGen.getRowsInBlock(), inputGen.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(inputGen, datagen);
        if (smin == 0.0 && smax == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOp(Hop rowInput, Hop colInput, double value) throws HopsException {
        Hop rows = rowInput.rowsKnown() ? new LiteralOp(rowInput.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, rowInput);
        Hop cols = colInput.colsKnown() ? new LiteralOp(colInput.getDim2()) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, colInput);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(rowInput.getRowsInBlock(), colInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(rowInput, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOp(Hop rowInput, boolean tRowInput, Hop colInput, boolean tColInput, double value) throws HopsException {
        Hop rows;
        long ncol;
        long nrow = tRowInput ? rowInput.getDim2() : rowInput.getDim1();
        long l = ncol = tColInput ? colInput.getDim1() : rowInput.getDim2();
        Hop hop = nrow >= 0L ? new LiteralOp(nrow) : (rows = new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, tRowInput ? Hop.OpOp1.NCOL : Hop.OpOp1.NROW, rowInput));
        Hop cols = ncol >= 0L ? new LiteralOp(ncol) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, tColInput ? Hop.OpOp1.NROW : Hop.OpOp1.NCOL, colInput);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(rowInput.getRowsInBlock(), colInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(rowInput, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOpByVal(Hop rowInput, Hop colInput, double value) throws HopsException {
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rowInput);
        params.put("cols", colInput);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(rowInput.getRowsInBlock(), colInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(rowInput, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOpByVal(ArrayList<LiteralOp> values, long rows, long cols) throws HopsException {
        StringBuilder sb = new StringBuilder();
        for (LiteralOp lit : values) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(lit.getStringValue());
        }
        LiteralOp str = new LiteralOp(sb.toString());
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", new LiteralOp(rows));
        params.put("cols", new LiteralOp(cols));
        params.put("min", str);
        params.put("max", str);
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.SINIT, new DataIdentifier("tmp"), params);
        int blksz = ConfigurationManager.getBlocksize();
        datagen.setOutputBlocksizes(blksz, blksz);
        HopRewriteUtils.copyLineNumbers(values.get(0), datagen);
        return datagen;
    }

    public static boolean isDataGenOp(Hop hop, Hop.DataGenMethod ... ops) {
        return hop instanceof DataGenOp && ArrayUtils.contains((Object[])ops, (Object)((DataGenOp)hop).getOp());
    }

    public static boolean isDataGenOpWithConstantValue(Hop hop) {
        return hop instanceof DataGenOp && ((DataGenOp)hop).getOp() == Hop.DataGenMethod.RAND && ((DataGenOp)hop).hasConstantValue();
    }

    public static boolean isDataGenOpWithConstantValue(Hop hop, double value) {
        return hop instanceof DataGenOp && ((DataGenOp)hop).getOp() == Hop.DataGenMethod.RAND && ((DataGenOp)hop).hasConstantValue(value);
    }

    public static Hop getDataGenOpConstantValue(Hop hop) {
        return ((DataGenOp)hop).getConstantValue();
    }

    public static ReorgOp createTranspose(Hop input) {
        return HopRewriteUtils.createReorg(input, Hop.ReOrgOp.TRANSPOSE);
    }

    public static ReorgOp createReorg(Hop input, Hop.ReOrgOp rop) {
        ReorgOp reorg = new ReorgOp(input.getName(), input.getDataType(), input.getValueType(), rop, input);
        reorg.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, reorg);
        reorg.refreshSizeInformation();
        return reorg;
    }

    public static ReorgOp createReorg(ArrayList<Hop> inputs, Hop.ReOrgOp rop) {
        Hop main = inputs.get(0);
        ReorgOp reorg = new ReorgOp(main.getName(), main.getDataType(), main.getValueType(), rop, inputs);
        reorg.setOutputBlocksizes(main.getRowsInBlock(), main.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(main, reorg);
        reorg.refreshSizeInformation();
        return reorg;
    }

    public static UnaryOp createUnary(Hop input, Hop.OpOp1 type) {
        Expression.DataType dt = type == Hop.OpOp1.CAST_AS_SCALAR ? Expression.DataType.SCALAR : (type == Hop.OpOp1.CAST_AS_MATRIX ? Expression.DataType.MATRIX : input.getDataType());
        Expression.ValueType vt = type == Hop.OpOp1.CAST_AS_MATRIX ? Expression.ValueType.DOUBLE : input.getValueType();
        UnaryOp unary = new UnaryOp(input.getName(), dt, vt, type, input);
        unary.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        if (type == Hop.OpOp1.CAST_AS_SCALAR || type == Hop.OpOp1.CAST_AS_MATRIX) {
            int dim = type == Hop.OpOp1.CAST_AS_SCALAR ? 0 : 1;
            int blksz = type == Hop.OpOp1.CAST_AS_SCALAR ? 0 : ConfigurationManager.getBlocksize();
            HopRewriteUtils.setOutputParameters(unary, dim, dim, blksz, blksz, -1L);
        }
        HopRewriteUtils.copyLineNumbers(input, unary);
        unary.refreshSizeInformation();
        return unary;
    }

    public static BinaryOp createBinaryMinus(Hop input) {
        return HopRewriteUtils.createBinary(new LiteralOp(0L), input, Hop.OpOp2.MINUS);
    }

    public static BinaryOp createBinary(Hop input1, Hop input2, Hop.OpOp2 op) {
        return HopRewriteUtils.createBinary(input1, input2, op, false);
    }

    public static BinaryOp createBinary(Hop input1, Hop input2, Hop.OpOp2 op, boolean outer) {
        Hop mainInput = input1.getDataType().isMatrix() ? input1 : (input2.getDataType().isMatrix() ? input2 : input1);
        BinaryOp bop = new BinaryOp(mainInput.getName(), mainInput.getDataType(), mainInput.getValueType(), op, input1, input2);
        if (bop.isPPredOperation() && bop.getDataType().isScalar()) {
            bop.setValueType(Expression.ValueType.BOOLEAN);
        }
        bop.setOuterVectorOperation(outer);
        bop.setOutputBlocksizes(mainInput.getRowsInBlock(), mainInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(mainInput, bop);
        bop.refreshSizeInformation();
        return bop;
    }

    public static AggUnaryOp createSum(Hop input) {
        return HopRewriteUtils.createAggUnaryOp(input, Hop.AggOp.SUM, Hop.Direction.RowCol);
    }

    public static AggUnaryOp createAggUnaryOp(Hop input, Hop.AggOp op, Hop.Direction dir) {
        Expression.DataType dt = dir == Hop.Direction.RowCol ? Expression.DataType.SCALAR : input.getDataType();
        AggUnaryOp auop = new AggUnaryOp(input.getName(), dt, input.getValueType(), op, dir, input);
        auop.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, auop);
        auop.refreshSizeInformation();
        return auop;
    }

    public static AggBinaryOp createMatrixMultiply(Hop left, Hop right) {
        AggBinaryOp mmult = new AggBinaryOp(left.getName(), left.getDataType(), left.getValueType(), Hop.OpOp2.MULT, Hop.AggOp.SUM, left, right);
        mmult.setOutputBlocksizes(left.getRowsInBlock(), right.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(left, mmult);
        mmult.refreshSizeInformation();
        return mmult;
    }

    public static ParameterizedBuiltinOp createParameterizedBuiltinOp(Hop input, HashMap<String, Hop> args, Hop.ParamBuiltinOp op) {
        ParameterizedBuiltinOp pbop = new ParameterizedBuiltinOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, op, args);
        pbop.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, pbop);
        pbop.refreshSizeInformation();
        return pbop;
    }

    public static Hop createScalarIndexing(Hop input, long rix, long cix) {
        IndexingOp ix = HopRewriteUtils.createIndexingOp(input, rix, cix);
        return HopRewriteUtils.createUnary(ix, Hop.OpOp1.CAST_AS_SCALAR);
    }

    public static IndexingOp createIndexingOp(Hop input, long rix, long cix) {
        LiteralOp row = new LiteralOp(rix);
        LiteralOp col = new LiteralOp(cix);
        return HopRewriteUtils.createIndexingOp(input, row, row, col, col);
    }

    public static IndexingOp createIndexingOp(Hop input, Hop rl, Hop ru, Hop cl, Hop cu) {
        IndexingOp ix = new IndexingOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, input, rl, ru, cl, cu, rl == ru, cl == cu);
        ix.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, ix);
        ix.refreshSizeInformation();
        return ix;
    }

    public static LeftIndexingOp createLeftIndexingOp(Hop lhs, Hop rhs, Hop rl, Hop ru, Hop cl, Hop cu) {
        LeftIndexingOp ix = new LeftIndexingOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, lhs, rhs, rl, ru, cl, cu, rl == ru, cl == cu);
        ix.setOutputBlocksizes(lhs.getRowsInBlock(), lhs.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(lhs, ix);
        ix.refreshSizeInformation();
        return ix;
    }

    public static NaryOp createNary(Hop.OpOpN op, Hop ... inputs) throws HopsException {
        Hop mainInput = inputs[0];
        NaryOp nop = new NaryOp(mainInput.getName(), mainInput.getDataType(), mainInput.getValueType(), op, inputs);
        nop.setOutputBlocksizes(mainInput.getRowsInBlock(), mainInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(mainInput, nop);
        nop.refreshSizeInformation();
        return nop;
    }

    public static Hop createValueHop(Hop hop, boolean row) throws HopsException {
        Hop ret = null;
        ret = row ? (hop.rowsKnown() ? new LiteralOp(hop.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, hop)) : (hop.colsKnown() ? new LiteralOp(hop.getDim2()) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, hop));
        return ret;
    }

    public static DataGenOp createSeqDataGenOp(Hop input) throws HopsException {
        return HopRewriteUtils.createSeqDataGenOp(input, true);
    }

    public static DataGenOp createSeqDataGenOp(Hop input, boolean asc) throws HopsException {
        Hop to = input.rowsKnown() ? new LiteralOp(input.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, input);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        if (asc) {
            params.put("from", new LiteralOp(1L));
            params.put("to", to);
            params.put("incr", new LiteralOp(1L));
        } else {
            params.put("from", to);
            params.put("to", new LiteralOp(1L));
            params.put("incr", new LiteralOp(-1L));
        }
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.SEQ, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, datagen);
        return datagen;
    }

    public static TernaryOp createTernaryOp(Hop mleft, Hop smid, Hop mright, Hop.OpOp3 op) {
        TernaryOp ternOp = new TernaryOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, op, mleft, smid, mright);
        ternOp.setOutputBlocksizes(mleft.getRowsInBlock(), mleft.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(mleft, ternOp);
        ternOp.refreshSizeInformation();
        return ternOp;
    }

    public static DataOp createDataOp(String name, Hop input, Hop.DataOpTypes type) {
        DataOp dop = new DataOp(name, input.getDataType(), input.getValueType(), input, type, null);
        dop.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, dop);
        dop.refreshSizeInformation();
        return dop;
    }

    public static void setOutputParameters(Hop hop, long rlen, long clen, long brlen, long bclen, long nnz) {
        hop.setDim1(rlen);
        hop.setDim2(clen);
        hop.setOutputBlocksizes(brlen, bclen);
        hop.setNnz(nnz);
    }

    public static void setOutputParametersForScalar(Hop hop) {
        hop.setDataType(Expression.DataType.SCALAR);
        hop.setDim1(0L);
        hop.setDim2(0L);
        hop.setOutputBlocksizes(-1L, -1L);
        hop.setNnz(-1L);
    }

    public static void refreshOutputParameters(Hop hnew, Hop hold) {
        hnew.setDim1(hold.getDim1());
        hnew.setDim2(hold.getDim2());
        hnew.setOutputBlocksizes(hold.getRowsInBlock(), hold.getColsInBlock());
        hnew.refreshSizeInformation();
    }

    public static void copyLineNumbers(Hop src, Hop dest) {
        dest.setParseInfo(src);
    }

    public static void updateHopCharacteristics(Hop hop, long brlen, long bclen, Hop src) {
        HopRewriteUtils.updateHopCharacteristics(hop, brlen, bclen, new MemoTable(), src);
    }

    public static void updateHopCharacteristics(Hop hop, long brlen, long bclen, MemoTable memo, Hop src) {
        hop.setOutputBlocksizes(brlen, bclen);
        hop.refreshSizeInformation();
        hop.computeMemEstimate(memo);
        HopRewriteUtils.copyLineNumbers(src, hop);
    }

    public static boolean isDimsKnown(Hop hop) {
        return hop.dimsKnown();
    }

    public static boolean isEmpty(Hop hop) {
        return hop.getNnz() == 0L;
    }

    public static boolean isEqualSize(Hop hop1, Hop hop2) {
        return hop1.dimsKnown() && hop2.dimsKnown() && hop1.getDim1() == hop2.getDim1() && hop1.getDim2() == hop2.getDim2();
    }

    public static boolean isEqualSize(Hop hop1, Hop ... hops) {
        boolean ret = hop1.dimsKnown();
        for (int i = 0; i < hops.length && ret; ret &= HopRewriteUtils.isEqualSize(hop1, hops[i]), ++i) {
        }
        return ret;
    }

    public static boolean isSingleBlock(Hop hop) {
        return HopRewriteUtils.isSingleBlock(hop, true) && HopRewriteUtils.isSingleBlock(hop, false);
    }

    public static boolean isSingleBlock(Hop hop, boolean cols) {
        if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE) {
            return true;
        }
        return cols ? hop.colsKnown() && hop.getDim2() <= hop.getColsInBlock() : hop.rowsKnown() && hop.getDim1() <= hop.getRowsInBlock();
    }

    public static boolean isOuterProductLikeMM(Hop hop) {
        return HopRewriteUtils.isMatrixMultiply(hop) && hop.dimsKnown() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(1).dimsKnown() && hop.getInput().get(0).getDim1() > hop.getInput().get(0).getDim2() && hop.getInput().get(1).getDim1() < hop.getInput().get(1).getDim2();
    }

    public static boolean isValidOuterBinaryOp(Hop.OpOp2 op) {
        String opcode = Hop.getBinaryOpCode(op);
        return Hop.getOpOp2ForOuterVectorOperation(opcode) == op;
    }

    public static boolean isSparse(Hop hop) {
        return hop.dimsKnown(true) && MatrixBlock.evalSparseFormatInMemory(hop.getDim1(), hop.getDim2(), hop.getNnz());
    }

    public static boolean isDense(Hop hop) {
        return hop.dimsKnown(true) && !MatrixBlock.evalSparseFormatInMemory(hop.getDim1(), hop.getDim2(), hop.getNnz());
    }

    public static boolean isSparse(Hop hop, double threshold) {
        return hop.getSparsity() < threshold;
    }

    public static boolean isEqualValue(LiteralOp hop1, LiteralOp hop2) throws HopsException {
        double val2;
        if (hop1.getValueType() == Expression.ValueType.STRING || hop2.getValueType() == Expression.ValueType.STRING) {
            return false;
        }
        double val1 = HopRewriteUtils.getDoubleValue(hop1);
        return val1 == (val2 = HopRewriteUtils.getDoubleValue(hop2));
    }

    public static boolean isNotMatrixVectorBinaryOperation(Hop hop) {
        boolean ret = true;
        if (hop instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hop;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            boolean mv = left.getDim1() > 1L && right.getDim1() == 1L || left.getDim2() > 1L && right.getDim2() == 1L;
            ret = HopRewriteUtils.isDimsKnown(bop) && !mv;
        }
        return ret;
    }

    public static boolean isReorg(Hop hop, Hop.ReOrgOp type) {
        return hop instanceof ReorgOp && ((ReorgOp)hop).getOp() == type;
    }

    public static boolean isReorg(Hop hop, Hop.ReOrgOp ... types) {
        return hop instanceof ReorgOp && ArrayUtils.contains((Object[])types, (Object)((ReorgOp)hop).getOp());
    }

    public static boolean isTransposeOperation(Hop hop) {
        return HopRewriteUtils.isReorg(hop, Hop.ReOrgOp.TRANSPOSE);
    }

    public static boolean isTransposeOperation(Hop hop, int maxParents) {
        return HopRewriteUtils.isTransposeOperation(hop) && hop.getParent().size() <= maxParents;
    }

    public static boolean containsTransposeOperation(ArrayList<Hop> hops) {
        boolean ret = false;
        for (Hop hop : hops) {
            ret |= HopRewriteUtils.isTransposeOperation(hop);
        }
        return ret;
    }

    public static boolean isTransposeOfItself(Hop hop1, Hop hop2) {
        return HopRewriteUtils.isTransposeOperation(hop1) && hop1.getInput().get(0) == hop2 || HopRewriteUtils.isTransposeOperation(hop2) && hop2.getInput().get(0) == hop1;
    }

    public static boolean isTsmmInput(Hop input) {
        if (input.getParent().size() == 2) {
            for (int i = 0; i < 2; ++i) {
                if (!HopRewriteUtils.isMatrixMultiply(input.getParent().get(i)) || !HopRewriteUtils.isTransposeOfItself(input.getParent().get(i).getInput().get(0), input.getParent().get(i).getInput().get(1))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(Hop hop, Hop.OpOp2 type) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == type;
    }

    public static boolean isBinary(Hop hop, Hop.OpOp2 ... types) {
        return hop instanceof BinaryOp && ArrayUtils.contains((Object[])types, (Object)((BinaryOp)hop).getOp());
    }

    public static boolean isBinary(Hop hop, Hop.OpOp2 type, int maxParents) {
        return HopRewriteUtils.isBinary(hop, type) && hop.getParent().size() <= maxParents;
    }

    public static boolean isBinarySparseSafe(Hop hop) {
        if (!(hop instanceof BinaryOp)) {
            return false;
        }
        if (HopRewriteUtils.isBinary(hop, Hop.OpOp2.MULT, Hop.OpOp2.DIV)) {
            return true;
        }
        BinaryOp bop = (BinaryOp)hop;
        Hop lit = bop.getInput().get(0) instanceof LiteralOp ? bop.getInput().get(0) : (bop.getInput().get(1) instanceof LiteralOp ? bop.getInput().get(1) : null);
        return lit != null && OptimizerUtils.isBinaryOpSparsityConditionalSparseSafe(bop.getOp(), (LiteralOp)lit);
    }

    public static boolean isBinaryMatrixScalarOperation(Hop hop) {
        return hop instanceof BinaryOp && (hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isScalar() || hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).getDataType().isScalar());
    }

    public static boolean isBinaryMatrixMatrixOperation(Hop hop) {
        return hop instanceof BinaryOp && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L && hop.getInput().get(1).dimsKnown() && hop.getInput().get(1).getDim1() > 1L && hop.getInput().get(1).getDim2() > 1L;
    }

    public static boolean isBinaryMatrixMatrixOperationWithSharedInput(Hop hop) {
        boolean ret = HopRewriteUtils.isBinaryMatrixMatrixOperation(hop);
        ret = ret && (HopRewriteUtils.rContainsInput(hop.getInput().get(0), hop.getInput().get(1), new HashSet<Long>()) || HopRewriteUtils.rContainsInput(hop.getInput().get(1), hop.getInput().get(0), new HashSet<Long>()));
        return ret;
    }

    public static boolean isBinaryMatrixScalar(Hop hop, Hop.OpOp2 type, double val) {
        return HopRewriteUtils.isBinary(hop, type) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(0), val) || HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), val));
    }

    public static boolean isTernary(Hop hop, Hop.OpOp3 type) {
        return hop instanceof TernaryOp && ((TernaryOp)hop).getOp() == type;
    }

    public static boolean isTernary(Hop hop, Hop.OpOp3 ... types) {
        return hop instanceof TernaryOp && ArrayUtils.contains((Object[])types, (Object)((TernaryOp)hop).getOp());
    }

    public static boolean containsInput(Hop current, Hop probe) {
        return HopRewriteUtils.rContainsInput(current, probe, new HashSet<Long>());
    }

    private static boolean rContainsInput(Hop current, Hop probe, HashSet<Long> memo) {
        if (memo.contains(current.getHopID())) {
            return false;
        }
        boolean ret = false;
        for (int i = 0; i < current.getInput().size() && !ret; ret |= HopRewriteUtils.rContainsInput(current.getInput().get(i), probe, memo), ++i) {
        }
        boolean bl = current == probe;
        memo.add(current.getHopID());
        return ret |= bl;
    }

    public static boolean isData(Hop hop, Hop.DataOpTypes type) {
        return hop instanceof DataOp && ((DataOp)hop).getDataOpType() == type;
    }

    public static boolean isBinaryMatrixColVectorOperation(Hop hop) {
        return hop instanceof BinaryOp && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(1).dimsKnown() && hop.getInput().get(1).getDim2() == 1L;
    }

    public static boolean isUnary(Hop hop, Hop.OpOp1 type) {
        return hop instanceof UnaryOp && ((UnaryOp)hop).getOp() == type;
    }

    public static boolean isUnary(Hop hop, Hop.OpOp1 type, int maxParents) {
        return HopRewriteUtils.isUnary(hop, type) && hop.getParent().size() <= maxParents;
    }

    public static boolean isUnary(Hop hop, Hop.OpOp1 ... types) {
        return hop instanceof UnaryOp && ArrayUtils.contains((Object[])types, (Object)((UnaryOp)hop).getOp());
    }

    public static boolean isMatrixMultiply(Hop hop) {
        return hop instanceof AggBinaryOp && ((AggBinaryOp)hop).isMatrixMultiply();
    }

    public static boolean isAggUnaryOp(Hop hop, Hop.AggOp ... op) {
        if (!(hop instanceof AggUnaryOp)) {
            return false;
        }
        Hop.AggOp hopOp = ((AggUnaryOp)hop).getOp();
        return ArrayUtils.contains((Object[])op, (Object)hopOp);
    }

    public static boolean isSum(Hop hop) {
        return hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getOp() == Hop.AggOp.SUM;
    }

    public static boolean isSumSq(Hop hop) {
        return hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getOp() == Hop.AggOp.SUM_SQ;
    }

    public static boolean isNary(Hop hop, Hop.OpOpN type) {
        return hop instanceof NaryOp && ((NaryOp)hop).getOp() == type;
    }

    public static boolean isNary(Hop hop, Hop.OpOpN ... types) {
        return hop instanceof NaryOp && ArrayUtils.contains((Object[])types, (Object)((NaryOp)hop).getOp());
    }

    public static boolean isNonZeroIndicator(Hop pred, Hop hop) {
        return pred instanceof BinaryOp && ((BinaryOp)pred).getOp() == Hop.OpOp2.NOTEQUAL && pred.getInput().get(0) == hop && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0;
    }

    public static boolean checkInputDataTypes(Hop hop, Expression.DataType ... dt) {
        for (int i = 0; i < hop.getInput().size(); ++i) {
            if (hop.getInput().get(i).getDataType() == dt[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isColumnRightIndexing(Hop hop) {
        return hop instanceof IndexingOp && ((IndexingOp)hop).isColLowerEqualsUpper() && (hop.dimsKnown() && hop.getDim1() == hop.getInput().get(0).getDim1() || HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && HopRewriteUtils.isUnary(hop.getInput().get(2), Hop.OpOp1.NROW) && hop.getInput().get(2).getInput().get(0) == hop.getInput().get(0));
    }

    public static boolean isFullColumnIndexing(LeftIndexingOp hop) {
        return hop.isColLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(2), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), hop.getDim1()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(3), hop.getInput().get(0), true));
    }

    public static boolean isFullColumnIndexing(IndexingOp hop) {
        return hop.isColLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(2), hop.getDim1()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(2), hop.getInput().get(0), true));
    }

    public static boolean isFullRowIndexing(LeftIndexingOp hop) {
        return hop.isRowLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(4), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(5), hop.getDim2()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(5), hop.getInput().get(0), false));
    }

    public static boolean isFullRowIndexing(IndexingOp hop) {
        return hop.isRowLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(4), hop.getDim2()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(4), hop.getInput().get(0), false));
    }

    public static boolean isColumnRangeIndexing(IndexingOp hop) {
        return (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(2), hop.getInput().get(0).getDim1()) || hop.getDim1() == hop.getInput().get(0).getDim1()) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), 1.0) && hop.getInput().get(4) instanceof LiteralOp;
    }

    public static boolean isConsecutiveIndex(Hop index, Hop index2) {
        return index instanceof LiteralOp && index2 instanceof LiteralOp ? HopRewriteUtils.getDoubleValueSafe((LiteralOp)index2) == HopRewriteUtils.getDoubleValueSafe((LiteralOp)index) + 1.0 : HopRewriteUtils.isBinaryMatrixScalar(index2, Hop.OpOp2.PLUS, 1.0) && (index2.getInput().get(0) == index || index2.getInput().get(1) == index);
    }

    public static boolean isUnnecessaryRightIndexing(Hop hop) {
        if (!(hop instanceof IndexingOp)) {
            return false;
        }
        return HopRewriteUtils.isEqualSize(hop, hop.getInput().get(0)) && (hop.getDim1() != 1L || hop.getDim2() != 1L) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), 1.0);
    }

    public static boolean isScalarMatrixBinaryMult(Hop hop) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == Hop.OpOp2.MULT && (hop.getInput().get(0).getDataType() == Expression.DataType.SCALAR && hop.getInput().get(1).getDataType() == Expression.DataType.MATRIX || hop.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hop.getInput().get(1).getDataType() == Expression.DataType.SCALAR);
    }

    public static boolean isBasic1NSequence(Hop hop) {
        if (hop instanceof DataGenOp && ((DataGenOp)hop).getOp() == Hop.DataGenMethod.SEQ) {
            DataGenOp dgop = (DataGenOp)hop;
            Hop from = dgop.getInput().get(dgop.getParamIndex("from"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            return from instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)from) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == 1.0;
        }
        return false;
    }

    public static boolean isBasic1NSequence(Hop seq, Hop input, boolean row) {
        if (seq instanceof DataGenOp && ((DataGenOp)seq).getOp() == Hop.DataGenMethod.SEQ) {
            DataGenOp dgop = (DataGenOp)seq;
            Hop from = dgop.getInput().get(dgop.getParamIndex("from"));
            Hop to = dgop.getInput().get(dgop.getParamIndex("to"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            return HopRewriteUtils.isLiteralOfValue(from, 1.0) && HopRewriteUtils.isLiteralOfValue(incr, 1.0) && HopRewriteUtils.isSizeExpressionOf(to, input, row);
        }
        return false;
    }

    public static boolean isBasicN1Sequence(Hop hop) {
        DataGenOp dgop;
        boolean ret = false;
        if (hop instanceof DataGenOp && (dgop = (DataGenOp)hop).getOp() == Hop.DataGenMethod.SEQ) {
            Hop to = dgop.getInput().get(dgop.getParamIndex("to"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            ret = to instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)to) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == -1.0;
        }
        return ret;
    }

    public static Hop getBasic1NSequenceMax(Hop hop) throws HopsException {
        if (HopRewriteUtils.isDataGenOp(hop, Hop.DataGenMethod.SEQ)) {
            DataGenOp dgop = (DataGenOp)hop;
            return dgop.getInput().get(dgop.getParamIndex("to"));
        }
        throw new HopsException("Failed to retrieve 'to' argument from basic 1-N sequence.");
    }

    public static boolean isSizeExpressionOf(Hop size, Hop input, boolean row) {
        return input.dimsKnown() && HopRewriteUtils.isLiteralOfValue(size, row ? (double)input.getDim1() : (double)input.getDim2()) || (row ? HopRewriteUtils.isUnary(size, Hop.OpOp1.NROW) : HopRewriteUtils.isUnary(size, Hop.OpOp1.NCOL)) && (size.getInput().get(0) == input || HopRewriteUtils.isColumnRightIndexing(input) && size.getInput().get(0) == input.getInput().get(0));
    }

    public static boolean hasOnlyWriteParents(Hop hop, boolean inclTransient, boolean inclPersistent) {
        boolean ret = true;
        ArrayList<Hop> parents = hop.getParent();
        for (Hop p : parents) {
            if (inclTransient && inclPersistent) {
                ret &= p instanceof DataOp && (((DataOp)p).getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE || ((DataOp)p).getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE);
                continue;
            }
            if (inclTransient) {
                ret &= p instanceof DataOp && ((DataOp)p).getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE;
                continue;
            }
            if (!inclPersistent) continue;
            ret &= p instanceof DataOp && ((DataOp)p).getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE;
        }
        return ret;
    }

    public static boolean alwaysRequiresReblock(Hop hop) {
        return hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD && ((DataOp)hop).getInputFormatType() != Hop.FileFormatTypes.BINARY;
    }

    public static boolean containsOp(ArrayList<Hop> candidates, Class<? extends Hop> clazz) {
        if (candidates != null) {
            for (Hop cand : candidates) {
                if (!cand.getClass().equals(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean rHasSimpleReadChain(Hop root, String var) {
        if (root.isVisited()) {
            return false;
        }
        boolean ret = false;
        if (root instanceof DataOp && ((DataOp)root).isRead() && root.getName().equals(var)) {
            ret = root.getParent().size() <= 1;
        }
        for (Hop c : root.getInput()) {
            if (!HopRewriteUtils.rHasSimpleReadChain(c, var)) continue;
            ret |= root.getParent().size() <= 1;
        }
        root.setVisited();
        return ret;
    }

    public static boolean rContainsRead(Hop root, String var, boolean includeMetaOp) {
        if (root.isVisited()) {
            return false;
        }
        boolean ret = false;
        if (root instanceof DataOp && ((DataOp)root).isRead() && root.getName().equals(var)) {
            boolean onlyMetaOp = true;
            if (!includeMetaOp) {
                for (Hop p : root.getParent()) {
                    onlyMetaOp &= p instanceof UnaryOp && (((UnaryOp)p).getOp() == Hop.OpOp1.NROW || ((UnaryOp)p).getOp() == Hop.OpOp1.NCOL);
                }
                ret = !onlyMetaOp;
            } else {
                ret = true;
            }
        }
        for (Hop c : root.getInput()) {
            ret |= HopRewriteUtils.rContainsRead(c, var, includeMetaOp);
        }
        root.setVisited();
        return ret;
    }

    public static boolean isValidOp(Hop.AggOp input, Hop.AggOp ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)input);
    }

    public static boolean isValidOp(Hop.OpOp1 input, Hop.OpOp1 ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)input);
    }

    public static boolean isValidOp(Hop.OpOp2 input, Hop.OpOp2 ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)input);
    }

    public static boolean isValidOp(Hop.ReOrgOp input, Hop.ReOrgOp ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)input);
    }

    public static boolean isValidOp(Hop.ParamBuiltinOp input, Hop.ParamBuiltinOp ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)input);
    }

    public static int getValidOpPos(Hop.OpOp2 input, Hop.OpOp2 ... validTab) {
        return ArrayUtils.indexOf((Object[])validTab, (Object)input);
    }

    public static int compareSize(Hop hop1, Hop hop2) {
        long size1 = hop1.getDim1() * hop1.getDim2();
        long size2 = hop2.getDim1() * hop2.getDim2();
        return Long.compare(size1, size2);
    }

    public static boolean isLastLevelStatementBlock(StatementBlock sb) {
        return !(sb instanceof FunctionStatementBlock) && !(sb instanceof WhileStatementBlock) && !(sb instanceof IfStatementBlock) && !(sb instanceof ForStatementBlock);
    }

    public static long getMaxNrowInput(Hop hop) {
        return HopRewriteUtils.getMaxInputDim(hop, true);
    }

    public static long getMaxNcolInput(Hop hop) {
        return HopRewriteUtils.getMaxInputDim(hop, false);
    }

    public static long getMaxInputDim(Hop hop, boolean dim1) {
        return hop.getInput().stream().mapToLong(h -> dim1 ? h.getDim1() : h.getDim2()).max().orElse(-1L);
    }

    public static long getSumValidInputDims(Hop hop, boolean dim1) {
        if (!HopRewriteUtils.hasValidInputDims(hop, dim1)) {
            return -1L;
        }
        return hop.getInput().stream().mapToLong(h -> dim1 ? h.getDim1() : h.getDim2()).sum();
    }

    public static boolean hasValidInputDims(Hop hop, boolean dim1) {
        return hop.getInput().stream().allMatch(h -> dim1 ? h.rowsKnown() : h.colsKnown());
    }
}

