/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.globalopt;

import java.util.ArrayList;
import org.apache.sysml.hops.globalopt.Plan;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFCrossBlockNode;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFNode;

public class PlanSet {
    private ArrayList<Plan> _plans = null;

    public PlanSet() {
        this._plans = new ArrayList();
    }

    public PlanSet(ArrayList<Plan> plans) {
        this._plans = plans;
    }

    public ArrayList<Plan> getPlans() {
        return this._plans;
    }

    public void setPlans(ArrayList<Plan> plans) {
        this._plans = plans;
    }

    public int size() {
        if (this._plans == null) {
            return 0;
        }
        return this._plans.size();
    }

    public boolean isEmpty() {
        if (this._plans == null) {
            return true;
        }
        return this._plans.isEmpty();
    }

    public PlanSet crossProductChild(PlanSet pc) {
        if (pc == null || pc.isEmpty()) {
            return this;
        }
        if (this._plans == null || this._plans.isEmpty()) {
            return pc;
        }
        ArrayList<Plan> Pnew = new ArrayList<Plan>();
        for (Plan p : this._plans) {
            for (Plan c : pc.getPlans()) {
                Plan pnew = new Plan(p);
                pnew.addChild(c);
                Pnew.add(pnew);
            }
        }
        return new PlanSet(Pnew);
    }

    public PlanSet selectChild(GDFNode node) {
        String varname = node.getNodeType() == GDFNode.NodeType.HOP_NODE ? node.getHop().getName() : ((GDFCrossBlockNode)node).getName();
        ArrayList<Plan> Pnew = new ArrayList<Plan>();
        for (Plan p : this._plans) {
            if (p.getNode().getHop() == null || !p.getNode().getHop().getName().equals(varname)) continue;
            Pnew.add(p);
        }
        return new PlanSet(Pnew);
    }

    public PlanSet union(PlanSet ps) {
        ArrayList<Plan> Pnew = new ArrayList<Plan>(this._plans);
        for (Plan p : ps._plans) {
            Pnew.add(p);
        }
        return new PlanSet(Pnew);
    }

    public Plan getPlanWithMinCosts() {
        double optCosts = Double.MAX_VALUE;
        Plan optPlan = null;
        for (Plan p : this._plans) {
            if (!(p.getCosts() < optCosts)) continue;
            optCosts = p.getCosts();
            optPlan = p;
        }
        return optPlan;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PLAN_SET@" + super.hashCode() + ":\n");
        for (Plan p : this._plans) {
            sb.append("--");
            sb.append(p.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

