/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.globalopt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.globalopt.GDFEnumOptimizer;
import org.apache.sysml.hops.globalopt.GlobalOptimizer;
import org.apache.sysml.hops.globalopt.Summary;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFGraph;
import org.apache.sysml.hops.globalopt.gdfgraph.GraphBuilder;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysml.utils.Explain;

public class GlobalOptimizerWrapper {
    private static final Log LOG = LogFactory.getLog(GlobalOptimizerWrapper.class);
    private static final boolean LDEBUG = true;
    private static final GlobalOptimizerType OPTIM = GlobalOptimizerType.ENUMERATE_DP;

    public static Program optimizeProgram(DMLProgram prog, Program rtprog) throws DMLRuntimeException, HopsException, LopsException {
        LOG.debug("Starting global data flow optimization.");
        Timing time = new Timing(true);
        GlobalOptimizer optimizer = GlobalOptimizerWrapper.createGlobalOptimizer(OPTIM);
        Summary summary = new Summary();
        GDFGraph graph = GraphBuilder.constructGlobalDataFlowGraph(rtprog, summary);
        if (LOG.isDebugEnabled()) {
            LOG.debug("EXPLAIN GDFGraph:\n" + Explain.explainGDFNodes(graph.getGraphRootNodes(), 1));
        }
        graph = optimizer.optimize(graph, summary);
        rtprog = graph.getRuntimeProgram();
        LOG.info(summary);
        LOG.debug("Finished global data flow optimization in " + time.stop() + " ms.");
        return rtprog;
    }

    private static GlobalOptimizer createGlobalOptimizer(GlobalOptimizerType type) throws HopsException, DMLRuntimeException {
        GDFEnumOptimizer optimizer = null;
        switch (type) {
            case ENUMERATE_DP: {
                optimizer = new GDFEnumOptimizer();
                break;
            }
            default: {
                throw new HopsException("Unsupported global optimizer type: " + (Object)((Object)type) + ".");
            }
        }
        return optimizer;
    }

    static {
        Logger.getLogger("org.apache.sysml.hops.globalopt").setLevel(Level.DEBUG);
    }

    public static enum GlobalOptimizerType {
        ENUMERATE_DP,
        TRANSFORM;

    }
}

