/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.template;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.hops.codegen.cplan.CNodeBinary;
import org.apache.sysml.hops.codegen.cplan.CNodeData;
import org.apache.sysml.hops.codegen.cplan.CNodeNary;
import org.apache.sysml.hops.codegen.cplan.CNodeRow;
import org.apache.sysml.hops.codegen.cplan.CNodeTernary;
import org.apache.sysml.hops.codegen.cplan.CNodeTpl;
import org.apache.sysml.hops.codegen.cplan.CNodeUnary;
import org.apache.sysml.hops.codegen.template.CPlanMemoTable;
import org.apache.sysml.hops.codegen.template.TemplateBase;
import org.apache.sysml.hops.codegen.template.TemplateCell;
import org.apache.sysml.hops.codegen.template.TemplateUtils;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.codegen.SpoofRowwise;
import org.apache.sysml.runtime.matrix.data.LibMatrixMult;
import org.apache.sysml.runtime.matrix.data.Pair;

public class TemplateRow
extends TemplateBase {
    private static final Hop.AggOp[] SUPPORTED_ROW_AGG = new Hop.AggOp[]{Hop.AggOp.SUM, Hop.AggOp.MIN, Hop.AggOp.MAX};
    private static final Hop.OpOp1[] SUPPORTED_VECT_UNARY = new Hop.OpOp1[]{Hop.OpOp1.EXP, Hop.OpOp1.SQRT, Hop.OpOp1.LOG, Hop.OpOp1.ABS, Hop.OpOp1.ROUND, Hop.OpOp1.CEIL, Hop.OpOp1.FLOOR, Hop.OpOp1.SIGN, Hop.OpOp1.SIN, Hop.OpOp1.COS, Hop.OpOp1.TAN, Hop.OpOp1.ASIN, Hop.OpOp1.ACOS, Hop.OpOp1.ATAN, Hop.OpOp1.SINH, Hop.OpOp1.COSH, Hop.OpOp1.TANH, Hop.OpOp1.CUMSUM, Hop.OpOp1.CUMMIN, Hop.OpOp1.CUMMAX, Hop.OpOp1.SPROP, Hop.OpOp1.SIGMOID};
    private static final Hop.OpOp2[] SUPPORTED_VECT_BINARY = new Hop.OpOp2[]{Hop.OpOp2.MULT, Hop.OpOp2.DIV, Hop.OpOp2.MINUS, Hop.OpOp2.PLUS, Hop.OpOp2.POW, Hop.OpOp2.MIN, Hop.OpOp2.MAX, Hop.OpOp2.XOR, Hop.OpOp2.EQUAL, Hop.OpOp2.NOTEQUAL, Hop.OpOp2.LESS, Hop.OpOp2.LESSEQUAL, Hop.OpOp2.GREATER, Hop.OpOp2.GREATEREQUAL, Hop.OpOp2.BITWAND};

    public TemplateRow() {
        super(TemplateBase.TemplateType.ROW);
    }

    public TemplateRow(TemplateBase.CloseType ctype) {
        super(TemplateBase.TemplateType.ROW, ctype);
    }

    @Override
    public boolean open(Hop hop) {
        return hop instanceof BinaryOp && hop.dimsKnown() && TemplateRow.isValidBinaryOperation(hop) && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L || (hop instanceof UnaryOp || hop instanceof ParameterizedBuiltinOp) && TemplateCell.isValidOperation(hop) && hop.getDim1() > 1L || HopRewriteUtils.isBinary(hop, Hop.OpOp2.CBIND) && hop.getInput().get(0).isMatrix() && hop.dimsKnown() || HopRewriteUtils.isNary(hop, Hop.OpOpN.CBIND) && hop.getInput().get(0).isMatrix() && hop.dimsKnown() || hop instanceof AggBinaryOp && hop.dimsKnown() && hop.getDim2() == 1L && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L || hop instanceof AggBinaryOp && hop.dimsKnown() && LibMatrixMult.isSkinnyRightHandSide(hop.getInput().get(0).getDim1(), hop.getInput().get(0).getDim2(), hop.getInput().get(1).getDim1(), hop.getInput().get(1).getDim2(), false) && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L && !HopRewriteUtils.isOuterProductLikeMM(hop) || HopRewriteUtils.isTransposeOperation(hop) && hop.getParent().size() == 1 && hop.getParent().get(0) instanceof AggBinaryOp && hop.getParent().get(0).dimsKnown() && hop.getParent().get(0).getInput().indexOf(hop) == 0 && TemplateRow.isFuseSkinnyMatrixMult(hop.getParent().get(0)) || hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getDirection() != Hop.Direction.RowCol && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L && HopRewriteUtils.isAggUnaryOp(hop, SUPPORTED_ROW_AGG) || hop instanceof IndexingOp && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() >= 0L && HopRewriteUtils.isColumnRangeIndexing((IndexingOp)hop);
    }

    @Override
    public boolean fuse(Hop hop, Hop input) {
        return !this.isClosed() && (hop instanceof BinaryOp && TemplateRow.isValidBinaryOperation(hop) || HopRewriteUtils.isBinary(hop, Hop.OpOp2.CBIND) && hop.getInput().get(0).isMatrix() && hop.dimsKnown() || HopRewriteUtils.isNary(hop, Hop.OpOpN.CBIND) && hop.getInput().get(0).isMatrix() && hop.dimsKnown() || (hop instanceof UnaryOp || hop instanceof ParameterizedBuiltinOp) && TemplateCell.isValidOperation(hop) || hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getDirection() != Hop.Direction.RowCol && HopRewriteUtils.isAggUnaryOp(hop, SUPPORTED_ROW_AGG) || hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getDirection() == Hop.Direction.RowCol && ((AggUnaryOp)hop).getOp() == Hop.AggOp.SUM || hop instanceof AggBinaryOp && hop.getDim1() > 1L && hop.getDim2() == 1L && HopRewriteUtils.isTransposeOperation(hop.getInput().get(0)) || hop instanceof AggBinaryOp && hop.dimsKnown() && TemplateRow.isFuseSkinnyMatrixMult(hop) && HopRewriteUtils.isTransposeOperation(hop.getInput().get(0)) && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L || TemplateRow.isPartOfValidCumAggChain(hop) || TemplateRow.isPartOfValidTransposeMMChain(hop));
    }

    @Override
    public boolean merge(Hop hop, Hop input) {
        return !this.isClosed() && (hop instanceof BinaryOp && TemplateRow.isValidBinaryOperation(hop) && hop.getDim1() > 1L && input.getDim1() > 1L || HopRewriteUtils.isBinary(hop, Hop.OpOp2.CBIND) && hop.getInput().get(0).isMatrix() && hop.dimsKnown() || HopRewriteUtils.isNary(hop, Hop.OpOpN.CBIND) && hop.getInput().get(0).isMatrix() && hop.dimsKnown() || hop instanceof AggBinaryOp && HopRewriteUtils.isTransposeOperation(hop.getInput().get(0)) && (input.getDim2() == 1L || input == hop.getInput().get(1) && HopRewriteUtils.containsInput(input, hop.getInput().get(0).getInput().get(0))));
    }

    @Override
    public TemplateBase.CloseType close(Hop hop) {
        if (hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getDirection() != Hop.Direction.Row || hop instanceof AggBinaryOp && HopRewriteUtils.isTransposeOperation(hop.getInput().get(0))) {
            return TemplateBase.CloseType.CLOSED_VALID;
        }
        if (HopRewriteUtils.isTransposeOperation(hop)) {
            return TemplateBase.CloseType.OPEN_INVALID;
        }
        return TemplateBase.CloseType.OPEN_VALID;
    }

    private static boolean isValidBinaryOperation(Hop hop) {
        return TemplateUtils.isOperationSupported(hop);
    }

    private static boolean isFuseSkinnyMatrixMult(Hop hop) {
        Hop in1 = hop.getInput().get(0);
        Hop in2 = hop.getInput().get(1);
        return LibMatrixMult.isSkinnyRightHandSide(in1.getDim2(), in1.getDim1(), hop.getDim1(), hop.getDim2(), false) || LibMatrixMult.isSkinnyRightHandSide(in2.getDim1(), in2.getDim2(), hop.getDim2(), hop.getDim1(), false);
    }

    private static boolean isPartOfValidCumAggChain(Hop hop) {
        if (HopRewriteUtils.isTransposeOperation(hop)) {
            return HopRewriteUtils.isUnary(hop.getInput().get(0), Hop.OpOp1.CUMSUM, Hop.OpOp1.CUMMIN, Hop.OpOp1.CUMMAX) && hop.getParent().size() == 1 && HopRewriteUtils.isTransposeOperation(hop.getInput().get(0).getInput().get(0)) && hop.getInput().get(0).getInput().get(0).getParent().size() == 1 || HopRewriteUtils.isUnary(hop.getParent().get(0), Hop.OpOp1.CUMSUM, Hop.OpOp1.CUMMIN, Hop.OpOp1.CUMMAX) && hop.getParent().size() == 1 && HopRewriteUtils.isTransposeOperation(hop.getParent().get(0).getParent().get(0)) && hop.getParent().get(0).getParent().size() == 1;
        }
        return HopRewriteUtils.isUnary(hop, Hop.OpOp1.CUMSUM, Hop.OpOp1.CUMMIN, Hop.OpOp1.CUMMAX) && hop.getParent().size() == 1 && HopRewriteUtils.isTransposeOperation(hop.getParent().get(0)) && HopRewriteUtils.isTransposeOperation(hop.getInput().get(0)) && hop.getInput().get(0).getParent().size() == 1;
    }

    private static boolean isPartOfValidTransposeMMChain(Hop hop) {
        return HopRewriteUtils.isTransposeOperation(hop) && hop.getParent().size() == 1 && hop.dimsKnown() && hop.getParent().get(0).dimsKnown() && hop.getDim2() > 128L * hop.getParent().get(0).getDim1() && hop.getDim2() > 128L * hop.getParent().get(0).getDim2() && HopRewriteUtils.isMatrixMultiply(hop.getParent().get(0)) && TemplateRow.isFuseSkinnyMatrixMult(hop.getParent().get(0)) && (hop.getParent().get(0).getInput().get(0) == hop && HopRewriteUtils.containsInput(hop, hop.getParent().get(0).getInput().get(1)) || hop.getParent().get(0).getInput().get(1) == hop && HopRewriteUtils.containsInput(hop, hop.getParent().get(0).getInput().get(0)));
    }

    @Override
    public Pair<Hop[], CNodeTpl> constructCplan(Hop hop, CPlanMemoTable memo, boolean compileLiterals) {
        long n2;
        HashSet<Hop> inHops = new HashSet<Hop>();
        HashMap<String, Hop> inHops2 = new HashMap<String, Hop>();
        HashMap<Long, CNode> tmp = new HashMap<Long, CNode>();
        hop.resetVisitStatus();
        this.rConstructCplan(hop, memo, tmp, inHops, inHops2, compileLiterals);
        hop.resetVisitStatus();
        Hop[] sinHops = (Hop[])inHops.stream().filter(h -> !h.getDataType().isScalar() || !((CNode)tmp.get(h.getHopID())).isLiteral()).sorted(new HopInputComparator(inHops2.get("X"), inHops2.get("B1"))).toArray(Hop[]::new);
        inHops2.putIfAbsent("X", sinHops[0]);
        ArrayList<CNode> inputs = new ArrayList<CNode>();
        for (Hop in : sinHops) {
            inputs.add(tmp.get(in.getHopID()));
        }
        CNode output = tmp.get(hop.getHopID());
        CNodeRow tpl = new CNodeRow(inputs, output);
        tpl.setRowType(TemplateUtils.getRowType(hop, inHops2.get("X"), inHops2.get("B1")));
        long l = n2 = tpl.getRowType() == SpoofRowwise.RowType.COL_AGG_B1 ? hop.getDim1() : hop.getDim2();
        if (tpl.getRowType().isConstDim2(n2)) {
            tpl.setConstDim2(n2);
        }
        tpl.setNumVectorIntermediates(TemplateUtils.determineMinVectorIntermediates(output));
        tpl.getOutput().resetVisitStatus();
        tpl.rReorderCommutativeBinaryOps(tpl.getOutput(), sinHops[0].getHopID());
        tpl.setBeginLine(hop.getBeginLine());
        return new Pair<Hop[], CNodeTpl>(sinHops, tpl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rConstructCplan(Hop hop, CPlanMemoTable memo, HashMap<Long, CNode> tmp, HashSet<Hop> inHops, HashMap<String, Hop> inHops2, boolean compileLiterals) {
        CNode cdata2;
        CNode cdata1;
        if (tmp.containsKey(hop.getHopID())) {
            return;
        }
        CPlanMemoTable.MemoTableEntry me = memo.getBest(hop.getHopID(), TemplateBase.TemplateType.ROW, TemplateBase.TemplateType.CELL);
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop c = hop.getInput().get(i);
            if (me != null && me.isPlanRef(i)) {
                this.rConstructCplan(c, memo, tmp, inHops, inHops2, compileLiterals);
                continue;
            }
            CNodeData cdata = TemplateUtils.createCNodeData(c, compileLiterals);
            tmp.put(c.getHopID(), cdata);
            inHops.add(c);
        }
        CNode out = null;
        if (hop instanceof AggUnaryOp) {
            cdata1 = tmp.get(hop.getInput().get(0).getHopID());
            if (((AggUnaryOp)hop).getDirection() == Hop.Direction.Row && HopRewriteUtils.isAggUnaryOp(hop, SUPPORTED_ROW_AGG)) {
                if (hop.getInput().get(0).getDim2() == 1L) {
                    out = cdata1.getDataType() == Expression.DataType.SCALAR ? cdata1 : new CNodeUnary(cdata1, CNodeUnary.UnaryType.LOOKUP_R);
                } else {
                    String opcode = "ROW_" + ((AggUnaryOp)hop).getOp().name().toUpperCase() + "S";
                    out = new CNodeUnary(cdata1, CNodeUnary.UnaryType.valueOf(opcode));
                    if (cdata1 instanceof CNodeData && !inHops2.containsKey("X")) {
                        inHops2.put("X", hop.getInput().get(0));
                    }
                }
            } else if (((AggUnaryOp)hop).getDirection() == Hop.Direction.Col && ((AggUnaryOp)hop).getOp() == Hop.AggOp.SUM) {
                out = cdata1 instanceof CNodeBinary && ((CNodeBinary)cdata1).getType().isVectorScalarPrimitive() ? new CNodeBinary(cdata1.getInput().get(0), cdata1.getInput().get(1), ((CNodeBinary)cdata1).getType().getVectorAddPrimitive()) : cdata1;
            } else if (((AggUnaryOp)hop).getDirection() == Hop.Direction.RowCol && ((AggUnaryOp)hop).getOp() == Hop.AggOp.SUM) {
                out = cdata1.getDataType().isMatrix() ? new CNodeUnary(cdata1, CNodeUnary.UnaryType.ROW_SUMS) : cdata1;
            }
        } else if (hop instanceof AggBinaryOp) {
            cdata1 = tmp.get(hop.getInput().get(0).getHopID());
            cdata2 = tmp.get(hop.getInput().get(1).getHopID());
            if (HopRewriteUtils.isTransposeOperation(hop.getInput().get(0))) {
                cdata1 = TemplateUtils.skipTranspose(cdata1, hop.getInput().get(0), tmp, compileLiterals);
                inHops.remove(hop.getInput().get(0));
                if (cdata1 instanceof CNodeData) {
                    inHops.add(hop.getInput().get(0).getInput().get(0));
                }
                if (hop.getInput().get(1).getDim2() == 1L) {
                    out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.VECT_MULT_ADD);
                } else {
                    out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.VECT_OUTERMULT_ADD);
                    if (!inHops2.containsKey("B1")) {
                        if (cdata1 instanceof CNodeData) {
                            inHops2.put("X", hop.getInput().get(0).getInput().get(0));
                        }
                        inHops2.put("B1", hop.getInput().get(1));
                    }
                }
                if (!inHops2.containsKey("X")) {
                    inHops2.put("X", hop.getInput().get(0).getInput().get(0));
                }
            } else if (hop.getInput().get(0).getDim2() == 1L && hop.getInput().get(1).getDim2() == 1L) {
                out = new CNodeBinary(cdata1.getDataType() == Expression.DataType.SCALAR ? cdata1 : new CNodeUnary(cdata1, CNodeUnary.UnaryType.LOOKUP0), cdata2.getDataType() == Expression.DataType.SCALAR ? cdata2 : new CNodeUnary(cdata2, CNodeUnary.UnaryType.LOOKUP0), CNodeBinary.BinType.MULT);
            } else if (hop.getInput().get(1).getDim2() == 1L) {
                out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.DOT_PRODUCT);
                inHops2.put("X", hop.getInput().get(0));
            } else {
                out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.VECT_MATRIXMULT);
                inHops2.put("X", hop.getInput().get(0));
                inHops2.put("B1", hop.getInput().get(1));
            }
        } else if (HopRewriteUtils.isTransposeOperation(hop)) {
            out = TemplateUtils.skipTranspose(tmp.get(hop.getHopID()), hop, tmp, compileLiterals);
            if (out instanceof CNodeData && !inHops.contains(hop.getInput().get(0))) {
                inHops.add(hop.getInput().get(0));
            }
        } else if (hop instanceof UnaryOp) {
            cdata1 = tmp.get(hop.getInput().get(0).getHopID());
            if (hop.getInput().get(0).getDim1() >= 1L && hop.getInput().get(0).getDim2() > 1L || !hop.dimsKnown() && cdata1.getDataType() == Expression.DataType.MATRIX) {
                if (!HopRewriteUtils.isUnary(hop, SUPPORTED_VECT_UNARY)) throw new RuntimeException("Unsupported unary matrix operation: " + ((UnaryOp)hop).getOp().name());
                String opname = "VECT_" + ((UnaryOp)hop).getOp().name();
                out = new CNodeUnary(cdata1, CNodeUnary.UnaryType.valueOf(opname));
                if (cdata1 instanceof CNodeData && !inHops2.containsKey("X")) {
                    inHops2.put("X", hop.getInput().get(0));
                }
            } else {
                cdata1 = TemplateUtils.wrapLookupIfNecessary(cdata1, hop.getInput().get(0));
                String primitiveOpName = ((UnaryOp)hop).getOp().toString();
                out = new CNodeUnary(cdata1, CNodeUnary.UnaryType.valueOf(primitiveOpName));
            }
        } else if (HopRewriteUtils.isBinary(hop, Hop.OpOp2.CBIND)) {
            cdata1 = tmp.get(hop.getInput().get(0).getHopID());
            cdata2 = null;
            if (HopRewriteUtils.isDataGenOpWithConstantValue(hop.getInput().get(1))) {
                cdata2 = TemplateUtils.createCNodeData(HopRewriteUtils.getDataGenOpConstantValue(hop.getInput().get(1)), true);
                inHops.remove(hop.getInput().get(1));
            } else {
                cdata2 = tmp.get(hop.getInput().get(1).getHopID());
                cdata2 = TemplateUtils.wrapLookupIfNecessary(cdata2, hop.getInput().get(1));
            }
            out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.VECT_CBIND);
            if (cdata1 instanceof CNodeData && !inHops2.containsKey("X")) {
                inHops2.put("X", hop.getInput().get(0));
            }
        } else if (hop instanceof BinaryOp) {
            cdata1 = tmp.get(hop.getInput().get(0).getHopID());
            cdata2 = tmp.get(hop.getInput().get(1).getHopID());
            if (hop.getInput().get(0).getDim1() >= 1L && hop.getInput().get(0).getDim2() > 1L || hop.getInput().get(1).getDim1() >= 1L && hop.getInput().get(1).getDim2() > 1L || (!hop.dimsKnown() || !hop.getInput().get(0).dimsKnown() || !hop.getInput().get(1).dimsKnown()) && hop.getDim2() != 1L && (cdata1.getDataType().isMatrix() || cdata2.getDataType().isMatrix())) {
                if (!HopRewriteUtils.isBinary(hop, SUPPORTED_VECT_BINARY)) throw new RuntimeException("Unsupported binary matrix operation: " + ((BinaryOp)hop).getOp().name());
                if (TemplateUtils.isMatrix(cdata1) && (TemplateUtils.isMatrix(cdata2) || TemplateUtils.isRowVector(cdata2))) {
                    String opname = "VECT_" + ((BinaryOp)hop).getOp().name();
                    out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.valueOf(opname));
                } else {
                    String opname = "VECT_" + ((BinaryOp)hop).getOp().name() + "_SCALAR";
                    if (TemplateUtils.isColVector(cdata1)) {
                        cdata1 = new CNodeUnary(cdata1, CNodeUnary.UnaryType.LOOKUP_R);
                    }
                    if (TemplateUtils.isColVector(cdata2)) {
                        cdata2 = new CNodeUnary(cdata2, CNodeUnary.UnaryType.LOOKUP_R);
                    }
                    out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.valueOf(opname));
                }
                if (cdata1 instanceof CNodeData && !inHops2.containsKey("X") && cdata1.getDataType() != Expression.DataType.SCALAR) {
                    inHops2.put("X", hop.getInput().get(0));
                }
            } else {
                String primitiveOpName = ((BinaryOp)hop).getOp().toString();
                if (TemplateUtils.isColVector(cdata1)) {
                    cdata1 = new CNodeUnary(cdata1, CNodeUnary.UnaryType.LOOKUP_R);
                }
                if (TemplateUtils.isColVector(cdata2) || TemplateUtils.isColVector(hop.getInput().get(0)) && cdata2 instanceof CNodeData && hop.getInput().get(1).getDataType().isMatrix()) {
                    cdata2 = new CNodeUnary(cdata2, CNodeUnary.UnaryType.LOOKUP_R);
                }
                out = new CNodeBinary(cdata1, cdata2, CNodeBinary.BinType.valueOf(primitiveOpName));
            }
        } else if (hop instanceof TernaryOp) {
            TernaryOp top = (TernaryOp)hop;
            CNode cdata12 = tmp.get(hop.getInput().get(0).getHopID());
            CNode cdata22 = tmp.get(hop.getInput().get(1).getHopID());
            CNode cdata3 = tmp.get(hop.getInput().get(2).getHopID());
            cdata12 = TemplateUtils.wrapLookupIfNecessary(cdata12, hop.getInput().get(0));
            cdata3 = TemplateUtils.wrapLookupIfNecessary(cdata3, hop.getInput().get(2));
            out = new CNodeTernary(cdata12, cdata22, cdata3, CNodeTernary.TernaryType.valueOf(top.getOp().toString()));
        } else if (HopRewriteUtils.isNary(hop, Hop.OpOpN.CBIND)) {
            CNode[] inputs = new CNode[hop.getInput().size()];
            for (int i = 0; i < hop.getInput().size(); ++i) {
                Hop c = hop.getInput().get(i);
                CNode cdata = tmp.get(c.getHopID());
                if (TemplateUtils.isColVector(cdata) || TemplateUtils.isRowVector(cdata)) {
                    cdata = TemplateUtils.wrapLookupIfNecessary(cdata, c);
                }
                inputs[i] = cdata;
                if (i != 0 || !(cdata instanceof CNodeData) || inHops2.containsKey("X")) continue;
                inHops2.put("X", c);
            }
            out = new CNodeNary(inputs, CNodeNary.NaryType.VECT_CBIND);
        } else if (hop instanceof ParameterizedBuiltinOp) {
            cdata1 = tmp.get(((ParameterizedBuiltinOp)hop).getTargetHop().getHopID());
            cdata1 = TemplateUtils.wrapLookupIfNecessary(cdata1, hop.getInput().get(0));
            cdata2 = tmp.get(((ParameterizedBuiltinOp)hop).getParameterHop("pattern").getHopID());
            CNode cdata3 = tmp.get(((ParameterizedBuiltinOp)hop).getParameterHop("replacement").getHopID());
            CNodeTernary.TernaryType ttype = cdata2.isLiteral() && cdata2.getVarname().equals("Double.NaN") ? CNodeTernary.TernaryType.REPLACE_NAN : CNodeTernary.TernaryType.REPLACE;
            out = new CNodeTernary(cdata1, cdata2, cdata3, ttype);
        } else if (hop instanceof IndexingOp) {
            cdata1 = tmp.get(hop.getInput().get(0).getHopID());
            out = new CNodeTernary(cdata1, TemplateUtils.createCNodeData(new LiteralOp(hop.getInput().get(0).getDim2()), true), TemplateUtils.createCNodeData(hop.getInput().get(4), true), hop.getDim2() != 1L ? CNodeTernary.TernaryType.LOOKUP_RVECT1 : CNodeTernary.TernaryType.LOOKUP_RC1);
        }
        if (out == null) {
            throw new RuntimeException(hop.getHopID() + " " + hop.getOpString());
        }
        if (out.getDataType().isMatrix()) {
            out.setNumRows(hop.getDim1());
            out.setNumCols(hop.getDim2());
        }
        tmp.put(hop.getHopID(), out);
    }

    public static class HopInputComparator
    implements Comparator<Hop> {
        private final Hop _X;
        private final Hop _B1;

        public HopInputComparator(Hop X, Hop B1) {
            this._X = X;
            this._B1 = B1;
        }

        @Override
        public int compare(Hop h1, Hop h2) {
            long ncells2;
            long ncells1;
            long l = h1.isScalar() ? Long.MIN_VALUE : (h1 == this._X ? Long.MAX_VALUE : (h1 == this._B1 ? 0x7FFFFFFFFFFFFFFEL : (ncells1 = h1.dimsKnown() ? h1.getLength() : 0x7FFFFFFFFFFFFFFDL)));
            long l2 = h2.isScalar() ? Long.MIN_VALUE : (h2 == this._X ? Long.MAX_VALUE : (h2 == this._B1 ? 0x7FFFFFFFFFFFFFFEL : (ncells2 = h2.dimsKnown() ? h2.getLength() : 0x7FFFFFFFFFFFFFFDL)));
            return ncells1 > ncells2 ? -1 : (ncells1 < ncells2 ? 1 : 0);
        }
    }
}

