/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.ScriptExecutorUtils;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.debug.DMLDebugger;
import org.apache.sysml.debug.DMLDebuggerException;
import org.apache.sysml.debug.DMLDebuggerProgramInfo;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.globalopt.GlobalOptimizerWrapper;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DMLTranslator;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParserFactory;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CleanupMR;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.Statistics;
import org.apache.sysml.yarn.DMLAppMasterUtils;
import org.apache.sysml.yarn.DMLYarnClientProxy;

public class DMLScript {
    public static RUNTIME_PLATFORM rtplatform = DMLOptions.defaultOptions.execMode;
    public static boolean STATISTICS = DMLOptions.defaultOptions.stats;
    public static boolean FINEGRAINED_STATISTICS = false;
    public static int STATISTICS_COUNT = DMLOptions.defaultOptions.statsCount;
    public static int STATISTICS_MAX_WRAP_LEN = 30;
    public static boolean ENABLE_DEBUG_MODE = DMLOptions.defaultOptions.debug;
    public static Explain.ExplainType EXPLAIN = DMLOptions.defaultOptions.explainType;
    public static String DML_FILE_PATH_ANTLR_PARSER = DMLOptions.defaultOptions.filePath;
    public static String FLOATING_POINT_PRECISION = "double";
    public static EvictionPolicy GPU_EVICTION_POLICY = EvictionPolicy.LRU;
    public static ScriptType SCRIPT_TYPE = DMLOptions.defaultOptions.scriptType;
    public static boolean USE_ACCELERATOR = DMLOptions.defaultOptions.gpu;
    public static boolean FORCE_ACCELERATOR = DMLOptions.defaultOptions.forceGPU;
    public static boolean SYNCHRONIZE_GPU = true;
    public static boolean EAGER_CUDA_FREE = false;
    public static boolean _suppressPrint2Stdout = false;
    public static boolean USE_LOCAL_SPARK_CONFIG = false;
    public static boolean _activeAM = false;
    public static boolean VALIDATOR_IGNORE_ISSUES = false;
    public static String _uuid = IDHandler.createDistributedUniqueID();
    private static final Log LOG = LogFactory.getLog(DMLScript.class.getName());

    public static String getUUID() {
        return _uuid;
    }

    public static void setUUID(String uuid) {
        _uuid = uuid;
    }

    public static boolean suppressPrint2Stdout() {
        return _suppressPrint2Stdout;
    }

    public static void setActiveAM() {
        _activeAM = true;
    }

    public static boolean isActiveAM() {
        return _activeAM;
    }

    public static void main(String[] args) throws IOException, DMLException {
        Configuration conf = new Configuration(ConfigurationManager.getCachedJobConf());
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        try {
            DMLScript.executeScript(conf, otherArgs);
        }
        catch (org.apache.sysml.parser.ParseException pe) {
            System.err.println(pe.getMessage());
        }
        catch (DMLScriptException e) {
            System.err.println(e.getMessage());
        }
    }

    public static DMLOptions parseCLArguments(String[] args, Options options) throws ParseException {
        String statsCount;
        String execMode;
        String force;
        PosixParser clParser = new PosixParser();
        CommandLine line = clParser.parse(options, args);
        DMLOptions dmlOptions = new DMLOptions();
        dmlOptions.help = line.hasOption("help");
        dmlOptions.scriptType = line.hasOption("python") ? ScriptType.PYDML : ScriptType.DML;
        dmlOptions.debug = line.hasOption("debug");
        dmlOptions.gpu = line.hasOption("gpu");
        if (dmlOptions.gpu && (force = line.getOptionValue("gpu")) != null) {
            if (force.equalsIgnoreCase("force")) {
                dmlOptions.forceGPU = true;
            } else {
                throw new ParseException("Invalid argument specified for -gpu option");
            }
        }
        if (line.hasOption("exec") && (execMode = line.getOptionValue("exec")) != null) {
            if (execMode.equalsIgnoreCase("hadoop")) {
                dmlOptions.execMode = RUNTIME_PLATFORM.HADOOP;
            } else if (execMode.equalsIgnoreCase("singlenode")) {
                dmlOptions.execMode = RUNTIME_PLATFORM.SINGLE_NODE;
            } else if (execMode.equalsIgnoreCase("hybrid")) {
                dmlOptions.execMode = RUNTIME_PLATFORM.HYBRID;
            } else if (execMode.equalsIgnoreCase("hybrid_spark")) {
                dmlOptions.execMode = RUNTIME_PLATFORM.HYBRID_SPARK;
            } else if (execMode.equalsIgnoreCase("spark")) {
                dmlOptions.execMode = RUNTIME_PLATFORM.SPARK;
            } else {
                throw new ParseException("Invalid argument specified for -exec option, must be one of [hadoop, singlenode, hybrid, hybrid_spark, spark]");
            }
        }
        if (line.hasOption("explain")) {
            dmlOptions.explainType = Explain.ExplainType.RUNTIME;
            String explainType = line.getOptionValue("explain");
            if (explainType != null) {
                if (explainType.equalsIgnoreCase("hops")) {
                    dmlOptions.explainType = Explain.ExplainType.HOPS;
                } else if (explainType.equalsIgnoreCase("runtime")) {
                    dmlOptions.explainType = Explain.ExplainType.RUNTIME;
                } else if (explainType.equalsIgnoreCase("recompile_hops")) {
                    dmlOptions.explainType = Explain.ExplainType.RECOMPILE_HOPS;
                } else if (explainType.equalsIgnoreCase("recompile_runtime")) {
                    dmlOptions.explainType = Explain.ExplainType.RECOMPILE_RUNTIME;
                } else {
                    throw new ParseException("Invalid argument specified for -hops option, must be one of [hops, runtime, recompile_hops, recompile_runtime]");
                }
            }
        }
        dmlOptions.stats = line.hasOption("stats");
        if (dmlOptions.stats && (statsCount = line.getOptionValue("stats")) != null) {
            try {
                dmlOptions.statsCount = Integer.parseInt(statsCount);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid argument specified for -stats option, must be a valid integer");
            }
        }
        dmlOptions.clean = line.hasOption("clean");
        if (line.hasOption("config")) {
            dmlOptions.configFile = line.getOptionValue("config");
        }
        if (line.hasOption("f")) {
            dmlOptions.filePath = line.getOptionValue("f");
        }
        if (line.hasOption("s")) {
            dmlOptions.script = line.getOptionValue("s");
        }
        if (line.hasOption("args")) {
            String[] argValues = line.getOptionValues("args");
            for (int k = 0; k < argValues.length; ++k) {
                String str = argValues[k];
                if (str.isEmpty()) continue;
                dmlOptions.argVals.put("$" + (k + 1), str);
            }
        }
        if (line.hasOption("nvargs")) {
            String[] nvargValues;
            String varNameRegex = "^[a-zA-Z]([a-zA-Z0-9_])*$";
            for (String str : nvargValues = line.getOptionValues("nvargs")) {
                if (str.isEmpty()) continue;
                String[] kv = str.split("=");
                if (kv.length != 2) {
                    throw new ParseException("Invalid argument specified for -nvargs option, must be a list of space separated K=V pairs, where K is a valid name of a variable in the DML/PyDML program");
                }
                if (!kv[0].matches(varNameRegex)) {
                    throw new ParseException("Invalid argument specified for -nvargs option, " + kv[0] + " does not seem like a valid variable name in DML. Valid variable names in DML start with upper-case or lower-case letter, and contain only letters, digits, or underscores");
                }
                dmlOptions.argVals.put("$" + kv[0], kv[1]);
            }
        }
        return dmlOptions;
    }

    public static Options createCLIOptions() {
        Options options = new Options();
        OptionBuilder.withArgName("key=value");
        OptionBuilder.withDescription("parameterizes DML script with named parameters of the form <key=value>; <key> should be a valid identifier in DML/PyDML");
        OptionBuilder.hasArgs();
        Option nvargsOpt = OptionBuilder.create("nvargs");
        OptionBuilder.withArgName("argN");
        OptionBuilder.withDescription("specifies positional parameters; first value will replace $1 in DML program; $2 will replace 2nd and so on");
        OptionBuilder.hasArgs();
        Option argsOpt = OptionBuilder.create("args");
        OptionBuilder.withArgName("filename");
        OptionBuilder.withDescription("uses a given configuration file (can be on local/hdfs/gpfs; default values in SystemML-config.xml");
        OptionBuilder.hasArg();
        Option configOpt = OptionBuilder.create("config");
        OptionBuilder.withDescription("cleans up all SystemML working directories (FS, DFS); all other flags are ignored in this mode. \n");
        Option cleanOpt = OptionBuilder.create("clean");
        OptionBuilder.withArgName("count");
        OptionBuilder.withDescription("monitors and reports caching/recompilation statistics; heavy hitter <count> is 10 unless overridden; default off");
        OptionBuilder.hasOptionalArg();
        Option statsOpt = OptionBuilder.create("stats");
        OptionBuilder.withArgName("level");
        OptionBuilder.withDescription("explains plan levels; can be 'hops' / 'runtime'[default] / 'recompile_hops' / 'recompile_runtime'");
        OptionBuilder.hasOptionalArg();
        Option explainOpt = OptionBuilder.create("explain");
        OptionBuilder.withArgName("mode");
        OptionBuilder.withDescription("sets execution mode; can be 'hadoop' / 'singlenode' / 'hybrid'[default] / 'hybrid_spark' / 'spark'");
        OptionBuilder.hasArg();
        Option execOpt = OptionBuilder.create("exec");
        OptionBuilder.withArgName("force");
        OptionBuilder.withDescription("uses CUDA instructions when reasonable; set <force> option to skip conservative memory estimates and use GPU wherever possible; default off");
        OptionBuilder.hasOptionalArg();
        Option gpuOpt = OptionBuilder.create("gpu");
        OptionBuilder.withDescription("runs in debug mode; default off");
        Option debugOpt = OptionBuilder.create("debug");
        OptionBuilder.withDescription("parses Python-like DML");
        Option pythonOpt = OptionBuilder.create("python");
        OptionBuilder.withArgName("filename");
        OptionBuilder.withDescription("specifies dml/pydml file to execute; path can be local/hdfs/gpfs (prefixed with appropriate URI)");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        Option fileOpt = OptionBuilder.create("f");
        OptionBuilder.withArgName("script_contents");
        OptionBuilder.withDescription("specified script string to execute directly");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        Option scriptOpt = OptionBuilder.create("s");
        OptionBuilder.withDescription("shows usage message");
        Option helpOpt = OptionBuilder.create("help");
        OptionGroup fileOrScriptOpt = new OptionGroup();
        fileOrScriptOpt.addOption(scriptOpt);
        fileOrScriptOpt.addOption(fileOpt);
        fileOrScriptOpt.addOption(cleanOpt);
        fileOrScriptOpt.addOption(helpOpt);
        fileOrScriptOpt.setRequired(true);
        OptionGroup argsOrNVArgsOpt = new OptionGroup();
        argsOrNVArgsOpt.addOption(nvargsOpt).addOption(argsOpt);
        options.addOption(configOpt);
        options.addOption(cleanOpt);
        options.addOption(statsOpt);
        options.addOption(explainOpt);
        options.addOption(execOpt);
        options.addOption(gpuOpt);
        options.addOption(debugOpt);
        options.addOption(pythonOpt);
        options.addOptionGroup(fileOrScriptOpt);
        options.addOptionGroup(argsOrNVArgsOpt);
        options.addOption(helpOpt);
        return options;
    }

    public static boolean executeScript(Configuration conf, String[] args) throws DMLException {
        HelpFormatter formatter;
        RUNTIME_PLATFORM oldrtplatform = rtplatform;
        Explain.ExplainType oldexplain = EXPLAIN;
        Options options = DMLScript.createCLIOptions();
        try {
            DMLOptions dmlOptions = DMLScript.parseCLArguments(args, options);
            STATISTICS = dmlOptions.stats;
            STATISTICS_COUNT = dmlOptions.statsCount;
            USE_ACCELERATOR = dmlOptions.gpu;
            FORCE_ACCELERATOR = dmlOptions.forceGPU;
            EXPLAIN = dmlOptions.explainType;
            ENABLE_DEBUG_MODE = dmlOptions.debug;
            SCRIPT_TYPE = dmlOptions.scriptType;
            rtplatform = dmlOptions.execMode;
            String fnameOptConfig = dmlOptions.configFile;
            boolean isFile = dmlOptions.filePath != null;
            String fileOrScript = isFile ? dmlOptions.filePath : dmlOptions.script;
            boolean help = dmlOptions.help;
            if (help) {
                HelpFormatter formatter2 = new HelpFormatter();
                formatter2.printHelp("systemml", options);
                boolean bl = true;
                return bl;
            }
            if (dmlOptions.clean) {
                DMLScript.cleanSystemMLWorkspace();
                boolean formatter2 = true;
                return formatter2;
            }
            if (!ENABLE_DEBUG_MODE) {
                DMLScript.setLoggingProperties(conf);
            }
            if (isFile && StringUtils.endsWithIgnoreCase(fileOrScript, ".pydml")) {
                SCRIPT_TYPE = ScriptType.PYDML;
            }
            String dmlScriptStr = DMLScript.readDMLScript(isFile, fileOrScript);
            Map<String, String> argVals = dmlOptions.argVals;
            DML_FILE_PATH_ANTLR_PARSER = dmlOptions.filePath;
            DMLScript.printInvocationInfo(fileOrScript, fnameOptConfig, argVals);
            if (ENABLE_DEBUG_MODE) {
                DMLScript.launchDebugger(dmlScriptStr, fnameOptConfig, argVals, SCRIPT_TYPE);
            } else {
                DMLScript.execute(dmlScriptStr, fnameOptConfig, argVals, args, SCRIPT_TYPE);
            }
        }
        catch (AlreadySelectedException e) {
            System.err.println("Mutually exclusive options were selected. " + e.getMessage());
            formatter = new HelpFormatter();
            formatter.printHelp("systemml", options);
            boolean bl = false;
            return bl;
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            formatter = new HelpFormatter();
            formatter.printHelp("systemml", options);
        }
        catch (org.apache.sysml.parser.ParseException pe) {
            throw pe;
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.error("Failed to execute DML script.", ex);
            throw new DMLException(ex);
        }
        finally {
            rtplatform = oldrtplatform;
            EXPLAIN = oldexplain;
        }
        return true;
    }

    protected static String readDMLScript(boolean isFile, String scriptOrFilename) throws IOException, LanguageException {
        String dmlScriptStr;
        block11: {
            block9: {
                if (!isFile) break block9;
                String fileName = scriptOrFilename;
                if (fileName == null) {
                    throw new LanguageException("DML script path was not specified!");
                }
                StringBuilder sb = new StringBuilder();
                BufferedReader in = null;
                try {
                    if (fileName.startsWith("hdfs:") || fileName.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(fileName))) {
                        Path scriptPath = new Path(fileName);
                        FileSystem fs = IOUtilFunctions.getFileSystem(scriptPath);
                        in = new BufferedReader(new InputStreamReader(fs.open(scriptPath)));
                    } else {
                        in = new BufferedReader(new FileReader(fileName));
                    }
                    String tmp = null;
                    while ((tmp = in.readLine()) != null) {
                        sb.append(tmp);
                        sb.append("\n");
                    }
                }
                catch (IOException ex) {
                    try {
                        LOG.error("Failed to read the script from the file system", ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(in);
                        throw throwable;
                    }
                }
                IOUtilFunctions.closeSilently(in);
                dmlScriptStr = sb.toString();
                break block11;
            }
            String scriptString = scriptOrFilename;
            if (scriptString == null) {
                throw new LanguageException("DML script was not specified!");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(scriptString.getBytes());
            Scanner scan = new Scanner(is);
            dmlScriptStr = scan.useDelimiter("\\A").next();
            scan.close();
        }
        return dmlScriptStr;
    }

    private static void setLoggingProperties(Configuration conf) {
        String debug = conf.get("systemml.logging");
        if (debug == null) {
            debug = System.getProperty("systemml.logging");
        }
        if (debug != null) {
            if (debug.equalsIgnoreCase("debug")) {
                Logger.getLogger("org.apache.sysml").setLevel(Level.DEBUG);
            } else if (debug.equalsIgnoreCase("trace")) {
                Logger.getLogger("org.apache.sysml").setLevel(Level.TRACE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(String dmlScriptStr, String fnameOptConfig, Map<String, String> argVals, String[] allArgs, ScriptType scriptType) throws org.apache.sysml.parser.ParseException, IOException, DMLRuntimeException, LanguageException, HopsException, LopsException {
        SCRIPT_TYPE = scriptType;
        DMLScript.printStartExecInfo(dmlScriptStr);
        DMLConfig dmlconf = DMLConfig.readConfigurationFile(fnameOptConfig);
        ConfigurationManager.setGlobalConfig(dmlconf);
        CompilerConfig cconf = OptimizerUtils.constructCompilerConfig(dmlconf);
        ConfigurationManager.setGlobalConfig(cconf);
        LOG.debug("\nDML config: \n" + dmlconf.getConfigInfo());
        GPUContextPool.AVAILABLE_GPUS = dmlconf.getTextValue("sysml.gpu.availableGPUs");
        String evictionPolicy = dmlconf.getTextValue("sysml.gpu.eviction.policy").toUpperCase();
        try {
            GPU_EVICTION_POLICY = EvictionPolicy.valueOf(evictionPolicy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unsupported eviction policy:" + evictionPolicy);
        }
        if (dmlconf.getBooleanValue("sysml.yarn.appmaster")) {
            DMLAppMasterUtils.setupConfigRemoteMaxMemory(dmlconf);
        }
        Statistics.startCompileTimer();
        ParserWrapper parser = ParserFactory.createParser(scriptType);
        DMLProgram prog = parser.parse(DML_FILE_PATH_ANTLR_PARSER, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        DMLScript.initHadoopExecution(dmlconf);
        dmlt.rewriteHopsDAG(prog);
        dmlt.constructLops(prog);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\n********************** LOPS DAG *******************");
            dmlt.printLops(prog);
            dmlt.resetLopsDAGVisitStatus(prog);
        }
        Program rtprog = dmlt.getRuntimeProgram(prog, dmlconf);
        if (OptimizerUtils.isOptLevel(OptimizerUtils.OptimizationLevel.O4_GLOBAL_TIME_MEMORY)) {
            LOG.warn("Optimization level '" + (Object)((Object)OptimizerUtils.OptimizationLevel.O4_GLOBAL_TIME_MEMORY) + "' is still in experimental state and not intended for production use.");
            rtprog = GlobalOptimizerWrapper.optimizeProgram(prog, rtprog);
        }
        if (dmlconf.getBooleanValue("sysml.yarn.appmaster")) {
            if (!DMLScript.isActiveAM() && DMLYarnClientProxy.launchDMLYarnAppmaster(dmlScriptStr, dmlconf, allArgs, rtprog)) {
                return;
            }
            if (DMLScript.isActiveAM()) {
                DMLAppMasterUtils.setupProgramMappingRemoteMaxMemory(rtprog);
            }
        }
        Explain.ExplainCounts counts = Explain.countDistributedOperations(rtprog);
        Statistics.resetNoOfCompiledJobs(counts.numJobs);
        if (EXPLAIN != Explain.ExplainType.NONE) {
            LOG.info(Explain.display(prog, rtprog, EXPLAIN, counts));
        }
        Statistics.stopCompileTimer();
        ExecutionContext ec = null;
        try {
            ec = ExecutionContextFactory.createContext(rtprog);
            ScriptExecutorUtils.executeRuntimeProgram(rtprog, ec, dmlconf, STATISTICS ? STATISTICS_COUNT : 0);
        }
        finally {
            if (ec != null && ec instanceof SparkExecutionContext) {
                ((SparkExecutionContext)ec).close();
            }
            LOG.info("END DML run " + DMLScript.getDateTime());
            DMLScript.cleanupHadoopExecution(dmlconf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchDebugger(String dmlScriptStr, String fnameOptConfig, Map<String, String> argVals, ScriptType scriptType) throws org.apache.sysml.parser.ParseException, IOException, DMLRuntimeException, DMLDebuggerException, LanguageException, HopsException, LopsException {
        DMLDebuggerProgramInfo dbprog = new DMLDebuggerProgramInfo();
        DMLConfig conf = DMLConfig.readConfigurationFile(fnameOptConfig);
        ConfigurationManager.setGlobalConfig(conf);
        ParserWrapper parser = ParserFactory.createParser(scriptType);
        DMLProgram prog = parser.parse(DML_FILE_PATH_ANTLR_PARSER, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        dmlt.rewriteHopsDAG(prog);
        dmlt.constructLops(prog);
        dbprog.rtprog = dmlt.getRuntimeProgram(prog, conf);
        try {
            DMLScript.initHadoopExecution(conf);
            DMLDebugger SystemMLdb = new DMLDebugger(dbprog, dmlScriptStr);
            SystemMLdb.runSystemMLDebugger();
        }
        finally {
            DMLScript.cleanupHadoopExecution(conf);
        }
    }

    public static void initHadoopExecution(DMLConfig config) throws IOException, org.apache.sysml.parser.ParseException, DMLRuntimeException {
        DMLScript.checkSecuritySetup(config);
        String scratch = config.getTextValue("sysml.scratch");
        MapReduceTool.createDirIfNotExistOnHDFS(scratch, "777");
        DMLScript.cleanupHadoopExecution(config);
        LocalFileUtils.createWorkingDirectory();
        CacheableData.initCaching();
        Statistics.resetNoOfExecutedJobs();
        if (STATISTICS) {
            Statistics.reset();
        }
    }

    private static void checkSecuritySetup(DMLConfig config) throws IOException, DMLRuntimeException {
        String userName = System.getProperty("user.name");
        HashSet<String> groupNames = new HashSet<String>();
        try {
            if (UserGroupInformation.class.getMethod("getCurrentUser", new Class[0]) != null) {
                String[] groups = UserGroupInformation.getCurrentUser().getGroupNames();
                Collections.addAll(groupNames, groups);
            }
        }
        catch (Exception groups) {
            // empty catch block
        }
        JobConf job = ConfigurationManager.getCachedJobConf();
        boolean localMode = InfrastructureAnalyzer.isLocalMode(job);
        String taskController = job.get(MRConfigurationNames.MR_TASKTRACKER_TASKCONTROLLER, "org.apache.hadoop.mapred.DefaultTaskController");
        String ttGroupName = job.get("mapreduce.tasktracker.group", "null");
        String perm = job.get(MRConfigurationNames.DFS_PERMISSIONS_ENABLED, "null");
        URI fsURI = FileSystem.getDefaultUri(job);
        boolean flagDiffUser = !taskController.equals("org.apache.hadoop.mapred.LinuxTaskController") && !localMode && !groupNames.contains(ttGroupName);
        boolean flagLocalFS = fsURI == null || fsURI.getScheme().equals("file");
        boolean flagSecurity = perm.equals("yes");
        LOG.debug("SystemML security check: local.user.name = " + userName + ", local.user.groups = " + ProgramConverter.serializeStringCollection(groupNames) + ", " + MRConfigurationNames.MR_JOBTRACKER_ADDRESS + " = " + job.get(MRConfigurationNames.MR_JOBTRACKER_ADDRESS) + ", " + MRConfigurationNames.MR_TASKTRACKER_TASKCONTROLLER + " = " + taskController + "," + "mapreduce.tasktracker.group" + " = " + ttGroupName + ", " + MRConfigurationNames.FS_DEFAULTFS + " = " + (fsURI != null ? fsURI.getScheme() : "null") + ", " + MRConfigurationNames.DFS_PERMISSIONS_ENABLED + " = " + perm);
        if (flagDiffUser && (flagLocalFS || flagSecurity)) {
            LOG.warn("Cannot run map/reduce tasks as user '" + userName + "'. Using tasktracker group '" + ttGroupName + "'.");
        }
    }

    public static void cleanupHadoopExecution(DMLConfig config) throws IOException, org.apache.sysml.parser.ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        String dirSuffix = sb.toString();
        MapReduceTool.deleteFileIfExistOnHDFS(config.getTextValue("sysml.scratch") + dirSuffix);
        JobConf job = new JobConf(ConfigurationManager.getCachedJobConf());
        if (InfrastructureAnalyzer.isLocalMode(job)) {
            try {
                LocalFileUtils.deleteFileIfExists(DMLConfig.LOCAL_MR_MODE_STAGING_DIR + dirSuffix);
                LocalFileUtils.deleteFileIfExists(MRJobConfiguration.getLocalWorkingDirPrefix(job) + dirSuffix);
                MapReduceTool.deleteFileIfExistOnHDFS(MRJobConfiguration.getSystemWorkingDirPrefix(job) + dirSuffix);
                MapReduceTool.deleteFileIfExistOnHDFS(MRJobConfiguration.getStagingWorkingDirPrefix(job) + dirSuffix);
            }
            catch (Exception ex) {
                LOG.warn("Unable to cleanup hadoop working dirs: " + ex.getMessage());
            }
        }
        CacheableData.cleanupCacheDir();
        LocalFileUtils.cleanupWorkingDirectory();
    }

    private static void printInvocationInfo(String fnameScript, String fnameOptConfig, Map<String, String> argVals) {
        LOG.debug("****** args to DML Script ******\nUUID: " + DMLScript.getUUID() + "\nSCRIPT PATH: " + fnameScript + "\nRUNTIME: " + (Object)((Object)rtplatform) + "\nBUILTIN CONFIG: " + "./SystemML-config.xml" + "\nOPTIONAL CONFIG: " + fnameOptConfig + "\n");
        if (!argVals.isEmpty()) {
            LOG.debug("Script arguments are: \n");
            for (int i = 1; i <= argVals.size(); ++i) {
                LOG.debug("Script argument $" + i + " = " + argVals.get("$" + i));
            }
        }
    }

    private static void printStartExecInfo(String dmlScriptString) {
        LOG.info("BEGIN DML run " + DMLScript.getDateTime());
        LOG.debug("DML script: \n" + dmlScriptString);
        if (rtplatform == RUNTIME_PLATFORM.HADOOP || rtplatform == RUNTIME_PLATFORM.HYBRID) {
            String hadoop_home = System.getenv("HADOOP_HOME");
            LOG.info("HADOOP_HOME: " + hadoop_home);
        }
    }

    private static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private static void cleanSystemMLWorkspace() throws DMLException {
        try {
            String localtmp;
            DMLConfig conf = DMLConfig.readConfigurationFile(null);
            CleanupMR.runJob(conf);
            String scratch = conf.getTextValue("sysml.scratch");
            if (scratch != null) {
                MapReduceTool.deleteFileIfExistOnHDFS(scratch);
            }
            if ((localtmp = conf.getTextValue("sysml.localtmpdir")) != null) {
                LocalFileUtils.cleanupRcWorkingDirectory(localtmp);
            }
        }
        catch (Exception ex) {
            throw new DMLException("Failed to run SystemML workspace cleanup.", ex);
        }
    }

    public static class DMLOptions {
        public Map<String, String> argVals = new HashMap<String, String>();
        public String configFile = null;
        public boolean clean = false;
        public boolean stats = false;
        public int statsCount = 10;
        public Explain.ExplainType explainType = Explain.ExplainType.NONE;
        public RUNTIME_PLATFORM execMode = OptimizerUtils.getDefaultExecutionMode();
        public boolean gpu = false;
        public boolean forceGPU = false;
        public boolean debug = false;
        public ScriptType scriptType = ScriptType.DML;
        public String filePath = null;
        public String script = null;
        public boolean help = false;
        public static final DMLOptions defaultOptions = new DMLOptions();

        public String toString() {
            return "DMLOptions{argVals=" + this.argVals + ", configFile='" + this.configFile + '\'' + ", clean=" + this.clean + ", stats=" + this.stats + ", statsCount=" + this.statsCount + ", explainType=" + (Object)((Object)this.explainType) + ", execMode=" + (Object)((Object)this.execMode) + ", gpu=" + this.gpu + ", forceGPU=" + this.forceGPU + ", debug=" + this.debug + ", scriptType=" + (Object)((Object)this.scriptType) + ", filePath='" + this.filePath + '\'' + ", script='" + this.script + '\'' + ", help=" + this.help + '}';
        }
    }

    public static enum EvictionPolicy {
        LRU,
        LFU,
        MIN_EVICT,
        MRU;

    }

    public static enum RUNTIME_PLATFORM {
        HADOOP,
        SINGLE_NODE,
        HYBRID,
        HYBRID_SPARK,
        SPARK;

    }
}

