/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ViewFileSystem
extends FileSystem {
    private static final Path ROOT_PATH = new Path("/");
    final long creationTime;
    final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
    URI myUri;
    private Path workingDir;
    Configuration config;
    InodeTree<FileSystem> fsState;
    Path homeDir = null;

    static AccessControlException readOnlyMountTable(String operation, String p) {
        return new AccessControlException("InternalDir of ViewFileSystem is readonly; operation=" + operation + "Path=" + p);
    }

    static AccessControlException readOnlyMountTable(String operation, Path p) {
        return ViewFileSystem.readOnlyMountTable(operation, p.toString());
    }

    private String getUriPath(Path p) {
        this.checkPath(p);
        String s = this.makeAbsolute(p).toUri().getPath();
        return s;
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    public ViewFileSystem() throws IOException {
        this.creationTime = Time.now();
    }

    @Override
    public String getScheme() {
        return "viewfs";
    }

    @Override
    public void initialize(URI theUri, Configuration conf) throws IOException {
        super.initialize(theUri, conf);
        this.setConf(conf);
        this.config = conf;
        String authority = theUri.getAuthority();
        try {
            this.myUri = new URI("viewfs", authority, "/", null, null);
            this.fsState = new InodeTree<FileSystem>(conf, authority){

                @Override
                protected FileSystem getTargetFileSystem(URI uri) throws URISyntaxException, IOException {
                    return new ChRootedFileSystem(uri, ViewFileSystem.this.config);
                }

                @Override
                protected FileSystem getTargetFileSystem(InodeTree.INodeDir<FileSystem> dir) throws URISyntaxException {
                    return new InternalDirOfViewFs(dir, ViewFileSystem.this.creationTime, ViewFileSystem.this.ugi, ViewFileSystem.this.myUri);
                }

                @Override
                protected FileSystem getTargetFileSystem(URI[] mergeFsURIList) throws URISyntaxException, UnsupportedFileSystemException {
                    throw new UnsupportedFileSystemException("mergefs not implemented");
                }
            };
            this.workingDir = this.getHomeDirectory();
        }
        catch (URISyntaxException e) {
            throw new IOException("URISyntax exception: " + theUri);
        }
    }

    ViewFileSystem(URI theUri, Configuration conf) throws IOException {
        this();
        this.initialize(theUri, conf);
    }

    public ViewFileSystem(Configuration conf) throws IOException {
        this(FsConstants.VIEWFS_URI, conf);
    }

    public Path getTrashCanLocation(Path f) throws FileNotFoundException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return res.isInternalDir() ? null : ((FileSystem)res.targetFileSystem).getHomeDirectory();
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    @Override
    public Path resolvePath(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir()) {
            return f;
        }
        return ((FileSystem)res.targetFileSystem).resolvePath(res.remainingPath);
    }

    @Override
    public Path getHomeDirectory() {
        if (this.homeDir == null) {
            String base = this.fsState.getHomeDirPrefixValue();
            if (base == null) {
                base = "/user";
            }
            this.homeDir = base.equals("/") ? this.makeQualified(new Path(base + this.ugi.getShortUserName())) : this.makeQualified(new Path(base + "/" + this.ugi.getShortUserName()));
        }
        return this.homeDir;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.getUriPath(new_dir);
        this.workingDir = this.makeAbsolute(new_dir);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).append(res.remainingPath, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).createNonRecursive(res.remainingPath, permission, flags, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).create(res.remainingPath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir() || res.remainingPath == InodeTree.SlashPath) {
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }
        return ((FileSystem)res.targetFileSystem).delete(res.remainingPath, recursive);
    }

    @Override
    public boolean delete(Path f) throws AccessControlException, FileNotFoundException, IOException {
        return this.delete(f, true);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(fs.getPath()), true);
        return ((FileSystem)res.targetFileSystem).getFileBlockLocations(new ViewFsFileStatus(fs, res.remainingPath), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getFileChecksum(res.remainingPath);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus status = ((FileSystem)res.targetFileSystem).getFileStatus(res.remainingPath);
        return new ViewFsFileStatus(status, this.makeQualified(f));
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).access(res.remainingPath, mode);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus[] statusLst = ((FileSystem)res.targetFileSystem).listStatus(res.remainingPath);
        if (!res.isInternalDir()) {
            ChRootedFileSystem targetFs = (ChRootedFileSystem)res.targetFileSystem;
            int i = 0;
            for (FileStatus status : statusLst) {
                String suffix = targetFs.stripOutRoot(status.getPath());
                statusLst[i++] = new ViewFsFileStatus(status, this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix)));
            }
        }
        return statusLst;
    }

    @Override
    public boolean mkdirs(Path dir, FsPermission permission) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        return ((FileSystem)res.targetFileSystem).mkdirs(res.remainingPath, permission);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).open(res.remainingPath, bufferSize);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        InodeTree.ResolveResult<FileSystem> resSrc = this.fsState.resolve(this.getUriPath(src), false);
        if (resSrc.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }
        InodeTree.ResolveResult<FileSystem> resDst = this.fsState.resolve(this.getUriPath(dst), false);
        if (resDst.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", dst);
        }
        if (resSrc.targetFileSystem != resDst.targetFileSystem) {
            throw new IOException("Renames across Mount points not supported");
        }
        return ((FileSystem)resSrc.targetFileSystem).rename(resSrc.remainingPath, resDst.remainingPath);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setOwner(res.remainingPath, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setPermission(res.remainingPath, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).setReplication(res.remainingPath, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setTimes(res.remainingPath, mtime, atime);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).modifyAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeDefaultAcl(res.remainingPath);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAcl(res.remainingPath);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setAcl(res.remainingPath, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getAclStatus(res.remainingPath);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setXAttr(res.remainingPath, name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttr(res.remainingPath, name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath, names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).listXAttrs(res.remainingPath);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeXAttr(res.remainingPath, name);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setVerifyChecksum(verifyChecksum);
        }
    }

    @Override
    public long getDefaultBlockSize() {
        throw new NotInMountpointException("getDefaultBlockSize");
    }

    @Override
    public short getDefaultReplication() {
        throw new NotInMountpointException("getDefaultReplication");
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        throw new NotInMountpointException("getServerDefaults");
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultBlockSize(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }
    }

    @Override
    public short getDefaultReplication(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultReplication(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getServerDefaults(res.remainingPath);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getContentSummary(res.remainingPath);
    }

    @Override
    public void setWriteChecksum(boolean writeChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setWriteChecksum(writeChecksum);
        }
    }

    @Override
    public FileSystem[] getChildFileSystems() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        HashSet<FileSystem> children = new HashSet<FileSystem>();
        for (InodeTree.MountPoint<FileSystem> mountPoint : mountPoints) {
            FileSystem targetFs = (FileSystem)mountPoint.target.targetFileSystem;
            children.addAll(Arrays.asList(targetFs.getChildFileSystems()));
        }
        return children.toArray(new FileSystem[0]);
    }

    public MountPoint[] getMountPoints() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        MountPoint[] result = new MountPoint[mountPoints.size()];
        for (int i = 0; i < mountPoints.size(); ++i) {
            result[i] = new MountPoint(new Path(mountPoints.get((int)i).src), mountPoints.get((int)i).target.targetDirLinkList);
        }
        return result;
    }

    static /* synthetic */ Path access$000() {
        return ROOT_PATH;
    }
}

