/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class AppReportFetcher {
    private static final Log LOG = LogFactory.getLog(AppReportFetcher.class);
    private final Configuration conf;
    private final ApplicationClientProtocol applicationsManager;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public AppReportFetcher(Configuration conf) {
        this.conf = conf;
        try {
            this.applicationsManager = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationClientProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public AppReportFetcher(Configuration conf, ApplicationClientProtocol applicationsManager) {
        this.conf = conf;
        this.applicationsManager = applicationsManager;
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        GetApplicationReportRequest request = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        GetApplicationReportResponse response = this.applicationsManager.getApplicationReport(request);
        return response.getApplicationReport();
    }

    public void stop() {
        if (this.applicationsManager != null) {
            RPC.stopProxy((Object)this.applicationsManager);
        }
    }
}

