/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.concurrent.Callable;
import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNNHelper;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class LibMatrixDNNPoolingBackwardHelper {

    public static class PoolingBackwardSparseSparse
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;
        double[] outputArray;
        boolean performReluBackward;
        int C;
        int CHW;
        int P;
        int Q;
        int HW;

        public PoolingBackwardSparseSparse(int rl, int ru, ConvolutionParameters params, boolean performReluBackward) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
            this.performReluBackward = performReluBackward;
            this.outputArray = params.output.getDenseBlock();
            this.C = params.C;
            this.CHW = params.C * params.H * params.W;
            this.HW = params.H * params.W;
            this.P = params.P;
            this.Q = params.Q;
            if (this.outputArray == null) {
                throw new RuntimeException("Incorrect usage: empty outputs");
            }
            if (!params.input1.isInSparseFormat() || !params.input2.isInSparseFormat()) {
                throw new RuntimeException("Incorrect usage: Call optimized versions");
            }
        }

        @Override
        public Long call() throws Exception {
            for (int n = this._rl; n < this._ru; ++n) {
                if (this._params.input2.sparseBlock.isEmpty(n)) continue;
                int[] tensorIndexes = new int[3];
                int apos = this._params.input2.sparseBlock.pos(n);
                int alen = this._params.input2.sparseBlock.size(n);
                int[] aix = this._params.input2.sparseBlock.indexes(n);
                double[] avals = this._params.input2.sparseBlock.values(n);
                for (int j = apos; j < apos + alen; ++j) {
                    LibMatrixDNNHelper.computeTensorIndexes(aix[j], tensorIndexes, this.P, this.Q);
                    int c = tensorIndexes[0];
                    int p = tensorIndexes[1];
                    int q = tensorIndexes[2];
                    int inputOffset = n * this.CHW + c * this.HW;
                    int maxIndex = LibMatrixDNNHelper.getMaxIndexSparse(p, q, inputOffset, n, c, this._params.input1, this._params, this.performReluBackward);
                    if (maxIndex == -1) continue;
                    int n2 = maxIndex;
                    this.outputArray[n2] = this.outputArray[n2] + avals[j];
                }
            }
            return 0L;
        }
    }

    public static class PoolingBackwardSparseDense
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;
        double[] outputArray;
        boolean performReluBackward;
        double[] doutArray;
        int C;
        int CHW;
        int P;
        int Q;
        int HW;
        int CPQ;
        int PQ;

        public PoolingBackwardSparseDense(int rl, int ru, ConvolutionParameters params, boolean performReluBackward) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
            this.performReluBackward = performReluBackward;
            this.doutArray = params.input2.getDenseBlock();
            this.outputArray = params.output.getDenseBlock();
            this.C = params.C;
            this.CHW = params.C * params.H * params.W;
            this.HW = params.H * params.W;
            this.P = params.P;
            this.Q = params.Q;
            this.CPQ = params.C * params.P * params.Q;
            this.PQ = params.P * params.Q;
            if (this.doutArray == null || this.outputArray == null) {
                throw new RuntimeException("Incorrect usage: empty inputs");
            }
            if (!params.input1.isInSparseFormat()) {
                throw new RuntimeException("Incorrect usage: Call optimized versions");
            }
        }

        @Override
        public Long call() throws Exception {
            for (int n = this._rl; n < this._ru; ++n) {
                for (int c = 0; c < this.C; ++c) {
                    for (int p = 0; p < this.P; ++p) {
                        for (int q = 0; q < this.Q; ++q) {
                            int inputOffset;
                            int maxIndex;
                            double inVal = this.doutArray[n * this.CPQ + c * this.PQ + p * this.Q + q];
                            if (inVal == 0.0 || (maxIndex = LibMatrixDNNHelper.getMaxIndexSparse(p, q, inputOffset = n * this.CHW + c * this.HW, n, c, this._params.input1, this._params, this.performReluBackward)) == -1) continue;
                            int n2 = maxIndex;
                            this.outputArray[n2] = this.outputArray[n2] + inVal;
                        }
                    }
                }
            }
            return 0L;
        }
    }

    public static class PoolingBackwardDenseSparse
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;
        double[] outputArray;
        boolean performReluBackward;
        double[] inputArray;
        MatrixBlock dout;
        int C;
        int CHW;
        int P;
        int Q;
        int HW;

        public PoolingBackwardDenseSparse(int rl, int ru, ConvolutionParameters params, boolean performReluBackward) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
            this.performReluBackward = performReluBackward;
            this.inputArray = params.input1.getDenseBlock();
            this.dout = params.input2;
            this.outputArray = params.output.getDenseBlock();
            this.C = params.C;
            this.CHW = params.C * params.H * params.W;
            this.HW = params.H * params.W;
            this.P = params.P;
            this.Q = params.Q;
            if (this.inputArray == null || this.outputArray == null) {
                throw new RuntimeException("Incorrect usage: empty inputs");
            }
            if (!params.input2.isInSparseFormat()) {
                throw new RuntimeException("Incorrect usage: Call optimized versions");
            }
        }

        @Override
        public Long call() throws Exception {
            for (int n = this._rl; n < this._ru; ++n) {
                if (this.dout.sparseBlock.isEmpty(n)) continue;
                int[] tensorIndexes = new int[3];
                int apos = this.dout.sparseBlock.pos(n);
                int alen = this.dout.sparseBlock.size(n);
                int[] aix = this.dout.sparseBlock.indexes(n);
                double[] avals = this.dout.sparseBlock.values(n);
                for (int j = apos; j < apos + alen; ++j) {
                    LibMatrixDNNHelper.computeTensorIndexes(aix[j], tensorIndexes, this.P, this.Q);
                    int c = tensorIndexes[0];
                    int p = tensorIndexes[1];
                    int q = tensorIndexes[2];
                    int inputOffset = n * this.CHW + c * this.HW;
                    int maxIndex = LibMatrixDNNHelper.getMaxIndex(p, q, inputOffset, this.inputArray, this._params, this.performReluBackward);
                    if (maxIndex == -1) continue;
                    int n2 = maxIndex;
                    this.outputArray[n2] = this.outputArray[n2] + avals[j];
                }
            }
            return 0L;
        }
    }

    public static class PoolingBackwardDenseDense
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;
        double[] outputArray;
        boolean performReluBackward;
        double[] inputArray;
        double[] doutArray;
        int C;
        int CHW;
        int P;
        int Q;
        int HW;
        int CPQ;
        int PQ;

        public PoolingBackwardDenseDense(int rl, int ru, ConvolutionParameters params, boolean performReluBackward) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
            this.performReluBackward = performReluBackward;
            this.inputArray = params.input1.getDenseBlock();
            this.doutArray = params.input2.getDenseBlock();
            this.outputArray = params.output.getDenseBlock();
            this.C = params.C;
            this.CHW = params.C * params.H * params.W;
            this.HW = params.H * params.W;
            this.P = params.P;
            this.Q = params.Q;
            this.CPQ = params.C * params.P * params.Q;
            this.PQ = params.P * params.Q;
            if (this.inputArray == null || this.doutArray == null || this.outputArray == null) {
                throw new RuntimeException("Incorrect usage: empty inputs");
            }
        }

        @Override
        public Long call() throws Exception {
            for (int n = this._rl; n < this._ru; ++n) {
                for (int c = 0; c < this.C; ++c) {
                    int inputOffset = n * this.CHW + c * this.HW;
                    int outputOffset = n * this.CPQ + c * this.PQ;
                    for (int p = 0; p < this.P; ++p) {
                        for (int q = 0; q < this.Q; ++q) {
                            int maxIndex = LibMatrixDNNHelper.getMaxIndex(p, q, inputOffset, this.inputArray, this._params, this.performReluBackward);
                            if (maxIndex == -1) continue;
                            int n2 = maxIndex;
                            this.outputArray[n2] = this.outputArray[n2] + this.doutArray[outputOffset + p * this.Q + q];
                        }
                    }
                }
            }
            return 0L;
        }
    }
}

