/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixDimensionsMetaData;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.data.NumItemsByEachReducerMetaData;
import org.apache.sysml.runtime.matrix.data.OutputInfo;

public class JobReturn {
    public boolean successful;
    public MetaData[] metadata = null;

    public JobReturn() {
        this.successful = false;
        this.metadata = null;
    }

    public JobReturn(MatrixCharacteristics[] sts, boolean success) {
        this.successful = success;
        this.metadata = new MatrixDimensionsMetaData[sts.length];
        for (int i = 0; i < sts.length; ++i) {
            this.metadata[i] = new MatrixDimensionsMetaData(sts[i]);
        }
    }

    public JobReturn(MatrixCharacteristics[] sts, OutputInfo[] infos, boolean success) throws DMLRuntimeException {
        this.successful = success;
        this.metadata = new MatrixFormatMetaData[sts.length];
        for (int i = 0; i < sts.length; ++i) {
            this.metadata[i] = new MatrixFormatMetaData(sts[i], infos[i], OutputInfo.getMatchingInputInfo(infos[i]));
        }
    }

    public JobReturn(MatrixCharacteristics sts, OutputInfo info, boolean success) throws DMLRuntimeException {
        this.successful = success;
        this.metadata = new MatrixFormatMetaData[1];
        this.metadata[0] = new MatrixFormatMetaData(sts, info, OutputInfo.getMatchingInputInfo(info));
    }

    public JobReturn(MatrixCharacteristics mc, long[] items, int partition0, long number0s, boolean success) {
        this.successful = success;
        this.metadata = new NumItemsByEachReducerMetaData[1];
        this.metadata[0] = new NumItemsByEachReducerMetaData(mc, items, partition0, number0s);
    }

    public boolean checkReturnStatus() throws DMLRuntimeException {
        if (!this.successful) {
            throw new DMLRuntimeException("Error in executing the DML program.");
        }
        return this.successful;
    }

    public MetaData[] getMetaData() {
        return this.metadata;
    }

    public MetaData getMetaData(int i) {
        return this.metadata[i];
    }

    public MatrixCharacteristics getMatrixCharacteristics(int i) {
        return ((MatrixDimensionsMetaData)this.metadata[i]).getMatrixCharacteristics();
    }
}

