/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;
import scala.Tuple2;

public class CumulativeOffsetSPInstruction
extends BinarySPInstruction {
    private BinaryOperator _bop = null;
    private UnaryOperator _uop = null;
    private double _initValue = 0.0;

    private CumulativeOffsetSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, double init, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.CumsumOffset;
        if ("bcumoffk+".equals(opcode)) {
            this._bop = new BinaryOperator(Plus.getPlusFnObject());
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucumk+"));
        } else if ("bcumoff*".equals(opcode)) {
            this._bop = new BinaryOperator(Multiply.getMultiplyFnObject());
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucum*"));
        } else if ("bcumoffmin".equals(opcode)) {
            this._bop = new BinaryOperator(Builtin.getBuiltinFnObject("min"));
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucummin"));
        } else if ("bcumoffmax".equals(opcode)) {
            this._bop = new BinaryOperator(Builtin.getBuiltinFnObject("max"));
            this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucummax"));
        }
        this._initValue = init;
    }

    public static CumulativeOffsetSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 4);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        double init = Double.parseDouble(parts[4]);
        return new CumulativeOffsetSPInstruction(null, in1, in2, out, init, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input2.getName());
        long rlen = mc.getRows();
        int brlen = mc.getRowsPerBlock();
        JavaPairRDD<MatrixIndexes, MatrixBlock> inData = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD inAgg = sec.getBinaryBlockRDDHandleForVariable(this.input2.getName());
        inAgg = inAgg.flatMapToPair((PairFlatMapFunction)new RDDCumSplitFunction(this._initValue, rlen, brlen));
        JavaPairRDD out = inData.join(inAgg).mapValues((Function)new RDDCumOffsetFunction(this._uop, this._bop));
        this.updateUnaryOutputMatrixCharacteristics(sec);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
    }

    private static class RDDCumOffsetFunction
    implements Function<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock> {
        private static final long serialVersionUID = -5804080263258064743L;
        private UnaryOperator _uop = null;
        private BinaryOperator _bop = null;

        public RDDCumOffsetFunction(UnaryOperator uop, BinaryOperator bop) {
            this._uop = uop;
            this._bop = bop;
        }

        public MatrixBlock call(Tuple2<MatrixBlock, MatrixBlock> arg0) throws Exception {
            MatrixBlock dblkIn = (MatrixBlock)arg0._1();
            MatrixBlock oblkIn = (MatrixBlock)arg0._2();
            MatrixBlock blkOut = new MatrixBlock(dblkIn.getNumRows(), dblkIn.getNumColumns(), dblkIn.isInSparseFormat());
            MatrixBlock data2 = new MatrixBlock(dblkIn);
            MatrixBlock fdata2 = data2.sliceOperations(0, 0, 0, data2.getNumColumns() - 1, new MatrixBlock());
            fdata2.binaryOperationsInPlace(this._bop, oblkIn);
            data2.copy(0, 0, 0, data2.getNumColumns() - 1, fdata2, true);
            data2.unaryOperations(this._uop, blkOut);
            return blkOut;
        }
    }

    private static class RDDCumSplitFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -8407407527406576965L;
        private double _initValue = 0.0;
        private int _brlen = -1;
        private long _lastRowBlockIndex;

        public RDDCumSplitFunction(double initValue, long rlen, int brlen) {
            this._initValue = initValue;
            this._brlen = brlen;
            this._lastRowBlockIndex = (long)Math.ceil((double)rlen / (double)brlen);
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            boolean lastBlk;
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            long rixOffset = (ixIn.getRowIndex() - 1L) * (long)this._brlen;
            boolean firstBlk = ixIn.getRowIndex() == 1L;
            boolean bl = lastBlk = ixIn.getRowIndex() == this._lastRowBlockIndex;
            if (firstBlk) {
                MatrixIndexes tmpix = new MatrixIndexes(1L, ixIn.getColumnIndex());
                MatrixBlock tmpblk = new MatrixBlock(1, blkIn.getNumColumns(), blkIn.isInSparseFormat());
                if (this._initValue != 0.0) {
                    for (int j = 0; j < blkIn.getNumColumns(); ++j) {
                        tmpblk.appendValue(0, j, this._initValue);
                    }
                }
                ret.add(new Tuple2((Object)tmpix, (Object)tmpblk));
            }
            for (int i = 0; i < blkIn.getNumRows(); ++i) {
                if (lastBlk && i == blkIn.getNumRows() - 1) continue;
                MatrixIndexes tmpix = new MatrixIndexes(rixOffset + (long)i + 2L, ixIn.getColumnIndex());
                MatrixBlock tmpblk = new MatrixBlock(1, blkIn.getNumColumns(), blkIn.isInSparseFormat());
                blkIn.sliceOperations(i, i, 0, blkIn.getNumColumns() - 1, tmpblk);
                ret.add(new Tuple2((Object)tmpix, (Object)tmpblk));
            }
            return ret.iterator();
        }
    }
}

