/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;

public class ExternalFunctionStatement
extends FunctionStatement {
    public static final String CLASS_NAME = "classname";
    public static final String EXEC_TYPE = "exectype";
    public static final String CONFIG_FILE = "configfile";
    public static final String FILE_BASED = "file";
    public static final String IN_MEMORY = "mem";
    public static final String DEFAULT_EXEC_TYPE = "file";
    private HashMap<String, String> _otherParams;

    public void setOtherParams(HashMap<String, String> params) {
        this._otherParams = params;
    }

    public HashMap<String, String> getOtherParams() {
        return this._otherParams;
    }

    public void validateParameters(StatementBlock sb) throws LanguageException {
        for (String varName : this._otherParams.keySet()) {
            if (varName.equals(CLASS_NAME) || varName.equals(EXEC_TYPE) || varName.equals(CONFIG_FILE)) continue;
            LOG.warn((Object)(this.printWarningLocation() + "External function specifies undefined attribute type '" + varName + "'."));
        }
        if (!this._otherParams.containsKey(CLASS_NAME)) {
            sb.raiseValidateError("External function does not specify the required attribute 'classname'.", false);
        } else if (this._otherParams.get(CLASS_NAME) == null) {
            sb.raiseValidateError("External function specifies empty 'classname'.", false);
        }
        if (this._otherParams.containsKey(EXEC_TYPE)) {
            String execType = this._otherParams.get(EXEC_TYPE);
            if (!execType.equals("file") && !execType.equals(IN_MEMORY)) {
                sb.raiseValidateError("External function specifies invalid value for (optional) attribute 'exectype' (valid values: file,mem).", false);
            }
        } else {
            this._otherParams.put(EXEC_TYPE, "file");
        }
    }

    @Override
    public boolean controlStatement() {
        return true;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this._name + " = ");
        sb.append("externalfunction ( ");
        for (i = 0; i < this._inputParams.size(); ++i) {
            DataIdentifier curr = (DataIdentifier)this._inputParams.get(i);
            sb.append(curr.getName());
            if (i >= this._inputParams.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(") return (");
        for (i = 0; i < this._outputParams.size(); ++i) {
            sb.append(((DataIdentifier)this._outputParams.get(i)).getName());
            if (i >= this._outputParams.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")\n implemented in (");
        int j = 0;
        for (String key : this._otherParams.keySet()) {
            sb.append(key + " = " + this._otherParams.get(key));
            if (j < this._otherParams.keySet().size() - 1) {
                sb.append(", ");
            }
            ++j;
        }
        sb.append(") \n");
        return sb.toString();
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) throws LanguageException {
        LOG.error((Object)(this.printErrorLocation() + "should never call initializeforwardLV for ExternalFunctionStatement"));
        throw new LanguageException(this.printErrorLocation() + "should never call initializeforwardLV for ExternalFunctionStatement");
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) throws LanguageException {
        LOG.error((Object)(this.printErrorLocation() + "should never call initializeforwardLV for ExternalFunctionStatement"));
        throw new LanguageException(this.printErrorLocation() + "should never call initializeforwardLV for ExternalFunctionStatement");
    }

    @Override
    public VariableSet variablesRead() {
        LOG.warn((Object)(this.printWarningLocation() + "should not call variablesRead from ExternalFunctionStatement "));
        return new VariableSet();
    }

    @Override
    public VariableSet variablesUpdated() {
        LOG.warn((Object)(this.printWarningLocation() + "should not call variablesRead from ExternalFunctionStatement "));
        return new VariableSet();
    }
}

