/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.rnn.Backward_output;
import org.apache.sysml.scripts.nn.layers.rnn.Forward_output;
import org.apache.sysml.scripts.nn.layers.rnn.Init_output;

public class Rnn
extends Script {
    public Rnn() {
        String string = "scripts/nn/layers/rnn.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/rnn.dml') as mlcontextns;[W, b, out0] = mlcontextns::init(N, D, M);";
        Script script = new Script(string);
        script.in("N", object).in("D", object2).in("M", object3).out("W").out("b").out("out0");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Matrix matrix3 = mLResults.getMatrix("out0");
        Init_output init_output = new Init_output(matrix, matrix2, matrix3);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int N, int D, int M)\n    return (matrix[double] W, matrix[double] b, matrix[double] out0) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the Glorot uniform heuristic which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * uniform weights by a factor of sqrt(6/(fan_in + fan_out)).\n   *  - http://jmlr.org/proceedings/papers/v9/glorot10a/glorot10a.pdf\n   *\n   * Inputs:\n   *  - N: Number of examples in batch.\n   *  - D: Dimensionality of the input features (number of features).\n   *  - M: Number of neurons in this layer.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (D+M, M).\n   *  - b: Biases, of shape (1, M).\n   *  - out0: Empty previous timestep output matrix, of shape (N, M).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int N, int D, int M)\n    return (matrix[double] W, matrix[double] b, matrix[double] out0) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the Glorot uniform heuristic which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * uniform weights by a factor of sqrt(6/(fan_in + fan_out)).\n   *  - http://jmlr.org/proceedings/papers/v9/glorot10a/glorot10a.pdf\n   *\n   * Inputs:\n   *  - N: Number of examples in batch.\n   *  - D: Dimensionality of the input features (number of features).\n   *  - M: Number of neurons in this layer.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (D+M, M).\n   *  - b: Biases, of shape (1, M).\n   *  - out0: Empty previous timestep output matrix, of shape (N, M).\n   */\n  fan_in = D+M\n  fan_out = M\n  scale = sqrt(6/(fan_in+fan_out))\n  W = rand(rows=D+M, cols=M, min=-scale, max=scale, pdf=\"uniform\")\n  b = matrix(0, rows=1, cols=M)\n  out0 = matrix(0, rows=N, cols=M)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        String string = "source('scripts/nn/layers/rnn.dml') as mlcontextns;[out, cache_out] = mlcontextns::forward(X, W, b, T, D, return_sequences, out0);";
        Script script = new Script(string);
        script.in("X", object).in("W", object2).in("b", object3).in("T", object4).in("D", object5).in("return_sequences", object6).in("out0", object7).out("out").out("cache_out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        Matrix matrix2 = mLResults.getMatrix("cache_out");
        Forward_output forward_output = new Forward_output(matrix, matrix2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b, int T, int D,\n                   boolean return_sequences, matrix[double] out0)\n    return (matrix[double] out, matrix[double] cache_out) {\n  /*\n   * Computes the forward pass for a simple RNN layer with M neurons.\n   * The input data has N sequences of T examples, each with D features.\n   *\n   * In a simple RNN, the output of the previous timestep is fed back\n   * in as an additional input at the current timestep.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, M).\n   *  - b: Biases, of shape (1, M).\n   *  - T: Length of example sequences (number of timesteps).\n   *  - D: Dimensionality of the input features (number of features).\n   *  - return_sequences: Whether to return `out` at all timesteps,\n   *      or just for the final timestep.\n   *  - out0: Output matrix from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *\n   * Outputs:\n   *  - out: If `return_sequences` is True, outputs for all timesteps,\n   *      of shape (N, T*M).  Else, outputs for the final timestep, of\n   *      shape (N, M).\n   *  - cache_out: Cache of outputs, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b, int T, int D,\n                   boolean return_sequences, matrix[double] out0)\n    return (matrix[double] out, matrix[double] cache_out) {\n  /*\n   * Computes the forward pass for a simple RNN layer with M neurons.\n   * The input data has N sequences of T examples, each with D features.\n   *\n   * In a simple RNN, the output of the previous timestep is fed back\n   * in as an additional input at the current timestep.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, M).\n   *  - b: Biases, of shape (1, M).\n   *  - T: Length of example sequences (number of timesteps).\n   *  - D: Dimensionality of the input features (number of features).\n   *  - return_sequences: Whether to return `out` at all timesteps,\n   *      or just for the final timestep.\n   *  - out0: Output matrix from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *\n   * Outputs:\n   *  - out: If `return_sequences` is True, outputs for all timesteps,\n   *      of shape (N, T*M).  Else, outputs for the final timestep, of\n   *      shape (N, M).\n   *  - cache_out: Cache of outputs, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   */\n  N = nrow(X)\n  M = ncol(W)\n  out_prev = out0\n  if (return_sequences) {\n    out = matrix(0, rows=N, cols=T*M)\n  }\n  else {\n    out = matrix(0, rows=N, cols=M)\n  }\n  # caches to be used during the backward pass for performance\n  cache_out = matrix(0, rows=T, cols=N*M)\n\n  for (t in 1:T) {  # each timestep\n    X_t = X[,(t-1)*D+1:t*D]  # shape (N, D)\n    input = cbind(X_t, out_prev)  # shape (N, D+M)\n    out_t = tanh::forward(input %*% W + b)  # shape (N, M)\n    # store\n    if (return_sequences) {\n      out[,(t-1)*M+1:t*M] = out_t\n    }\n    else {\n      out = out_t\n    }\n    out_prev = out_t\n    cache_out[t,] = matrix(out_t, rows=1, cols=N*M)  # reshape\n  }\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        String string = "source('scripts/nn/layers/rnn.dml') as mlcontextns;[dX, dW, db, dout0] = mlcontextns::backward(dout, X, W, b, T, D, given_sequences, out0, cache_out);";
        Script script = new Script(string);
        script.in("dout", object).in("X", object2).in("W", object3).in("b", object4).in("T", object5).in("D", object6).in("given_sequences", object7).in("out0", object8).in("cache_out", object9).out("dX").out("dW").out("db").out("dout0");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dW");
        Matrix matrix3 = mLResults.getMatrix("db");
        Matrix matrix4 = mLResults.getMatrix("dout0");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3, matrix4);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] X, matrix[double] W, matrix[double] b,\n                    int T, int D, boolean given_sequences, matrix[double] out0,\n                    matrix[double] cache_out)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db, matrix[double] dout0) {\n  /*\n   * Computes the backward pass for a simple RNN layer with M neurons.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream.  If `given_sequences`\n   *      is True, contains gradients on outputs for all timesteps,\n   *      of shape (N, T*M).  Else, contains gradient on output for\n   *      the final timestep, of shape (N, M).\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, M).\n   *  - b: Biases, of shape (1, M).\n   *  - T: Length of example sequences (number of timesteps).\n   *  - D: Dimensionality of the input features (number of features).\n   *  - given_sequences: Whether `dout` is for all timesteps,\n   *      or just for the final timestep.  This is based on whether\n   *      `return_sequences` was true in the forward pass.\n   *  - out0: Output matrix from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - cache_out: Cache of outputs, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, T*D).\n   *  - dW: Gradient wrt `W`, of shape (D+M, 4M).\n   *  - db: Gradient wrt `b`, of shape (1, 4M).\n   *  - dout0: Gradient wrt `out0`, of shape (N, M).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] X, matrix[double] W, matrix[double] b,\n                    int T, int D, boolean given_sequences, matrix[double] out0,\n                    matrix[double] cache_out)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db, matrix[double] dout0) {\n  /*\n   * Computes the backward pass for a simple RNN layer with M neurons.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream.  If `given_sequences`\n   *      is True, contains gradients on outputs for all timesteps,\n   *      of shape (N, T*M).  Else, contains gradient on output for\n   *      the final timestep, of shape (N, M).\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, M).\n   *  - b: Biases, of shape (1, M).\n   *  - T: Length of example sequences (number of timesteps).\n   *  - D: Dimensionality of the input features (number of features).\n   *  - given_sequences: Whether `dout` is for all timesteps,\n   *      or just for the final timestep.  This is based on whether\n   *      `return_sequences` was true in the forward pass.\n   *  - out0: Output matrix from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - cache_out: Cache of outputs, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, T*D).\n   *  - dW: Gradient wrt `W`, of shape (D+M, 4M).\n   *  - db: Gradient wrt `b`, of shape (1, 4M).\n   *  - dout0: Gradient wrt `out0`, of shape (N, M).\n   */\n  N = nrow(X)\n  M = ncol(W)\n  dX = matrix(0, rows=N, cols=T*D)\n  dW = matrix(0, rows=D+M, cols=M)\n  db = matrix(0, rows=1, cols=M)\n  dout0 = matrix(0, rows=N, cols=M)\n  if (!given_sequences) {\n    # only given dout for output at final timestep, so prepend empty douts for all other timesteps\n    dout = cbind(matrix(0, rows=N, cols=(T-1)*D), dout)  # shape (N, T*M)\n  }\n\n  t = T\n  for (iter in 1:T) {  # each timestep in reverse order\n    X_t = X[,(t-1)*D+1:t*D]  # shape (N, D)\n    dout_t = dout[,(t-1)*M+1:t*M]  # shape (N, M)\n    out_t = matrix(cache_out[t,], rows=N, cols=M)  # shape (N, M)\n    if (t == 1) {\n      out_prev = out0  # shape (N, M)\n    }\n    else {\n      out_prev = matrix(cache_out[t-1,], rows=N, cols=M)  # shape (N, M)\n    }\n    input = cbind(X_t, out_prev)  # shape (N, D+M)\n    dout_t_raw = (1-out_t^2) * dout_t  # into tanh, shape (N, M)\n    dW = dW + t(input) %*% dout_t_raw  # shape (D+M, M)\n    db = db + colSums(dout_t_raw)  # shape (1, M)\n    dinput = dout_t_raw %*% t(W)  # shape (N, D+M)\n    dX[,(t-1)*D+1:t*D] = dinput[,1:D]\n    dout_prev = dinput[,D+1:D+M]  # shape (N, M)\n    if (t == 1) {\n      dout0 = dout_prev  # shape (N, M)\n    }\n    else {\n      dout[,(t-2)*M+1:(t-1)*M] = dout[,(t-2)*M+1:(t-1)*M] + dout_prev  # shape (N, M)\n    }\n    t = t - 1\n  }\n}\n";
        return string;
    }
}

