/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;
import org.apache.sysml.runtime.util.UtilFunctions;

public class CSVReblockMapper
extends MapperBase
implements Mapper<LongWritable, Text, TaggedFirstSecondIndexes, CSVReblockMR.BlockRow> {
    private long rowOffset = 0L;
    private boolean first = true;
    private long num = 0L;
    private HashMap<Long, Long> offsetMap = new HashMap();
    private String _delim = " ";
    private boolean ignoreFirstLine = false;
    private boolean headerFile = false;
    private IndexedBlockRow idxRow = null;

    public static IndexedBlockRow processRow(IndexedBlockRow row, String[] cells, long rowOffset, long num, byte outTag, int brlen, int bclen, boolean fill, double fillValue, OutputCollector<TaggedFirstSecondIndexes, CSVReblockMR.BlockRow> out) throws IOException {
        long col;
        int start = 0;
        row.getIndexes().setTag(outTag);
        long rowIndex = UtilFunctions.computeBlockIndex(rowOffset + num + 1L, brlen);
        row.getRow().indexInBlock = UtilFunctions.computeCellInBlock(rowOffset + num + 1L, brlen);
        for (col = 0L; col < (long)(cells.length / bclen); ++col) {
            row.getRow().data.reset(1, bclen);
            row.getIndexes().setIndexes(rowIndex, col + 1L);
            for (int k = 0; k < bclen; ++k) {
                if (cells[k + start] == null || cells[k + start].isEmpty()) {
                    IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(null, fill, true);
                    row.getRow().data.appendValue(0, k, fillValue);
                    continue;
                }
                row.getRow().data.appendValue(0, k, UtilFunctions.parseToDouble(cells[k + start]));
            }
            out.collect((Object)row.getIndexes(), (Object)row.getRow());
            start += bclen;
        }
        row.getIndexes().setIndexes(rowIndex, col + 1L);
        int lastBclen = cells.length % bclen;
        if (lastBclen != 0) {
            row.getRow().data.reset(1, lastBclen);
            for (int k = 0; k < lastBclen; ++k) {
                if (cells[k + start] == null || cells[k + start].isEmpty()) {
                    if (!fill) {
                        throw new RuntimeException("Empty fields found in the input delimited file. Use \"fill\" option to read delimited files with empty fields.");
                    }
                    row.getRow().data.appendValue(0, k, fillValue);
                    continue;
                }
                row.getRow().data.appendValue(0, k, UtilFunctions.parseToDouble(cells[k + start]));
            }
            out.collect((Object)row.getIndexes(), (Object)row.getRow());
        }
        return row;
    }

    public void map(LongWritable key, Text value, OutputCollector<TaggedFirstSecondIndexes, CSVReblockMR.BlockRow> out, Reporter reporter) throws IOException {
        if (this.first) {
            this.rowOffset = this.offsetMap.get(key.get());
            this.first = false;
        }
        if (key.get() == 0L && this.headerFile && this.ignoreFirstLine) {
            return;
        }
        String[] cells = IOUtilFunctions.split(value.toString(), this._delim);
        for (int i = 0; i < this.representativeMatrixes.size(); ++i) {
            for (CSVReblockInstruction ins : (ArrayList)this.csv_reblock_instructions.get(i)) {
                this.idxRow = CSVReblockMapper.processRow(this.idxRow, cells, this.rowOffset, this.num, ins.output, ins.brlen, ins.bclen, ins.fill, ins.fillValue, out);
            }
        }
        ++this.num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(JobConf job) {
        super.configure(job);
        byte matrixIndex = (Byte)this.representativeMatrixes.get(0);
        try {
            Path thisPath = new Path(job.get(MRConfigurationNames.MR_MAP_INPUT_FILE));
            FileSystem fs = IOUtilFunctions.getFileSystem(thisPath, (Configuration)job);
            thisPath = thisPath.makeQualified(fs);
            String filename = thisPath.toString();
            Path headerPath = new Path(job.getStrings("smallest.file.name.per.input")[matrixIndex]).makeQualified(fs);
            if (headerPath.toString().equals(filename)) {
                this.headerFile = true;
            }
            ByteWritable key = new ByteWritable();
            CSVReblockMR.OffsetCount value = new CSVReblockMR.OffsetCount();
            Path p = new Path(job.get("rowid.file.name"));
            SequenceFile.Reader reader = null;
            try {
                reader = new SequenceFile.Reader(fs, p, (Configuration)job);
                while (reader.next((Writable)key, (Writable)value)) {
                    if (key.get() != matrixIndex || !filename.equals(value.filename)) continue;
                    this.offsetMap.put(value.fileOffset, value.count);
                }
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(reader);
                throw throwable;
            }
            IOUtilFunctions.closeSilently((Closeable)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CSVReblockInstruction ins = (CSVReblockInstruction)((ArrayList)this.csv_reblock_instructions.get(0)).get(0);
        this._delim = ins.delim;
        this.ignoreFirstLine = ins.hasHeader;
        this.idxRow = new IndexedBlockRow();
        int maxBclen = 0;
        for (ArrayList insv : this.csv_reblock_instructions) {
            for (CSVReblockInstruction in : insv) {
                if (maxBclen >= in.bclen) continue;
                maxBclen = in.bclen;
            }
        }
        this.idxRow.getRow().data.reset(1, maxBclen, false);
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
    }

    public static class IndexedBlockRow {
        private CSVReblockMR.BlockRow row = new CSVReblockMR.BlockRow();
        private TaggedFirstSecondIndexes outIndexes = null;

        public IndexedBlockRow() {
            this.row.data = new MatrixBlock();
            this.outIndexes = new TaggedFirstSecondIndexes();
        }

        public CSVReblockMR.BlockRow getRow() {
            return this.row;
        }

        public TaggedFirstSecondIndexes getIndexes() {
            return this.outIndexes;
        }
    }
}

