/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.FastStringTokenizer;

public class ReaderTextCell
extends MatrixReader {
    private boolean _isMMFile = false;

    public ReaderTextCell(InputInfo info) {
        this._isMMFile = info == InputInfo.MatrixMarketInputInfo;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderTextCell.createOutputMatrixBlock(rlen, clen, (int)rlen, (int)clen, estnnz, true, false);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderTextCell.checkValidInputFile(fs, path);
        if (fs.isDirectory(path)) {
            this.readTextCellMatrixFromHDFS(path, job, ret, rlen, clen, brlen, bclen);
        } else {
            this.readRawTextCellMatrixFromHDFS(path, job, fs, ret, rlen, clen, brlen, bclen, this._isMMFile);
        }
        if (!ret.isInSparseFormat()) {
            ret.recomputeNonZeros();
        }
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderTextCell.createOutputMatrixBlock(rlen, clen, brlen, bclen, estnnz, true, false);
        this.readRawTextCellMatrixFromInputStream(is, ret, rlen, clen, brlen, bclen, this._isMMFile);
        if (!ret.isInSparseFormat()) {
            ret.recomputeNonZeros();
        }
        ret.examSparsity();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTextCellMatrixFromHDFS(Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int brlen, int bclen) throws IOException {
        boolean sparse = dest.isInSparseFormat();
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int row = -1;
        int col = -1;
        try {
            FastStringTokenizer st = new FastStringTokenizer(' ');
            for (InputSplit split : splits) {
                RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
                try {
                    double lvalue;
                    if (sparse) {
                        while (reader.next((Object)key, (Object)value)) {
                            st.reset(value.toString());
                            row = st.nextInt() - 1;
                            col = st.nextInt() - 1;
                            lvalue = st.nextDouble();
                            dest.appendValue(row, col, lvalue);
                        }
                        dest.sortSparseRows();
                        continue;
                    }
                    while (reader.next((Object)key, (Object)value)) {
                        st.reset(value.toString());
                        row = st.nextInt() - 1;
                        col = st.nextInt() - 1;
                        lvalue = st.nextDouble();
                        dest.setValueDenseUnsafe(row, col, lvalue);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
        }
        catch (Exception ex) {
            if (row < 0 || (long)(row + 1) > rlen || col < 0 || (long)(col + 1) > clen) {
                throw new IOException("Matrix cell [" + (row + 1) + "," + (col + 1) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            throw new IOException("Unable to read matrix in text cell format.", ex);
        }
    }

    private void readRawTextCellMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean matrixMarket) throws IOException {
        FSDataInputStream inputStream = fs.open(path);
        this.readRawTextCellMatrixFromInputStream((InputStream)inputStream, dest, rlen, clen, brlen, bclen, matrixMarket);
    }

    private void readRawTextCellMatrixFromInputStream(InputStream is, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean matrixMarket) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        boolean sparse = dest.isInSparseFormat();
        String value = null;
        int row = -1;
        int col = -1;
        if (matrixMarket) {
            value = br.readLine();
            if (value == null || !value.startsWith("%%")) {
                throw new IOException("Error while reading file in MatrixMarket format. Expecting a header line, but encountered, \"" + value + "\".");
            }
            while ((value = br.readLine()) != null && value.charAt(0) == '%') {
            }
            String[] fields = value.trim().split("\\s+");
            long mm_rlen = Long.parseLong(fields[0]);
            long mm_clen = Long.parseLong(fields[1]);
            if (rlen != mm_rlen || clen != mm_clen) {
                throw new IOException("Unexpected matrix dimensions while reading file in MatrixMarket format. Expecting dimensions [" + rlen + " rows, " + clen + " cols] but encountered [" + mm_rlen + " rows, " + mm_clen + "cols].");
            }
        }
        try {
            FastStringTokenizer st = new FastStringTokenizer(' ');
            if (sparse) {
                while ((value = br.readLine()) != null) {
                    st.reset(value);
                    row = st.nextInt() - 1;
                    col = st.nextInt() - 1;
                    double lvalue = st.nextDouble();
                    dest.appendValue(row, col, lvalue);
                }
                dest.sortSparseRows();
            } else {
                while ((value = br.readLine()) != null) {
                    st.reset(value);
                    row = st.nextInt() - 1;
                    col = st.nextInt() - 1;
                    double lvalue = st.nextDouble();
                    dest.setValueDenseUnsafe(row, col, lvalue);
                }
            }
        }
        catch (Exception ex) {
            if (row < 0 || (long)(row + 1) > rlen || col < 0 || (long)(col + 1) > clen) {
                throw new IOException("Matrix cell [" + (row + 1) + "," + (col + 1) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].", ex);
            }
            throw new IOException("Unable to read matrix in raw text cell format.", ex);
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }
}

