/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;

public abstract class Instruction {
    protected static final Log LOG = LogFactory.getLog((String)Instruction.class.getName());
    public static final String OPERAND_DELIM = "\u00b0";
    public static final String DATATYPE_PREFIX = "\u00b7";
    public static final String VALUETYPE_PREFIX = "\u00b7";
    public static final String LITERAL_PREFIX = "\u00b7";
    public static final String INSTRUCTION_DELIM = "\u2021";
    public static final String SP_INST_PREFIX = "sp_";
    public static final String GPU_INST_PREFIX = "gpu_";
    protected INSTRUCTION_TYPE type = null;
    protected String instString = null;
    protected String instOpcode = null;
    private String extendedOpcode = null;
    private long instID = -1L;
    protected String filename = null;
    protected int beginLine = -1;
    protected int endLine = -1;
    protected int beginCol = -1;
    protected int endCol = -1;

    public String getFilename() {
        return this.filename;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginCol;
    }

    public int getEndColumn() {
        return this.endCol;
    }

    public void setType(INSTRUCTION_TYPE tp) {
        this.type = tp;
    }

    public INSTRUCTION_TYPE getType() {
        return this.type;
    }

    public void setLocation(String filename, int beginLine, int endLine, int beginCol, int endCol) {
        this.filename = filename;
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginCol = beginCol;
        this.endCol = endCol;
    }

    public void setLocation(Lop lop) {
        if (lop != null) {
            this.filename = lop.getFilename();
            this.beginLine = lop._beginLine;
            this.endLine = lop._endLine;
            this.beginCol = lop._beginColumn;
            this.endCol = lop._endColumn;
        }
    }

    public void setLocation(DataIdentifier id) {
        if (id != null) {
            this.filename = id.getFilename();
            this.beginLine = id.getBeginLine();
            this.endLine = id.getEndLine();
            this.beginCol = id.getBeginColumn();
            this.endCol = id.getEndColumn();
        }
    }

    public void setLocation(Instruction oldInst) {
        if (oldInst != null) {
            this.filename = oldInst.filename;
            this.beginLine = oldInst.beginLine;
            this.endLine = oldInst.endLine;
            this.beginCol = oldInst.beginCol;
            this.endCol = oldInst.endCol;
        }
    }

    public int getLineNum() {
        return this.beginLine;
    }

    public void setInstID(long id) {
        this.instID = id;
    }

    public long getInstID() {
        return this.instID;
    }

    public void printMe() {
        LOG.debug((Object)this.instString);
    }

    public String toString() {
        return this.instString;
    }

    public String getGraphString() {
        return null;
    }

    public String getOpcode() {
        return this.instOpcode;
    }

    public String getExtendedOpcode() {
        if (this.extendedOpcode != null) {
            return this.extendedOpcode;
        }
        if (DMLScript.FINEGRAINED_STATISTICS) {
            String scriptInfo = this.filename != null ? " [" + this.filename + " " + this.beginLine + ":" + this.beginCol + "-" + this.endLine + ":" + this.endCol + "]" : " [" + this.beginLine + ":" + this.beginCol + "-" + this.endLine + ":" + this.endCol + "]";
            this.extendedOpcode = this.type == INSTRUCTION_TYPE.SPARK ? SP_INST_PREFIX + this.getOpcode() + scriptInfo : (this.type == INSTRUCTION_TYPE.GPU ? GPU_INST_PREFIX + this.getOpcode() + scriptInfo : this.getOpcode() + scriptInfo);
        } else {
            this.extendedOpcode = this.type == INSTRUCTION_TYPE.SPARK ? SP_INST_PREFIX + this.getOpcode() : (this.type == INSTRUCTION_TYPE.GPU ? GPU_INST_PREFIX + this.getOpcode() : this.getOpcode());
        }
        return this.extendedOpcode;
    }

    public boolean requiresLabelUpdate() {
        return this.instString.contains("\u00b6");
    }

    public void updateInstructionThreadID(String pattern, String replace) throws DMLRuntimeException {
    }

    public Instruction preprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        ec.updateDebugState(this);
        return this;
    }

    public abstract void processInstruction(ExecutionContext var1) throws DMLRuntimeException;

    public void postprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
    }

    public static enum INSTRUCTION_TYPE {
        CONTROL_PROGRAM,
        MAPREDUCE,
        MAPREDUCE_JOB,
        BREAKPOINT,
        SPARK,
        GPU;

    }
}

