/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.compress.ColGroupDDC;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.compress.utils.ConverterUtils;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;

public class ColGroupDDC2
extends ColGroupDDC {
    private static final long serialVersionUID = -3995768285207071013L;
    private static final int MAX_TMP_VALS = 32768;
    private char[] _data;

    public ColGroupDDC2() {
    }

    public ColGroupDDC2(int[] colIndices, int numRows, UncompressedBitmap ubm) {
        super(colIndices, numRows, ubm);
        this._data = new char[numRows];
        int numVals = ubm.getNumValues();
        int numCols = ubm.getNumColumns();
        if (ubm.getNumOffsets() < (long)numRows * (long)numCols) {
            int zeroIx = this.containsAllZeroValue();
            if (zeroIx < 0) {
                zeroIx = numVals;
                this._values = Arrays.copyOf(this._values, this._values.length + numCols);
            }
            Arrays.fill(this._data, (char)zeroIx);
        }
        for (int i = 0; i < numVals; ++i) {
            int[] tmpList = ubm.getOffsetsList(i).extractValues();
            int tmpListSize = ubm.getNumOffsets(i);
            for (int k = 0; k < tmpListSize; ++k) {
                this._data[tmpList[k]] = (char)i;
            }
        }
    }

    public ColGroupDDC2(int[] colIndices, int numRows, double[] values, char[] data) {
        super(colIndices, numRows, values);
        this._data = data;
    }

    @Override
    public ColGroup.CompressionType getCompType() {
        return ColGroup.CompressionType.DDC2;
    }

    @Override
    protected double getData(int r, int colIx) {
        return this._values[this._data[r] * this.getNumCols() + colIx];
    }

    @Override
    protected void setData(int r, int code) {
        this._data[r] = (char)code;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        out.writeInt(this._numRows);
        out.writeInt(numCols);
        out.writeInt(numVals);
        for (i = 0; i < this._colIndexes.length; ++i) {
            out.writeInt(this._colIndexes[i]);
        }
        for (i = 0; i < this._values.length; ++i) {
            out.writeDouble(this._values[i]);
        }
        for (i = 0; i < this._numRows; ++i) {
            out.writeChar(this._data[i]);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        this._numRows = in.readInt();
        int numCols = in.readInt();
        int numVals = in.readInt();
        this._colIndexes = new int[numCols];
        for (i = 0; i < numCols; ++i) {
            this._colIndexes[i] = in.readInt();
        }
        this._values = new double[numVals * numCols];
        for (i = 0; i < numVals * numCols; ++i) {
            this._values[i] = in.readDouble();
        }
        this._data = new char[this._numRows];
        for (i = 0; i < this._numRows; ++i) {
            this._data[i] = in.readChar();
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = 12L;
        ret += (long)(4 * this._colIndexes.length);
        ret += (long)(8 * this._values.length);
        return ret += (long)(2 * this._data.length);
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        if (this._data != null) {
            size += (long)(2 * this._data.length);
        }
        return size;
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        int ncol = this.getNumCols();
        for (int i = rl; i < ru; ++i) {
            for (int j = 0; j < ncol; ++j) {
                target.appendValue(i, this._colIndexes[j], this._values[this._data[i] * ncol + j]);
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int nrow = this.getNumRows();
        int ncol = this.getNumCols();
        double[] c = target.getDenseBlock();
        int nnz = 0;
        for (int i = 0; i < nrow; ++i) {
            c[i] = this._values[this._data[i] * ncol + colpos];
            nnz += c[i] != 0.0 ? 1 : 0;
        }
        target.setNonZeros(nnz);
    }

    @Override
    public int[] getCounts() {
        return this.getCounts(0, this.getNumRows());
    }

    @Override
    public int[] getCounts(int rl, int ru) {
        int numVals = this.getNumValues();
        int[] counts = new int[numVals];
        for (int i = rl; i < ru; ++i) {
            char c = this._data[i];
            counts[c] = counts[c] + 1;
        }
        return counts;
    }

    @Override
    protected void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int ncol = this.getNumCols();
        int numVals = this.getNumValues();
        int[] counts = new int[numVals];
        int k = 0;
        int valOff = 0;
        while (k < numVals) {
            for (int j = 0; j < ncol; ++j) {
                int n = k;
                counts[n] = counts[n] + (this._values[valOff + j] != 0.0 ? 1 : 0);
            }
            ++k;
            valOff += ncol;
        }
        for (int i = rl; i < ru; ++i) {
            int n = i - rl;
            rnnz[n] = rnnz[n] + counts[this._data[i]];
        }
    }

    @Override
    public void rightMultByVector(MatrixBlock vector, MatrixBlock result, int rl, int ru) throws DMLRuntimeException {
        double[] b = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlock();
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] sb = new double[numCols];
        for (int j = 0; j < numCols; ++j) {
            sb[j] = b[this._colIndexes[j]];
        }
        double[] vals = this.preaggValues(numVals, sb);
        for (int i = rl; i < ru; ++i) {
            int n = i;
            c[n] = c[n] + vals[this._data[i]];
        }
    }

    @Override
    public void leftMultByRowVector(MatrixBlock vector, MatrixBlock result) throws DMLRuntimeException {
        double[] a = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlock();
        int nrow = this.getNumRows();
        int ncol = this.getNumCols();
        int numVals = this.getNumValues();
        if (8 * numVals < this.getNumRows()) {
            double[] vals = ColGroupDDC2.allocDVector(numVals, true);
            for (int i = 0; i < nrow; ++i) {
                char c2 = this._data[i];
                vals[c2] = vals[c2] + a[i];
            }
            this.postScaling(vals, c);
        } else {
            for (int i = 0; i < nrow; ++i) {
                double aval = a[i];
                if (aval == 0.0) continue;
                int valOff = this._data[i] * ncol;
                for (int j = 0; j < ncol; ++j) {
                    int n = this._colIndexes[j];
                    c[n] = c[n] + aval * this._values[valOff + j];
                }
            }
        }
    }

    @Override
    public void leftMultByRowVector(ColGroupDDC a, MatrixBlock result) throws DMLRuntimeException {
        double[] c = result.getDenseBlock();
        int nrow = this.getNumRows();
        int ncol = this.getNumCols();
        int numVals = this.getNumValues();
        if (8 * numVals < this.getNumRows()) {
            double[] vals = ColGroupDDC2.allocDVector(numVals, true);
            for (int i = 0; i < nrow; ++i) {
                char c2 = this._data[i];
                vals[c2] = vals[c2] + a.getData(i, 0);
            }
            this.postScaling(vals, c);
        } else {
            for (int i = 0; i < nrow; ++i) {
                double aval = a.getData(i, 0);
                if (aval == 0.0) continue;
                int valOff = this._data[i] * ncol;
                for (int j = 0; j < ncol; ++j) {
                    int n = this._colIndexes[j];
                    c[n] = c[n] + aval * this._values[valOff + j];
                }
            }
        }
    }

    @Override
    protected void computeSum(MatrixBlock result, KahanFunction kplus) {
        int ncol = this.getNumCols();
        int numVals = this.getNumValues();
        if (numVals < 32768) {
            int[] counts = this.getCounts();
            KahanObject kbuff = new KahanObject(result.quickGetValue(0, 0), result.quickGetValue(0, 1));
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                int cntk = counts[k];
                for (int j = 0; j < ncol; ++j) {
                    kplus.execute3(kbuff, this._values[valOff + j], cntk);
                }
                ++k;
                valOff += ncol;
            }
            result.quickSetValue(0, 0, kbuff._sum);
            result.quickSetValue(0, 1, kbuff._correction);
        } else {
            super.computeSum(result, kplus);
        }
    }

    @Override
    protected void computeRowSums(MatrixBlock result, KahanFunction kplus, int rl, int ru) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanPlus kplus2 = KahanPlus.getKahanPlusFnObject();
        double[] c = result.getDenseBlock();
        double[] vals = this.sumAllValues(kplus, kbuff, false);
        for (int i = rl; i < ru; ++i) {
            kbuff.set(c[2 * i], c[2 * i + 1]);
            kplus2.execute2(kbuff, vals[this._data[i]]);
            c[2 * i] = kbuff._sum;
            c[2 * i + 1] = kbuff._correction;
        }
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) throws DMLRuntimeException {
        return new ColGroupDDC2(this._colIndexes, this._numRows, this.applyScalarOp(op), this._data);
    }
}

