/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.BooleanIdentifier;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.MultiAssignmentStatement;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;
import org.apache.wink.json4j.JSONObject;

public class ParameterizedBuiltinFunctionExpression
extends DataIdentifier {
    private Expression.ParameterizedBuiltinFunctionOp _opcode;
    private HashMap<String, Expression> _varParams;
    public static final String TF_FN_PARAM_DATA = "target";
    public static final String TF_FN_PARAM_MTD2 = "meta";
    public static final String TF_FN_PARAM_SPEC = "spec";
    public static final String TF_FN_PARAM_MTD = "transformPath";
    private static HashMap<String, Expression.ParameterizedBuiltinFunctionOp> opcodeMap = new HashMap();
    public static HashMap<Expression.ParameterizedBuiltinFunctionOp, Hop.ParamBuiltinOp> pbHopMap;

    public static ParameterizedBuiltinFunctionExpression getParamBuiltinFunctionExpression(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExprsPassed, String fileName) {
        if (functionName == null || paramExprsPassed == null) {
            return null;
        }
        Expression.ParameterizedBuiltinFunctionOp pbifop = opcodeMap.get(functionName);
        if (pbifop == null) {
            return null;
        }
        HashMap<String, Expression> varParams = new HashMap<String, Expression>();
        for (ParameterExpression pexpr : paramExprsPassed) {
            varParams.put(pexpr.getName(), pexpr.getExpr());
        }
        ParameterizedBuiltinFunctionExpression retVal = new ParameterizedBuiltinFunctionExpression(ctx, pbifop, varParams, fileName);
        return retVal;
    }

    public ParameterizedBuiltinFunctionExpression(ParserRuleContext ctx, Expression.ParameterizedBuiltinFunctionOp op, HashMap<String, Expression> varParams, String filename) {
        this._opcode = op;
        this._varParams = varParams;
        this.setCtxValuesAndFilename(ctx, filename);
    }

    public ParameterizedBuiltinFunctionExpression(Expression.ParameterizedBuiltinFunctionOp op, HashMap<String, Expression> varParams, ParseInfo parseInfo) {
        this._opcode = op;
        this._varParams = varParams;
        this.setParseInfo(parseInfo);
    }

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        HashMap<String, Expression> newVarParams = new HashMap<String, Expression>();
        for (String key : this._varParams.keySet()) {
            Expression newExpr = this._varParams.get(key).rewriteExpression(prefix);
            newVarParams.put(key, newExpr);
        }
        ParameterizedBuiltinFunctionExpression retVal = new ParameterizedBuiltinFunctionExpression(this._opcode, newVarParams, this);
        return retVal;
    }

    public void setOpcode(Expression.ParameterizedBuiltinFunctionOp op) {
        this._opcode = op;
    }

    public Expression.ParameterizedBuiltinFunctionOp getOpCode() {
        return this._opcode;
    }

    public HashMap<String, Expression> getVarParams() {
        return this._varParams;
    }

    public Expression getVarParam(String name) {
        return this._varParams.get(name);
    }

    public void addVarParam(String name, Expression value) {
        this._varParams.put(name, value);
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        for (String s : this.getVarParams().keySet()) {
            Expression paramExpr = this.getVarParam(s);
            if (paramExpr instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
            }
            paramExpr.validateExpression(ids, constVars, conditional);
        }
        String outputName = ParameterizedBuiltinFunctionExpression.getTempName();
        DataIdentifier output = new DataIdentifier(outputName);
        this.setOutput(output);
        switch (this.getOpCode()) {
            case GROUPEDAGG: {
                this.validateGroupedAgg(output, conditional);
                break;
            }
            case CDF: 
            case INVCDF: 
            case PNORM: 
            case QNORM: 
            case PT: 
            case QT: 
            case PF: 
            case QF: 
            case PCHISQ: 
            case QCHISQ: 
            case PEXP: 
            case QEXP: {
                this.validateDistributionFunctions(output, conditional);
                break;
            }
            case RMEMPTY: {
                this.validateRemoveEmpty(output, conditional);
                break;
            }
            case REPLACE: {
                this.validateReplace(output, conditional);
                break;
            }
            case ORDER: {
                this.validateOrder(output, conditional);
                break;
            }
            case TRANSFORMAPPLY: {
                this.validateTransformApply(output, conditional);
                break;
            }
            case TRANSFORMDECODE: {
                this.validateTransformDecode(output, conditional);
                break;
            }
            case TRANSFORMMETA: {
                this.validateTransformMeta(output, conditional);
                break;
            }
            case TOSTRING: {
                this.validateCastAsString(output, conditional);
                break;
            }
            default: {
                if (this.getOpCode() == Expression.ParameterizedBuiltinFunctionOp.TRANSFORMENCODE) {
                    this.raiseValidateError("Parameterized function " + (Object)((Object)this.getOpCode()) + " requires a multi-assignment statement for data and metadata.", false, "Unsupported Expression");
                    break;
                }
                this.raiseValidateError("Unsupported parameterized function " + (Object)((Object)this.getOpCode()), false, "Unsupported Expression");
            }
        }
    }

    @Override
    public void validateExpression(MultiAssignmentStatement stmt, HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        for (String string : this.getVarParams().keySet()) {
            Expression paramExpr = this.getVarParam(string);
            if (paramExpr instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
            }
            paramExpr.validateExpression(ids, constVars, conditional);
        }
        this._outputs = new Identifier[stmt.getTargetList().size()];
        int count = 0;
        for (DataIdentifier outParam : stmt.getTargetList()) {
            DataIdentifier tmp = new DataIdentifier(outParam);
            tmp.setParseInfo(this);
            this._outputs[count++] = tmp;
        }
        switch (this.getOpCode()) {
            case TRANSFORMENCODE: {
                DataIdentifier dataIdentifier = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier out2 = (DataIdentifier)this.getOutputs()[1];
                this.validateTransformEncode(dataIdentifier, out2, conditional);
                break;
            }
            default: {
                this.raiseValidateError("Unsupported parameterized function " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
            }
        }
    }

    private void validateTransformApply(DataIdentifier output, boolean conditional) throws LanguageException {
        this.checkDataType("transformapply", TF_FN_PARAM_DATA, Expression.DataType.FRAME, conditional);
        this.checkDataType("transformapply", TF_FN_PARAM_MTD2, Expression.DataType.FRAME, conditional);
        this.checkDataValueType("transformapply", TF_FN_PARAM_SPEC, Expression.DataType.SCALAR, Expression.ValueType.STRING, conditional);
        this.validateTransformSpec(TF_FN_PARAM_SPEC, conditional);
        output.setDataType(Expression.DataType.MATRIX);
        output.setValueType(Expression.ValueType.DOUBLE);
        output.setDimensions(-1L, -1L);
    }

    private void validateTransformDecode(DataIdentifier output, boolean conditional) throws LanguageException {
        this.checkDataType("transformdecode", TF_FN_PARAM_DATA, Expression.DataType.MATRIX, conditional);
        this.checkDataType("transformdecode", TF_FN_PARAM_MTD2, Expression.DataType.FRAME, conditional);
        this.checkDataValueType("transformdecode", TF_FN_PARAM_SPEC, Expression.DataType.SCALAR, Expression.ValueType.STRING, conditional);
        this.validateTransformSpec(TF_FN_PARAM_SPEC, conditional);
        output.setDataType(Expression.DataType.FRAME);
        output.setValueType(Expression.ValueType.STRING);
        output.setDimensions(-1L, -1L);
    }

    private void validateTransformMeta(DataIdentifier output, boolean conditional) throws LanguageException {
        this.checkDataValueType("transformmeta", TF_FN_PARAM_SPEC, Expression.DataType.SCALAR, Expression.ValueType.STRING, conditional);
        this.validateTransformSpec(TF_FN_PARAM_SPEC, conditional);
        this.checkDataValueType("transformmeta", TF_FN_PARAM_MTD, Expression.DataType.SCALAR, Expression.ValueType.STRING, conditional);
        output.setDataType(Expression.DataType.FRAME);
        output.setValueType(Expression.ValueType.STRING);
        output.setDimensions(-1L, -1L);
    }

    private void validateTransformEncode(DataIdentifier output1, DataIdentifier output2, boolean conditional) throws LanguageException {
        this.checkDataType("transformencode", TF_FN_PARAM_DATA, Expression.DataType.FRAME, conditional);
        this.checkDataValueType("transformencode", TF_FN_PARAM_SPEC, Expression.DataType.SCALAR, Expression.ValueType.STRING, conditional);
        this.validateTransformSpec(TF_FN_PARAM_SPEC, conditional);
        output1.setDataType(Expression.DataType.MATRIX);
        output1.setValueType(Expression.ValueType.DOUBLE);
        output1.setDimensions(-1L, -1L);
        output2.setDataType(Expression.DataType.FRAME);
        output2.setValueType(Expression.ValueType.STRING);
        output2.setDimensions(-1L, -1L);
    }

    private void validateTransformSpec(String pname, boolean conditional) throws LanguageException {
        Expression data = this.getVarParam(pname);
        if (data instanceof StringIdentifier) {
            try {
                StringIdentifier spec = (StringIdentifier)data;
                new JSONObject(spec.getValue());
            }
            catch (Exception ex) {
                this.raiseValidateError("Transform specification parsing issue: ", conditional, ex.getMessage());
            }
        }
    }

    private void validateReplace(DataIdentifier output, boolean conditional) throws LanguageException {
        Expression target = this.getVarParam(TF_FN_PARAM_DATA);
        if (target == null) {
            this.raiseValidateError("Named parameter 'target' missing. Please specify the input matrix.", conditional, "Invalid Parameters");
        } else if (target.getOutput().getDataType() != Expression.DataType.MATRIX) {
            this.raiseValidateError("Input matrix 'target' is of type '" + (Object)((Object)target.getOutput().getDataType()) + "'. Please specify the input matrix.", conditional, "Invalid Parameters");
        }
        Expression pattern = this.getVarParam("pattern");
        if (pattern == null) {
            this.raiseValidateError("Named parameter 'pattern' missing. Please specify the replacement pattern.", conditional, "Invalid Parameters");
        } else if (pattern.getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("Replacement pattern 'pattern' is of type '" + (Object)((Object)pattern.getOutput().getDataType()) + "'. Please, specify a scalar replacement pattern.", conditional, "Invalid Parameters");
        }
        Expression replacement = this.getVarParam("replacement");
        if (replacement == null) {
            this.raiseValidateError("Named parameter 'replacement' missing. Please specify the replacement value.", conditional, "Invalid Parameters");
        } else if (replacement.getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("Replacement value 'replacement' is of type '" + (Object)((Object)replacement.getOutput().getDataType()) + "'. Please, specify a scalar replacement value.", conditional, "Invalid Parameters");
        }
        output.setDataType(Expression.DataType.MATRIX);
        output.setValueType(Expression.ValueType.DOUBLE);
        output.setDimensions(target.getOutput().getDim1(), target.getOutput().getDim2());
    }

    private void validateOrder(DataIdentifier output, boolean conditional) throws LanguageException {
        Expression target = this.getVarParam(TF_FN_PARAM_DATA);
        if (target == null) {
            this.raiseValidateError("Named parameter 'target' missing. Please specify the input matrix.", conditional, "Invalid Parameters");
        } else if (target.getOutput().getDataType() != Expression.DataType.MATRIX) {
            this.raiseValidateError("Input matrix 'target' is of type '" + (Object)((Object)target.getOutput().getDataType()) + "'. Please specify the input matrix.", conditional, "Invalid Parameters");
        }
        for (String param : this.getVarParams().keySet()) {
            if (param.equals(TF_FN_PARAM_DATA) || param.equals("by") || param.equals("decreasing") || param.equals("index.return")) continue;
            this.raiseValidateError("Unsupported order parameter: '" + param + "'", false);
        }
        Expression orderby = this.getVarParam("by");
        if (orderby == null) {
            orderby = new IntIdentifier(1L);
            this.addVarParam("by", orderby);
        } else if (orderby != null && orderby.getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("Orderby column 'by' is of type '" + (Object)((Object)orderby.getOutput().getDataType()) + "'. Please, specify a scalar order by column index.", conditional, "Invalid Parameters");
        }
        Expression decreasing = this.getVarParam("decreasing");
        if (decreasing == null) {
            this.addVarParam("decreasing", new BooleanIdentifier(false));
        } else if (decreasing != null && decreasing.getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("Ordering 'decreasing' is of type '" + (Object)((Object)decreasing.getOutput().getDataType()) + "', '" + (Object)((Object)decreasing.getOutput().getValueType()) + "'. Please, specify 'decreasing' as a scalar boolean.", conditional, "Invalid Parameters");
        }
        Expression indexreturn = this.getVarParam("index.return");
        if (indexreturn == null) {
            indexreturn = new BooleanIdentifier(false);
            this.addVarParam("index.return", indexreturn);
        } else if (indexreturn != null && indexreturn.getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("Return type 'index.return' is of type '" + (Object)((Object)indexreturn.getOutput().getDataType()) + "', '" + (Object)((Object)indexreturn.getOutput().getValueType()) + "'. Please, specify 'indexreturn' as a scalar boolean.", conditional, "Invalid Parameters");
        }
        long dim2 = indexreturn instanceof BooleanIdentifier ? (((BooleanIdentifier)indexreturn).getValue() ? 1L : target.getOutput().getDim2()) : -1L;
        output.setDataType(Expression.DataType.MATRIX);
        output.setValueType(Expression.ValueType.DOUBLE);
        output.setDimensions(target.getOutput().getDim1(), dim2);
    }

    private void validateRemoveEmpty(DataIdentifier output, boolean conditional) throws LanguageException {
        Expression target = this.getVarParam(TF_FN_PARAM_DATA);
        if (target == null) {
            this.raiseValidateError("Named parameter 'target' missing. Please specify the input matrix.", conditional, "Invalid Parameters");
        } else if (target.getOutput().getDataType() != Expression.DataType.MATRIX) {
            this.raiseValidateError("Input matrix 'target' is of type '" + (Object)((Object)target.getOutput().getDataType()) + "'. Please specify the input matrix.", conditional, "Invalid Parameters");
        }
        Expression margin = this.getVarParam("margin");
        if (margin == null) {
            this.raiseValidateError("Named parameter 'margin' missing. Please specify 'rows' or 'cols'.", conditional, "Invalid Parameters");
        } else if (!(margin instanceof DataIdentifier || margin.toString().equals("rows") || margin.toString().equals("cols"))) {
            this.raiseValidateError("Named parameter 'margin' has an invalid value '" + margin.toString() + "'. Please specify 'rows' or 'cols'.", conditional, "Invalid Parameters");
        }
        Expression select = this.getVarParam("select");
        if (select != null && select.getOutput().getDataType() != Expression.DataType.MATRIX) {
            this.raiseValidateError("Index matrix 'select' is of type '" + (Object)((Object)select.getOutput().getDataType()) + "'. Please specify the select matrix.", conditional, "Invalid Parameters");
        }
        output.setDataType(Expression.DataType.MATRIX);
        output.setValueType(Expression.ValueType.DOUBLE);
        output.setDimensions(-1L, -1L);
    }

    private void validateGroupedAgg(DataIdentifier output, boolean conditional) throws LanguageException {
        Identifier numGroups;
        Expression functParam;
        if (this.getVarParam(TF_FN_PARAM_DATA) == null || this.getVarParam("groups") == null) {
            this.raiseValidateError("Must define both target and groups.", conditional);
        }
        Expression exprTarget = this.getVarParam(TF_FN_PARAM_DATA);
        Expression exprGroups = this.getVarParam("groups");
        Expression exprNGroups = this.getVarParam("ngroups");
        boolean colwise = true;
        boolean matrix = false;
        if (exprGroups.getOutput().dimsKnown() && exprTarget.getOutput().dimsKnown()) {
            if (exprGroups.getOutput().getDim2() == 1L && exprTarget.getOutput().getDim2() > 1L) {
                if (this.getVarParam("weights") != null) {
                    this.raiseValidateError("Matrix input not supported with weights.", conditional);
                }
                if (this.getVarParam("ngroups") == null) {
                    this.raiseValidateError("Matrix input not supported without specified numgroups.", conditional);
                }
                if (exprGroups.getOutput().getDim1() != exprTarget.getOutput().getDim1()) {
                    this.raiseValidateError("Target and groups must have same dimensions --  target dims: " + exprTarget.getOutput().getDim1() + " x " + exprTarget.getOutput().getDim2() + ", groups dims: " + exprGroups.getOutput().getDim1() + " x 1.", conditional);
                }
                matrix = true;
            } else if (exprGroups.getOutput().getDim2() == 1L && exprTarget.getOutput().getDim2() == 1L) {
                if (exprGroups.getOutput().getDim1() != exprTarget.getOutput().getDim1()) {
                    this.raiseValidateError("Target and groups must have same dimensions --  target dims: " + exprTarget.getOutput().getDim1() + " x 1, groups dims: " + exprGroups.getOutput().getDim1() + " x 1.", conditional);
                }
            } else if (exprGroups.getOutput().getDim1() == 1L && exprTarget.getOutput().getDim1() == 1L) {
                if (exprGroups.getOutput().getDim2() != exprTarget.getOutput().getDim2()) {
                    this.raiseValidateError("Target and groups must have same dimensions --  target dims: 1 x " + exprTarget.getOutput().getDim2() + ", groups dims: 1 x " + exprGroups.getOutput().getDim2() + ".", conditional);
                }
                colwise = true;
            } else {
                this.raiseValidateError("Invalid target and groups inputs - dimension mismatch.", conditional);
            }
        }
        if ((functParam = this.getVarParam("fn")) == null) {
            this.raiseValidateError("must define function name (fn=<function name>) for aggregate()", conditional);
        } else if (functParam instanceof Identifier) {
            String fnameStr = functParam.toString();
            if (fnameStr.equals("centralmoment")) {
                String orderStr;
                String string = orderStr = this.getVarParam("order") == null ? null : this.getVarParam("order").toString();
                if (orderStr == null || !orderStr.equals("2") && !orderStr.equals("3") && !orderStr.equals("4")) {
                    this.raiseValidateError("for centralmoment, must define order.  Order must be equal to 2,3, or 4", conditional);
                }
            } else if (!(fnameStr.equals("count") || fnameStr.equals("sum") || fnameStr.equals("mean") || fnameStr.equals("variance"))) {
                this.raiseValidateError("fname is " + fnameStr + " but must be either centeralmoment, count, sum, mean, variance", conditional);
            }
        }
        long outputDim1 = -1L;
        long outputDim2 = -1L;
        if (exprNGroups != null && exprNGroups instanceof Identifier && (numGroups = (Identifier)exprNGroups) != null && numGroups instanceof ConstIdentifier) {
            long ngroups = ((ConstIdentifier)numGroups).getLongValue();
            if (colwise) {
                outputDim1 = ngroups;
                outputDim2 = matrix ? exprTarget.getOutput().getDim2() : 1L;
            } else {
                outputDim1 = 1L;
                outputDim2 = ngroups;
            }
        }
        output.setDataType(Expression.DataType.MATRIX);
        output.setValueType(Expression.ValueType.DOUBLE);
        output.setDimensions(outputDim1, outputDim2);
    }

    private void validateDistributionFunctions(DataIdentifier output, boolean conditional) throws LanguageException {
        Expression.ParameterizedBuiltinFunctionOp op = this.getOpCode();
        if (this.getVarParam(TF_FN_PARAM_DATA) == null || this.getVarParam(TF_FN_PARAM_DATA).getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("target must be provided for distribution functions, and it must be a scalar value.", conditional, "Invalid Parameters");
        }
        switch (op) {
            case CDF: 
            case INVCDF: {
                if (this.getVarParam("dist") != null) break;
                this.raiseValidateError("For cdf() and icdf(), a distribution function must be specified (as a string).", conditional, "Invalid Parameters");
                break;
            }
            case PF: 
            case QF: {
                if (this.getVarParam("df1") != null && this.getVarParam("df2") != null) break;
                this.raiseValidateError("Two degrees of freedom df1 and df2 must be provided for F-distribution.", conditional, "Invalid Parameters");
                break;
            }
            case PT: 
            case QT: {
                if (this.getVarParam("df") != null) break;
                this.raiseValidateError("Degrees of freedom df must be provided for t-distribution.", conditional, "Invalid Parameters");
                break;
            }
            case PCHISQ: 
            case QCHISQ: {
                if (this.getVarParam("df") != null) break;
                this.raiseValidateError("Degrees of freedom df must be provided for chi-squared-distribution.", conditional, "Invalid Parameters");
                break;
            }
        }
        switch (op) {
            case INVCDF: 
            case QNORM: 
            case QT: 
            case QF: 
            case QCHISQ: 
            case QEXP: {
                if (this.getVarParam("lower.tail") == null) break;
                this.raiseValidateError("Lower tail argument is invalid while computing inverse cumulative probabilities.", conditional, "Invalid Parameters");
                break;
            }
            case CDF: 
            case PNORM: 
            case PT: 
            case PF: 
            case PCHISQ: 
            case PEXP: {
                break;
            }
        }
        output.setDataType(Expression.DataType.SCALAR);
        output.setValueType(Expression.ValueType.DOUBLE);
        output.setDimensions(0L, 0L);
    }

    private void validateCastAsString(DataIdentifier output, boolean conditional) throws LanguageException {
        HashMap<String, Expression> varParams = this.getVarParams();
        if (varParams.containsKey(null)) {
            varParams.put(TF_FN_PARAM_DATA, varParams.remove(null));
        }
        Object[] validArgsArr = new String[]{TF_FN_PARAM_DATA, "rows", "cols", "decimal", "sparse", "sep", "linesep"};
        HashSet<String> validArgs = new HashSet<String>(Arrays.asList(validArgsArr));
        for (String k : varParams.keySet()) {
            if (validArgs.contains(k)) continue;
            this.raiseValidateError("Invalid parameter " + k + " for toString, valid parameters are " + Arrays.toString(validArgsArr), conditional, "Invalid Parameters");
        }
        output.setDataType(Expression.DataType.SCALAR);
        output.setValueType(Expression.ValueType.STRING);
        output.setDimensions(0L, 0L);
    }

    private void checkDataType(String fname, String pname, Expression.DataType dt, boolean conditional) throws LanguageException {
        Expression data = this.getVarParam(pname);
        if (data == null) {
            this.raiseValidateError("Named parameter '" + pname + "' missing. Please specify the input.", conditional, "Invalid Parameters");
        } else if (data.getOutput().getDataType() != dt) {
            this.raiseValidateError("Input to " + fname + "::" + pname + " must be of type '" + dt.toString() + "'. It is of type '" + (Object)((Object)data.getOutput().getDataType()) + "'.", conditional, "Invalid Parameters");
        }
    }

    private void checkDataValueType(String fname, String pname, Expression.DataType dt, Expression.ValueType vt, boolean conditional) throws LanguageException {
        Expression data = this.getVarParam(pname);
        if (data == null) {
            this.raiseValidateError("Named parameter '" + pname + "' missing. Please specify the input.", conditional, "Invalid Parameters");
        } else if (data.getOutput().getDataType() != dt || data.getOutput().getValueType() != vt) {
            this.raiseValidateError("Input to " + fname + "::" + pname + " must be of type '" + dt.toString() + "', '" + vt.toString() + "'. It is of type '" + data.getOutput().getDataType().toString() + "', '" + data.getOutput().getValueType().toString() + "'.", conditional, "Invalid Parameters");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._opcode.toString() + "(");
        for (String key : this._varParams.keySet()) {
            sb.append("," + key + "=" + this._varParams.get(key));
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        for (String s : this._varParams.keySet()) {
            result.addVariables(this._varParams.get(s).variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (String s : this._varParams.keySet()) {
            result.addVariables(this._varParams.get(s).variablesUpdated());
        }
        result.addVariable(((DataIdentifier)this.getOutput()).getName(), (DataIdentifier)this.getOutput());
        return result;
    }

    @Override
    public boolean multipleReturns() {
        return this._opcode == Expression.ParameterizedBuiltinFunctionOp.TRANSFORMENCODE;
    }

    static {
        opcodeMap.put("aggregate", Expression.ParameterizedBuiltinFunctionOp.GROUPEDAGG);
        opcodeMap.put("groupedAggregate", Expression.ParameterizedBuiltinFunctionOp.GROUPEDAGG);
        opcodeMap.put("removeEmpty", Expression.ParameterizedBuiltinFunctionOp.RMEMPTY);
        opcodeMap.put("replace", Expression.ParameterizedBuiltinFunctionOp.REPLACE);
        opcodeMap.put("order", Expression.ParameterizedBuiltinFunctionOp.ORDER);
        opcodeMap.put("cdf", Expression.ParameterizedBuiltinFunctionOp.CDF);
        opcodeMap.put("pnorm", Expression.ParameterizedBuiltinFunctionOp.PNORM);
        opcodeMap.put("pt", Expression.ParameterizedBuiltinFunctionOp.PT);
        opcodeMap.put("pf", Expression.ParameterizedBuiltinFunctionOp.PF);
        opcodeMap.put("pchisq", Expression.ParameterizedBuiltinFunctionOp.PCHISQ);
        opcodeMap.put("pexp", Expression.ParameterizedBuiltinFunctionOp.PEXP);
        opcodeMap.put("icdf", Expression.ParameterizedBuiltinFunctionOp.INVCDF);
        opcodeMap.put("qnorm", Expression.ParameterizedBuiltinFunctionOp.QNORM);
        opcodeMap.put("qt", Expression.ParameterizedBuiltinFunctionOp.QT);
        opcodeMap.put("qf", Expression.ParameterizedBuiltinFunctionOp.QF);
        opcodeMap.put("qchisq", Expression.ParameterizedBuiltinFunctionOp.QCHISQ);
        opcodeMap.put("qexp", Expression.ParameterizedBuiltinFunctionOp.QEXP);
        opcodeMap.put("transformapply", Expression.ParameterizedBuiltinFunctionOp.TRANSFORMAPPLY);
        opcodeMap.put("transformdecode", Expression.ParameterizedBuiltinFunctionOp.TRANSFORMDECODE);
        opcodeMap.put("transformencode", Expression.ParameterizedBuiltinFunctionOp.TRANSFORMENCODE);
        opcodeMap.put("transformmeta", Expression.ParameterizedBuiltinFunctionOp.TRANSFORMMETA);
        opcodeMap.put("toString", Expression.ParameterizedBuiltinFunctionOp.TOSTRING);
        pbHopMap = new HashMap();
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.GROUPEDAGG, Hop.ParamBuiltinOp.GROUPEDAGG);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.RMEMPTY, Hop.ParamBuiltinOp.RMEMPTY);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.REPLACE, Hop.ParamBuiltinOp.REPLACE);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.ORDER, Hop.ParamBuiltinOp.INVALID);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.CDF, Hop.ParamBuiltinOp.CDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.PNORM, Hop.ParamBuiltinOp.CDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.PT, Hop.ParamBuiltinOp.CDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.PF, Hop.ParamBuiltinOp.CDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.PCHISQ, Hop.ParamBuiltinOp.CDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.PEXP, Hop.ParamBuiltinOp.CDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.INVCDF, Hop.ParamBuiltinOp.INVCDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.QNORM, Hop.ParamBuiltinOp.INVCDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.QT, Hop.ParamBuiltinOp.INVCDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.QF, Hop.ParamBuiltinOp.INVCDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.QCHISQ, Hop.ParamBuiltinOp.INVCDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.QEXP, Hop.ParamBuiltinOp.INVCDF);
        pbHopMap.put(Expression.ParameterizedBuiltinFunctionOp.TOSTRING, Hop.ParamBuiltinOp.TOSTRING);
    }
}

