/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class GPUStatistics {
    public static boolean DISPLAY_STATISTICS = false;
    private static int iNoOfExecutedGPUInst = 0;
    public static long cudaInitTime = 0L;
    public static long cudaLibrariesInitTime = 0L;
    public static AtomicLong cudaSparseToDenseTime = new AtomicLong(0L);
    public static AtomicLong cudaDenseToSparseTime = new AtomicLong(0L);
    public static AtomicLong cudaSparseConversionTime = new AtomicLong(0L);
    public static AtomicLong cudaSparseToDenseCount = new AtomicLong(0L);
    public static AtomicLong cudaDenseToSparseCount = new AtomicLong(0L);
    public static AtomicLong cudaSparseConversionCount = new AtomicLong(0L);
    public static AtomicLong cudaAllocTime = new AtomicLong(0L);
    public static AtomicLong cudaDeAllocTime = new AtomicLong(0L);
    public static AtomicLong cudaMemSet0Time = new AtomicLong(0L);
    public static AtomicLong cudaToDevTime = new AtomicLong(0L);
    public static AtomicLong cudaFromDevTime = new AtomicLong(0L);
    public static AtomicLong cudaAllocCount = new AtomicLong(0L);
    public static AtomicLong cudaDeAllocCount = new AtomicLong(0L);
    public static AtomicLong cudaMemSet0Count = new AtomicLong(0L);
    public static AtomicLong cudaToDevCount = new AtomicLong(0L);
    public static AtomicLong cudaFromDevCount = new AtomicLong(0L);
    public static AtomicLong cudaEvictionCount = new AtomicLong(0L);
    private static HashMap<String, HashMap<String, Long>> _cpInstMiscTime = new HashMap();
    private static HashMap<String, HashMap<String, Long>> _cpInstMiscCount = new HashMap();

    public static void resetMiscTimers() {
        _cpInstMiscTime.clear();
        _cpInstMiscCount.clear();
    }

    public static void reset() {
        cudaInitTime = 0L;
        cudaLibrariesInitTime = 0L;
        cudaAllocTime.set(0L);
        cudaDeAllocTime.set(0L);
        cudaMemSet0Time.set(0L);
        cudaMemSet0Count.set(0L);
        cudaToDevTime.set(0L);
        cudaFromDevTime.set(0L);
        cudaAllocCount.set(0L);
        cudaDeAllocCount.set(0L);
        cudaToDevCount.set(0L);
        cudaFromDevCount.set(0L);
        cudaEvictionCount.set(0L);
        GPUStatistics.resetMiscTimers();
    }

    public static synchronized void setNoOfExecutedGPUInst(int numJobs) {
        iNoOfExecutedGPUInst = numJobs;
    }

    public static synchronized void incrementNoOfExecutedGPUInst() {
        ++iNoOfExecutedGPUInst;
    }

    public static synchronized int getNoOfExecutedGPUInst() {
        return iNoOfExecutedGPUInst;
    }

    public static synchronized void maintainCPMiscTimes(String instructionName, String miscTimer, long timeNanos, long incrementCount) {
        Long oldCnt;
        Long oldVal;
        if (!DISPLAY_STATISTICS) {
            return;
        }
        HashMap<String, Long> miscTimesMap = _cpInstMiscTime.get(instructionName);
        if (miscTimesMap == null) {
            miscTimesMap = new HashMap();
            _cpInstMiscTime.put(instructionName, miscTimesMap);
        }
        Long newVal = timeNanos + ((oldVal = miscTimesMap.get(miscTimer)) != null ? oldVal : 0L);
        miscTimesMap.put(miscTimer, newVal);
        HashMap<String, Long> miscCountMap = _cpInstMiscCount.get(instructionName);
        if (miscCountMap == null) {
            miscCountMap = new HashMap();
            _cpInstMiscCount.put(instructionName, miscCountMap);
        }
        Long newCnt = incrementCount + ((oldCnt = miscCountMap.get(miscTimer)) != null ? oldCnt : 0L);
        miscCountMap.put(miscTimer, newCnt);
    }

    public static synchronized void maintainCPMiscTimes(String instructionName, String miscTimer, long timeNanos) {
        GPUStatistics.maintainCPMiscTimes(instructionName, miscTimer, timeNanos, 1L);
    }

    public static String getStringForCPMiscTimesPerInstruction(String instructionName) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, Long> miscTimerMap = _cpInstMiscTime.get(instructionName);
        if (miscTimerMap != null) {
            ArrayList<Map.Entry<String, Long>> sortedList = new ArrayList<Map.Entry<String, Long>>(miscTimerMap.entrySet());
            Collections.sort(sortedList, new Comparator<Map.Entry<String, Long>>(){

                @Override
                public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                    return (int)(o1.getValue() - o2.getValue());
                }
            });
            Iterator miscTimeIter = sortedList.iterator();
            HashMap<String, Long> miscCountMap = _cpInstMiscCount.get(instructionName);
            while (miscTimeIter.hasNext()) {
                Map.Entry e = (Map.Entry)miscTimeIter.next();
                String miscTimerName = (String)e.getKey();
                Long miscTimerTime = (Long)e.getValue();
                Long miscCount = miscCountMap.get(miscTimerName);
                sb.append(miscTimerName + "[" + String.format("%.3f", (double)miscTimerTime.longValue() / 1.0E9) + "s," + miscCount + "]");
                if (!miscTimeIter.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static String getStringForCudaTimers() {
        StringBuffer sb = new StringBuffer();
        sb.append("CUDA/CuLibraries init time:\t" + String.format("%.3f", (double)cudaInitTime * 1.0E-9) + "/" + String.format("%.3f", (double)cudaLibrariesInitTime * 1.0E-9) + " sec.\n");
        sb.append("Number of executed GPU inst:\t" + GPUStatistics.getNoOfExecutedGPUInst() + ".\n");
        sb.append("GPU mem tx time  (alloc/dealloc/set0/toDev/fromDev):\t" + String.format("%.3f", (double)cudaAllocTime.get() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaDeAllocTime.get() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaMemSet0Time.get() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaToDevTime.get() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaFromDevTime.get() * 1.0E-9) + " sec.\n");
        sb.append("GPU mem tx count (alloc/dealloc/set0/toDev/fromDev/evict):\t" + cudaAllocCount.get() + "/" + cudaDeAllocCount.get() + "/" + cudaMemSet0Count.get() + "/" + cudaSparseConversionCount.get() + "/" + cudaToDevCount.get() + "/" + cudaFromDevCount.get() + "/" + cudaEvictionCount.get() + ".\n");
        sb.append("GPU conversion time  (sparseConv/sp2dense/dense2sp):\t" + String.format("%.3f", (double)cudaSparseConversionTime.get() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaSparseToDenseTime.get() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaDenseToSparseTime.get() * 1.0E-9) + " sec.\n");
        sb.append("GPU conversion count (sparseConv/sp2dense/dense2sp):\t" + cudaSparseConversionCount.get() + "/" + cudaSparseToDenseCount.get() + "/" + cudaDenseToSparseCount.get() + ".\n");
        return sb.toString();
    }
}

