/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;

@Deprecated
public class RemoveEmptyRows
extends PackageFunction {
    private static final long serialVersionUID = 1L;
    private static final String OUTPUT_FILE = "TMP";
    private Matrix _ret;

    @Override
    public int getNumFunctionOutputs() {
        return 1;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        return this._ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Matrix mat = (Matrix)this.getFunctionInput(0);
        String fnameOld = mat.getFilePath();
        HashMap<Long, Long> keyMap = new HashMap<Long, Long>();
        try {
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(fnameOld);
            FileSystem fs = FileSystem.get((Configuration)job);
            if (!fs.exists(path)) {
                throw new IOException("File " + fnameOld + " does not exist on HDFS.");
            }
            FileInputFormat.addInputPath((JobConf)job, (Path)path);
            TextInputFormat informat = new TextInputFormat();
            informat.configure(job);
            String fnameNew = this.createOutputFilePathAndName(OUTPUT_FILE);
            FSDataOutputStream ostream = MapReduceTool.getHDFSDataOutputStream(fnameNew, true);
            InputSplit[] splits = informat.getSplits(job, 1);
            LongWritable key = new LongWritable();
            Text value = new Text();
            long ID = 1L;
            try {
                StringBuilder sb = new StringBuilder();
                for (InputSplit split : splits) {
                    try (RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);){
                        while (reader.next((Object)key, (Object)value)) {
                            String cellStr = value.toString().trim();
                            StringTokenizer st = new StringTokenizer(cellStr, " ");
                            long row = Integer.parseInt(st.nextToken());
                            long col = Integer.parseInt(st.nextToken());
                            double lvalue = Double.parseDouble(st.nextToken());
                            if (!keyMap.containsKey(row)) {
                                keyMap.put(row, ID++);
                            }
                            long rowNew = (Long)keyMap.get(row);
                            sb.append(rowNew);
                            sb.append(' ');
                            sb.append(col);
                            sb.append(' ');
                            sb.append(lvalue);
                            sb.append('\n');
                            ostream.writeBytes(sb.toString());
                            sb.setLength(0);
                        }
                    }
                }
                this._ret = new Matrix(fnameNew, keyMap.size(), mat.getNumCols(), Matrix.ValueType.Double);
            }
            finally {
                if (ostream != null) {
                    ostream.close();
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to execute external function.", ex);
        }
    }
}

