/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

import java.util.Arrays;
import java.util.Random;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;

public class SortUtils {
    public static boolean isSorted(int start, int end, int[] indexes) {
        boolean ret = true;
        for (int i = start + 1; i < end; ++i) {
            if (indexes[i] >= indexes[i - 1]) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean isSorted(int iStart, int iEnd, double[] dVals) {
        boolean ret = true;
        for (int i = iStart + 1; i < iEnd; ++i) {
            if (!(dVals[i] < dVals[i - 1])) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static void sortByIndex(int start, int end, int[] indexes, double[] values) {
        double tempVal;
        int tempIx;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && indexes[j - 1] > indexes[j]; --j) {
                    int tempIx2 = indexes[j];
                    indexes[j] = indexes[j - 1];
                    indexes[j - 1] = tempIx2;
                    double tempVal2 = values[j];
                    values[j] = values[j - 1];
                    values[j - 1] = tempVal2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = SortUtils.med3(indexes, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = SortUtils.med3(indexes, middle - length, middle, middle + length);
                top = SortUtils.med3(indexes, top - 2 * length, top - length, top);
            }
            middle = SortUtils.med3(indexes, bottom, middle, top);
        }
        int partionValue = indexes[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && indexes[b] <= partionValue) {
                if (indexes[b] == partionValue) {
                    tempIx = indexes[a];
                    indexes[a] = indexes[b];
                    indexes[b] = tempIx;
                    tempVal = values[a];
                    values[a++] = values[b];
                    values[b] = tempVal;
                }
                ++b;
                continue;
            }
            while (c >= b && indexes[c] >= partionValue) {
                if (indexes[c] == partionValue) {
                    tempIx = indexes[c];
                    indexes[c] = indexes[d];
                    indexes[d] = tempIx;
                    tempVal = values[c];
                    values[c] = values[d];
                    values[d--] = tempVal;
                }
                --c;
            }
            if (b > c) break;
            tempIx = indexes[b];
            indexes[b] = indexes[c];
            indexes[c] = tempIx;
            tempVal = values[b];
            values[b++] = values[c];
            values[c--] = tempVal;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            tempIx = indexes[l];
            indexes[l] = indexes[h];
            indexes[h] = tempIx;
            tempVal = values[l];
            values[l++] = values[h];
            values[h++] = tempVal;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            tempIx = indexes[l];
            indexes[l] = indexes[h];
            indexes[h] = tempIx;
            tempVal = values[l];
            values[l++] = values[h];
            values[h++] = tempVal;
        }
        length = b - a;
        if (length > 0) {
            SortUtils.sortByIndex(start, start + length, indexes, values);
        }
        if ((length = d - c) > 0) {
            SortUtils.sortByIndex(end - length, end, indexes, values);
        }
    }

    public static void sortByIndex(int start, int end, int[] indexes, int[] indexes2, double[] values) {
        double tempVal;
        int tempIx2;
        int tempIx;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && indexes[j - 1] > indexes[j]; --j) {
                    int tempIx3 = indexes[j];
                    indexes[j] = indexes[j - 1];
                    indexes[j - 1] = tempIx3;
                    int tempIx22 = indexes2[j];
                    indexes2[j] = indexes2[j - 1];
                    indexes2[j - 1] = tempIx22;
                    double tempVal2 = values[j];
                    values[j] = values[j - 1];
                    values[j - 1] = tempVal2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = SortUtils.med3(indexes, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = SortUtils.med3(indexes, middle - length, middle, middle + length);
                top = SortUtils.med3(indexes, top - 2 * length, top - length, top);
            }
            middle = SortUtils.med3(indexes, bottom, middle, top);
        }
        int partionValue = indexes[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && indexes[b] <= partionValue) {
                if (indexes[b] == partionValue) {
                    tempIx = indexes[a];
                    indexes[a] = indexes[b];
                    indexes[b] = tempIx;
                    tempIx2 = indexes2[a];
                    indexes2[a] = indexes2[b];
                    indexes2[b] = tempIx2;
                    tempVal = values[a];
                    values[a++] = values[b];
                    values[b] = tempVal;
                }
                ++b;
                continue;
            }
            while (c >= b && indexes[c] >= partionValue) {
                if (indexes[c] == partionValue) {
                    tempIx = indexes[c];
                    indexes[c] = indexes[d];
                    indexes[d] = tempIx;
                    tempIx2 = indexes2[c];
                    indexes2[c] = indexes2[d];
                    indexes2[d] = tempIx2;
                    tempVal = values[c];
                    values[c] = values[d];
                    values[d--] = tempVal;
                }
                --c;
            }
            if (b > c) break;
            tempIx = indexes[b];
            indexes[b] = indexes[c];
            indexes[c] = tempIx;
            tempIx2 = indexes2[b];
            indexes2[b] = indexes2[c];
            indexes2[c] = tempIx2;
            tempVal = values[b];
            values[b++] = values[c];
            values[c--] = tempVal;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            tempIx = indexes[l];
            indexes[l] = indexes[h];
            indexes[h] = tempIx;
            tempIx2 = indexes2[l];
            indexes2[l] = indexes2[h];
            indexes2[h] = tempIx2;
            tempVal = values[l];
            values[l++] = values[h];
            values[h++] = tempVal;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            tempIx = indexes[l];
            indexes[l] = indexes[h];
            indexes[h] = tempIx;
            tempIx2 = indexes2[l];
            indexes2[l] = indexes2[h];
            indexes2[h] = tempIx2;
            tempVal = values[l];
            values[l++] = values[h];
            values[h++] = tempVal;
        }
        length = b - a;
        if (length > 0) {
            SortUtils.sortByIndex(start, start + length, indexes, indexes2, values);
        }
        if ((length = d - c) > 0) {
            SortUtils.sortByIndex(end - length, end, indexes, indexes2, values);
        }
    }

    public static void sortByValue(int start, int end, double[] values, int[] indexes) {
        int tempIx;
        double tempVal;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && values[j - 1] > values[j]; --j) {
                    double tempVal2 = values[j];
                    values[j] = values[j - 1];
                    values[j - 1] = tempVal2;
                    int tempIx2 = indexes[j];
                    indexes[j] = indexes[j - 1];
                    indexes[j - 1] = tempIx2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = SortUtils.med3(values, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = SortUtils.med3(values, middle - length, middle, middle + length);
                top = SortUtils.med3(values, top - 2 * length, top - length, top);
            }
            middle = SortUtils.med3(values, bottom, middle, top);
        }
        double partionValue = values[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && values[b] <= partionValue) {
                if (values[b] == partionValue) {
                    tempVal = values[a];
                    values[a] = values[b];
                    values[b] = tempVal;
                    tempIx = indexes[a];
                    indexes[a++] = indexes[b];
                    indexes[b] = tempIx;
                }
                ++b;
                continue;
            }
            while (c >= b && values[c] >= partionValue) {
                if (values[c] == partionValue) {
                    tempVal = values[c];
                    values[c] = values[d];
                    values[d] = tempVal;
                    tempIx = indexes[c];
                    indexes[c] = indexes[d];
                    indexes[d--] = tempIx;
                }
                --c;
            }
            if (b > c) break;
            tempVal = values[b];
            values[b] = values[c];
            values[c] = tempVal;
            tempIx = indexes[b];
            indexes[b++] = indexes[c];
            indexes[c--] = tempIx;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            tempVal = values[l];
            values[l] = values[h];
            values[h] = tempVal;
            tempIx = indexes[l];
            indexes[l++] = indexes[h];
            indexes[h++] = tempIx;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            tempVal = values[l];
            values[l] = values[h];
            values[h] = tempVal;
            tempIx = indexes[l];
            indexes[l++] = indexes[h];
            indexes[h++] = tempIx;
        }
        length = b - a;
        if (length > 0) {
            SortUtils.sortByValue(start, start + length, values, indexes);
        }
        if ((length = d - c) > 0) {
            SortUtils.sortByValue(end - length, end, values, indexes);
        }
    }

    public static void sortByValueStable(int start, int end, double[] values, int[] indexes) {
        SortUtils.sortByValue(start, end, values, indexes);
        for (int i = 0; i < values.length - 1; ++i) {
            double tmp = values[i];
            int len = 0;
            while (i + len + 1 < values.length && tmp == values[i + len + 1]) {
                ++len;
            }
            if (len <= 0) continue;
            Arrays.sort(indexes, i, i + len + 1);
            i += len;
        }
    }

    private static int med3(int[] array, int a, int b, int c) {
        int x = array[a];
        int y = array[b];
        int z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(double[] array, int a, int b, int c) {
        double x = array[a];
        double y = array[b];
        double z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    public static void main(String[] args) {
        int n = 10000000;
        int[] indexes = new int[n];
        double[] values = new double[n];
        Random rand = new Random();
        for (int i = 0; i < n; ++i) {
            indexes[i] = rand.nextInt();
            values[i] = rand.nextDouble();
        }
        System.out.println("Running quicksort test ...");
        Timing time = new Timing();
        time.start();
        SortUtils.sortByIndex(0, indexes.length, indexes, values);
        System.out.println("quicksort n=" + n + " in " + time.stop() + "ms.");
        time.start();
        boolean flag = SortUtils.isSorted(0, indexes.length, indexes);
        System.out.println("check sorted n=" + n + " in " + time.stop() + "ms, " + flag + ".");
    }
}

