/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.util.UtilFunctions;

public class EncoderPassThrough
extends Encoder {
    private static final long serialVersionUID = -8473768154646831882L;

    protected EncoderPassThrough(int[] ptCols, int clen) {
        super(ptCols, clen);
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public String[] apply(String[] in) {
        return in;
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int col = this._colList[j] - 1;
            Expression.ValueType vt = in.getSchema()[col];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object val = in.get(i, col);
                out.quickSetValue(i, col, val == null || vt == Expression.ValueType.STRING && val.toString().isEmpty() ? Double.NaN : UtilFunctions.objectToDouble(vt, val));
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }

    @Override
    public void mapOutputTransformationMetadata(OutputCollector<IntWritable, DistinctValue> out, int taskID, TfUtils agents) throws IOException {
        throw new RuntimeException("File-based api not supported.");
    }

    @Override
    public void mergeAndOutputTransformationMetadata(Iterator<DistinctValue> values, String outputDir, int colID, FileSystem fs, TfUtils agents) throws IOException {
        throw new RuntimeException("File-based api not supported.");
    }

    @Override
    public void loadTxMtd(JobConf job, FileSystem fs, Path txMtdDir, TfUtils agents) throws IOException {
        throw new RuntimeException("File-based api not supported.");
    }
}

