/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.encode.Encoder;

public class EncoderComposite
extends Encoder {
    private static final long serialVersionUID = -8473768154646831882L;
    private List<Encoder> _encoders = null;
    private FrameBlock _meta = null;

    protected EncoderComposite(List<Encoder> encoders) {
        super(null, -1);
        this._encoders = encoders;
    }

    @Override
    public int getNumCols() {
        int clen = 0;
        for (Encoder encoder : this._encoders) {
            clen = Math.max(clen, encoder.getNumCols());
        }
        return clen;
    }

    public List<Encoder> getEncoders() {
        return this._encoders;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        for (Encoder encoder : this._encoders) {
            encoder.build(in);
        }
        this._meta = new FrameBlock(in.getNumColumns(), Expression.ValueType.STRING);
        for (Encoder encoder : this._encoders) {
            this._meta = encoder.getMetaData(this._meta);
        }
        for (Encoder encoder : this._encoders) {
            encoder.initMetaData(this._meta);
        }
        for (Encoder encoder : this._encoders) {
            out = encoder.apply(in, out);
        }
        return out;
    }

    @Override
    public void build(FrameBlock in) {
        for (Encoder encoder : this._encoders) {
            encoder.build(in);
        }
    }

    @Override
    public String[] apply(String[] in) {
        for (Encoder encoder : this._encoders) {
            encoder.apply(in);
        }
        return in;
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (Encoder encoder : this._encoders) {
            out = encoder.apply(in, out);
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        if (this._meta != null) {
            return this._meta;
        }
        for (Encoder encoder : this._encoders) {
            encoder.getMetaData(out);
        }
        return out;
    }

    @Override
    public void initMetaData(FrameBlock out) {
        for (Encoder encoder : this._encoders) {
            encoder.initMetaData(out);
        }
    }

    @Override
    public void mapOutputTransformationMetadata(OutputCollector<IntWritable, DistinctValue> out, int taskID, TfUtils agents) throws IOException {
        throw new RuntimeException("File-based api not supported.");
    }

    @Override
    public void mergeAndOutputTransformationMetadata(Iterator<DistinctValue> values, String outputDir, int colID, FileSystem fs, TfUtils agents) throws IOException {
        throw new RuntimeException("File-based api not supported.");
    }

    @Override
    public void loadTxMtd(JobConf job, FileSystem fs, Path txMtdDir, TfUtils agents) throws IOException {
        throw new RuntimeException("File-based api not supported.");
    }
}

