/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import scala.Tuple2;

public class GenTfMtdSPARK {
    public static long runSparkJob(SparkExecutionContext sec, JavaRDD<Tuple2<LongWritable, Text>> inputRDD, String tfMtdPath, String spec, String partOffsetsFile, CSVFileFormatProperties prop, long numCols, String headerLine) throws IOException, ClassNotFoundException, InterruptedException, IllegalArgumentException, JSONException {
        JavaRDD tfMapOutput = inputRDD.mapPartitionsWithIndex((Function2)new GenTfMtdMap(prop.hasHeader(), prop.getDelim(), prop.getNAStrings(), spec, numCols, headerLine), true);
        JavaPairRDD rdd = JavaPairRDD.fromJavaRDD((JavaRDD)tfMapOutput).groupByKey();
        JavaRDD out = rdd.flatMap((FlatMapFunction)new GenTfMtdReduce(prop.hasHeader(), prop.getDelim(), prop.getNAStrings(), headerLine, tfMtdPath, partOffsetsFile, spec, numCols));
        long numRows = (Long)out.reduce((Function2)new Function2<Long, Long, Long>(){
            private static final long serialVersionUID = 1263336168859959795L;

            public Long call(Long v1, Long v2) throws Exception {
                return v1 + v2;
            }
        });
        return numRows;
    }

    public static List<Tuple2<Integer, DistinctValue>> toTuple2List(List<Pair<Integer, DistinctValue>> in) {
        ArrayList<Tuple2<Integer, DistinctValue>> ret = new ArrayList<Tuple2<Integer, DistinctValue>>();
        for (Pair<Integer, DistinctValue> e : in) {
            ret.add((Tuple2<Integer, DistinctValue>)new Tuple2((Object)e.getKey(), (Object)e.getValue()));
        }
        return ret;
    }

    private static class GenTfMtdReduce
    implements FlatMapFunction<Tuple2<Integer, Iterable<DistinctValue>>, Long> {
        private static final long serialVersionUID = -2733233671193035242L;
        private TfUtils _agents = null;

        public GenTfMtdReduce(boolean hasHeader, String delim, String naStrings, String headerLine, String tfMtdDir, String offsetFile, String spec, long numCols) throws IOException, JSONException {
            String[] nas = TfUtils.parseNAStrings(naStrings);
            JSONObject jspec = new JSONObject(spec);
            this._agents = new TfUtils(headerLine, hasHeader, delim, nas, jspec, numCols, tfMtdDir, offsetFile, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator<Long> call(Tuple2<Integer, Iterable<DistinctValue>> t) throws Exception {
            ArrayList<Long> numRows;
            block5: {
                FileSystem fs;
                Iterator<DistinctValue> iterDV;
                int colID;
                block6: {
                    JobConf job;
                    block4: {
                        colID = (Integer)t._1();
                        iterDV = ((Iterable)t._2()).iterator();
                        job = new JobConf();
                        fs = FileSystem.get((Configuration)job);
                        numRows = new ArrayList<Long>();
                        if (colID >= 0) break block4;
                        this._agents.getMVImputeAgent().mergeAndOutputTransformationMetadata(iterDV, this._agents.getTfMtdDir(), colID *= -1, fs, this._agents);
                        numRows.add(0L);
                        break block5;
                    }
                    if ((long)colID != this._agents.getNumCols() + 1L) break block6;
                    ArrayList<CSVReblockMR.OffsetCount> list = new ArrayList<CSVReblockMR.OffsetCount>();
                    while (iterDV.hasNext()) {
                        list.add(new CSVReblockMR.OffsetCount(iterDV.next().getOffsetCount()));
                    }
                    Collections.sort(list);
                    SequenceFile.Writer writer = null;
                    long lineOffset = 0L;
                    try {
                        writer = new SequenceFile.Writer(fs, (Configuration)job, new Path(this._agents.getOffsetFile() + "/part-00000"), ByteWritable.class, CSVReblockMR.OffsetCount.class);
                        for (CSVReblockMR.OffsetCount oc : list) {
                            long count = oc.count;
                            oc.count = lineOffset;
                            writer.append((Writable)new ByteWritable(0), (Writable)oc);
                            lineOffset += count;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(writer);
                        throw throwable;
                    }
                    IOUtilFunctions.closeSilently((Closeable)writer);
                    list.clear();
                    numRows.add(lineOffset);
                    break block5;
                }
                this._agents.getRecodeAgent().mergeAndOutputTransformationMetadata(iterDV, this._agents.getTfMtdDir(), colID, fs, this._agents);
                numRows.add(0L);
            }
            return numRows.iterator();
        }
    }

    private static class GenTfMtdMap
    implements Function2<Integer, Iterator<Tuple2<LongWritable, Text>>, Iterator<Tuple2<Integer, DistinctValue>>> {
        private static final long serialVersionUID = -5622745445470598215L;
        private TfUtils _agents = null;

        public GenTfMtdMap(boolean hasHeader, String delim, String naStrings, String spec, long numCols, String headerLine) throws IllegalArgumentException, IOException, JSONException {
            String[] nas = TfUtils.parseNAStrings(naStrings);
            JSONObject jspec = new JSONObject(spec);
            this._agents = new TfUtils(headerLine, hasHeader, delim, nas, jspec, numCols, null, null, null);
        }

        public Iterator<Tuple2<Integer, DistinctValue>> call(Integer partitionID, Iterator<Tuple2<LongWritable, Text>> csvLines) throws Exception {
            boolean first = true;
            Tuple2<LongWritable, Text> rec = null;
            long _offsetInPartFile = -1L;
            while (csvLines.hasNext()) {
                rec = csvLines.next();
                if (first) {
                    first = false;
                    _offsetInPartFile = ((LongWritable)rec._1()).get();
                    if (partitionID == 0 && this._agents.hasHeader() && _offsetInPartFile == 0L) continue;
                }
                this._agents.prepareTfMtd(((Text)rec._2()).toString());
            }
            ArrayList<Pair<Integer, DistinctValue>> outList = new ArrayList<Pair<Integer, DistinctValue>>();
            this._agents.getMVImputeAgent().mapOutputTransformationMetadata(partitionID, outList, this._agents);
            this._agents.getRecodeAgent().mapOutputTransformationMetadata(partitionID, outList, this._agents);
            this._agents.getBinAgent().mapOutputTransformationMetadata(partitionID, outList, this._agents);
            DistinctValue dv = new DistinctValue(new CSVReblockMR.OffsetCount("Partition" + partitionID, _offsetInPartFile, this._agents.getTotal()));
            Pair<Integer, DistinctValue> tuple = new Pair<Integer, DistinctValue>((int)(this._agents.getNumCols() + 1L), dv);
            outList.add(tuple);
            return GenTfMtdSPARK.toTuple2List(outList).iterator();
        }
    }
}

