/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DistinctValue
implements Writable,
Serializable {
    private static final long serialVersionUID = -8236705946336974836L;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] _bytes;
    private int _length;
    private long _count;

    public DistinctValue() {
        this._bytes = EMPTY_BYTES;
        this._length = 0;
        this._count = -1L;
    }

    public DistinctValue(String w, long count) throws CharacterCodingException {
        ByteBuffer bb = Text.encode((String)w, (boolean)true);
        this._bytes = bb.array();
        this._length = bb.limit();
        this._count = count;
    }

    public DistinctValue(CSVReblockMR.OffsetCount oc) throws CharacterCodingException {
        this(oc.filename + "," + oc.fileOffset, oc.count);
    }

    public void reset() {
        this._bytes = EMPTY_BYTES;
        this._length = 0;
        this._count = -1L;
    }

    public String getWord() {
        return new String(this._bytes, 0, this._length, Charset.forName("UTF-8"));
    }

    public long getCount() {
        return this._count;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this._length);
        out.write(this._bytes, 0, this._length);
        out.writeLong(this._count);
    }

    public void readFields(DataInput in) throws IOException {
        this._length = WritableUtils.readVInt((DataInput)in);
        this._bytes = new byte[this._length];
        in.readFully(this._bytes, 0, this._length);
        this._count = in.readLong();
    }

    public CSVReblockMR.OffsetCount getOffsetCount() {
        String[] parts = this.getWord().split(",");
        return new CSVReblockMR.OffsetCount(parts[0], UtilFunctions.parseToLong(parts[1]), this.getCount());
    }
}

