/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.CSVReblockMapper;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.wink.json4j.JSONException;

public class ApplyTfBBMapper
extends MapperBase
implements Mapper<LongWritable, Text, TaggedFirstSecondIndexes, CSVReblockMR.BlockRow> {
    boolean _partFileWithHeader = false;
    TfUtils tfmapper = null;
    Reporter _reporter = null;
    private CSVReblockMapper.IndexedBlockRow idxRow = null;
    private long rowOffset = 0L;
    private HashMap<Long, Long> offsetMap = new HashMap();
    private boolean _first = true;
    private long num = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            this._partFileWithHeader = TfUtils.isPartFileWithHeader(job);
            this.tfmapper = new TfUtils(job);
            this.tfmapper.loadTfMetadata(job, true);
            ByteWritable key = new ByteWritable();
            CSVReblockMR.OffsetCount value = new CSVReblockMR.OffsetCount();
            Path p = new Path(job.get("rowid.file.name"));
            FileSystem fs = FileSystem.get((Configuration)job);
            Path thisPath = new Path(job.get(MRConfigurationNames.MR_MAP_INPUT_FILE)).makeQualified(fs);
            String thisfile = thisPath.toString();
            SequenceFile.Reader reader = null;
            try {
                reader = new SequenceFile.Reader(fs, p, (Configuration)job);
                while (reader.next((Writable)key, (Writable)value)) {
                    if (!thisfile.equals(value.filename)) continue;
                    this.offsetMap.put(value.fileOffset, value.count);
                }
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(reader);
                throw throwable;
            }
            IOUtilFunctions.closeSilently((Closeable)reader);
            this.idxRow = new CSVReblockMapper.IndexedBlockRow();
            int maxBclen = 0;
            for (ArrayList insv : this.csv_reblock_instructions) {
                for (CSVReblockInstruction in : insv) {
                    if (maxBclen >= in.bclen) continue;
                    maxBclen = in.bclen;
                }
            }
            this.idxRow.getRow().data.reset(1, maxBclen, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void map(LongWritable rawKey, Text rawValue, OutputCollector<TaggedFirstSecondIndexes, CSVReblockMR.BlockRow> out, Reporter reporter) throws IOException {
        String[] words;
        if (this._first) {
            this.rowOffset = this.offsetMap.get(rawKey.get());
            this._reporter = reporter;
            this._first = false;
        }
        if (rawKey.get() == 0L && this._partFileWithHeader) {
            this.tfmapper.processHeaderLine();
            if (this.tfmapper.hasHeader()) {
                return;
            }
        }
        if (!this.tfmapper.omit(words = this.tfmapper.getWords(rawValue))) {
            words = this.tfmapper.apply(words);
            try {
                this.tfmapper.check(words);
                CSVReblockInstruction ins = (CSVReblockInstruction)((ArrayList)this.csv_reblock_instructions.get(0)).get(0);
                this.idxRow = CSVReblockMapper.processRow(this.idxRow, words, this.rowOffset, this.num, ins.output, ins.brlen, ins.bclen, ins.fill, ins.fillValue, out);
            }
            catch (DMLRuntimeException e) {
                throw new RuntimeException(e.getMessage() + ":" + rawValue.toString());
            }
            ++this.num;
        }
    }

    public void close() throws IOException {
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
    }
}

