/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.instructions.mr.AggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.TernaryInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.CollectMultipleConvertedOutputs;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRBaseForCommonInstructions;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ReduceBase
extends MRBaseForCommonInstructions {
    protected HashMap<Byte, ArrayList<AggregateInstruction>> agg_instructions = new HashMap();
    protected static final AggregateOperator DEFAULT_AGG_OP = new AggregateOperator(0.0, Plus.getPlusFnObject());
    protected AggregateInstruction defaultAggIns = new AggregateInstruction(DEFAULT_AGG_OP, 0, 0, "DEFAULT_AGG_OP");
    protected ArrayList<MRInstruction> mixed_instructions = null;
    protected byte[] resultIndexes = null;
    protected byte[] resultDimsUnknown = null;
    protected CollectMultipleConvertedOutputs collectFinalMultipleOutputs;
    protected long[] resultsNonZeros = null;
    protected long[] resultsMaxRowDims = null;
    protected long[] resultsMaxColDims = null;
    protected String dimsUnknownFilePrefix;
    protected Reporter cachedReporter = null;
    protected boolean firsttime = true;
    protected String reducerID;
    protected CachedValueMap correctionCache = new CachedValueMap();

    protected void commonSetup(Reporter reporter) {
        if (this.firsttime) {
            this.cachedReporter = reporter;
            this.firsttime = false;
        }
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        this.reducerID = job.get(MRConfigurationNames.MR_TASK_ATTEMPT_ID);
        this.dimsUnknownFilePrefix = job.get("dims.unknown.file.prefix");
        this.resultIndexes = MRJobConfiguration.getResultIndexes(job);
        this.resultDimsUnknown = MRJobConfiguration.getResultDimsUnknown(job);
        this.resultsNonZeros = new long[this.resultIndexes.length];
        this.resultsMaxRowDims = new long[this.resultIndexes.length];
        this.resultsMaxColDims = new long[this.resultIndexes.length];
        this.collectFinalMultipleOutputs = MRJobConfiguration.getMultipleConvertedOutputs(job);
        AggregateInstruction[] agg_insts = null;
        try {
            agg_insts = MRJobConfiguration.getAggregateInstructions(job);
            MRInstruction[] tmp = MRJobConfiguration.getInstructionsInReducer(job);
            if (tmp != null) {
                this.mixed_instructions = new ArrayList();
                Collections.addAll(this.mixed_instructions, tmp);
            }
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        try {
            this.setupDistCacheFiles(job);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (agg_insts != null) {
            for (AggregateInstruction ins : agg_insts) {
                ArrayList<AggregateInstruction> vec = this.agg_instructions.get(ins.input);
                if (vec == null) {
                    vec = new ArrayList();
                    this.agg_instructions.put(ins.input, vec);
                }
                vec.add(ins);
                if (ins.input == ins.output) continue;
                AggregateInstruction partialIns = new AggregateInstruction(ins.getOperator(), ins.output, ins.output, ins.toString());
                vec = this.agg_instructions.get(partialIns.input);
                if (vec == null) {
                    vec = new ArrayList();
                    this.agg_instructions.put(partialIns.input, vec);
                }
                vec.add(partialIns);
            }
        }
    }

    protected void collectOutput_N_Increase_Counter(MatrixIndexes indexes, MatrixValue value, int i, Reporter reporter) throws IOException {
        this.collectOutput_N_Increase_Counter(indexes, value, i, reporter, this.collectFinalMultipleOutputs, this.resultDimsUnknown, this.resultsNonZeros, this.resultsMaxRowDims, this.resultsMaxColDims);
    }

    protected ArrayList<Integer> getOutputIndexes(byte outputTag) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this.resultIndexes.length; ++i) {
            if (this.resultIndexes[i] != outputTag) continue;
            ret.add(i);
        }
        return ret;
    }

    protected static ArrayList<Integer> getOutputIndexes(byte outputTag, byte[] resultIndexes) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < resultIndexes.length; ++i) {
            if (resultIndexes[i] != outputTag) continue;
            ret.add(i);
        }
        return ret;
    }

    public void close() throws IOException {
        if (this.cachedReporter != null) {
            int taskid;
            String[] parts = this.reducerID.split("_");
            String jobID = "job_" + parts[1] + "_" + parts[2];
            if (parts[0].equalsIgnoreCase("task")) {
                taskid = Integer.parseInt(parts[parts.length - 1]);
            } else if (parts[0].equalsIgnoreCase("attempt")) {
                taskid = Integer.parseInt(parts[parts.length - 2]);
            } else {
                throw new RuntimeException("Unrecognized format for reducerID: " + this.reducerID);
            }
            boolean dimsUnknown = false;
            for (int i = 0; i < this.resultIndexes.length; ++i) {
                this.cachedReporter.incrCounter("nonzeros", Integer.toString(i), this.resultsNonZeros[i]);
                if (this.resultDimsUnknown == null || this.resultDimsUnknown[i] == 0) continue;
                dimsUnknown = true;
            }
            if (dimsUnknown) {
                MapReduceTool.writeDimsFile(this.dimsUnknownFilePrefix + "/" + jobID + "_dimsFile/r_" + taskid, this.resultDimsUnknown, this.resultsMaxRowDims, this.resultsMaxColDims);
            }
        }
        this.collectFinalMultipleOutputs.close();
    }

    protected void processReducerInstructions() throws IOException {
        try {
            this.processMixedInstructions(this.mixed_instructions);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void outputInCombinerFromCachedValues(MatrixIndexes indexes, TaggedMatrixValue taggedbuffer, OutputCollector<MatrixIndexes, TaggedMatrixValue> out) throws IOException {
        for (byte output : this.cachedValues.getIndexesOfAll()) {
            ArrayList<IndexedMatrixValue> outValues = this.cachedValues.get(output);
            if (outValues == null) continue;
            for (IndexedMatrixValue outValue : outValues) {
                taggedbuffer.setBaseObject(outValue.getValue());
                taggedbuffer.setTag(output);
                out.collect((Object)indexes, (Object)taggedbuffer);
            }
        }
    }

    protected void outputResultsFromCachedValues(Reporter reporter) throws IOException {
        for (int i = 0; i < this.resultIndexes.length; ++i) {
            byte output = this.resultIndexes[i];
            ArrayList<IndexedMatrixValue> outValues = this.cachedValues.get(output);
            if (outValues == null) continue;
            for (IndexedMatrixValue outValue : outValues) {
                this.collectOutput_N_Increase_Counter(outValue.getIndexes(), outValue.getValue(), i, reporter);
            }
        }
    }

    private void processAggregateHelp(long row, long col, MatrixValue value, AggregateInstruction instruction, boolean imbededCorrection) throws DMLRuntimeException {
        AggregateOperator aggOp = (AggregateOperator)instruction.getOperator();
        IndexedMatrixValue out = this.cachedValues.getFirst(instruction.output);
        IndexedMatrixValue correction = null;
        if (aggOp.correctionExists) {
            correction = this.correctionCache.getFirst(instruction.output);
        }
        if (out == null) {
            out = this.cachedValues.holdPlace(instruction.output, this.valueClass);
            out.getIndexes().setIndexes(row, col);
            if (aggOp.correctionExists) {
                if (correction == null) {
                    correction = this.correctionCache.holdPlace(instruction.output, this.valueClass);
                }
                OperationsOnMatrixValues.startAggregation(out.getValue(), correction.getValue(), aggOp, value.getNumRows(), value.getNumColumns(), value.isInSparseFormat(), imbededCorrection);
            } else {
                OperationsOnMatrixValues.startAggregation(out.getValue(), null, aggOp, value.getNumRows(), value.getNumColumns(), value.isInSparseFormat(), imbededCorrection);
            }
        }
        if (aggOp.correctionExists) {
            OperationsOnMatrixValues.incrementalAggregation(out.getValue(), correction.getValue(), value, (AggregateOperator)instruction.getOperator(), imbededCorrection);
        } else {
            OperationsOnMatrixValues.incrementalAggregation(out.getValue(), null, value, (AggregateOperator)instruction.getOperator(), imbededCorrection);
        }
    }

    protected void processAggregateInstructions(MatrixIndexes indexes, Iterator<TaggedMatrixValue> values) throws IOException {
        this.processAggregateInstructions(indexes, values, false);
    }

    protected void processAggregateInstructions(MatrixIndexes indexes, Iterator<TaggedMatrixValue> values, boolean imbededCorrection) throws IOException {
        try {
            while (values.hasNext()) {
                TaggedMatrixValue value = values.next();
                byte input = value.getTag();
                ArrayList<AggregateInstruction> instructions = this.agg_instructions.get(input);
                if (instructions == null) {
                    this.defaultAggIns.input = input;
                    this.defaultAggIns.output = input;
                    this.processAggregateHelp(indexes.getRowIndex(), indexes.getColumnIndex(), (MatrixValue)value.getBaseObject(), this.defaultAggIns, imbededCorrection);
                    continue;
                }
                for (AggregateInstruction ins : instructions) {
                    this.processAggregateHelp(indexes.getRowIndex(), indexes.getColumnIndex(), (MatrixValue)value.getBaseObject(), ins, imbededCorrection);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected boolean containsTernaryInstruction() {
        if (this.mixed_instructions != null) {
            for (MRInstruction inst : this.mixed_instructions) {
                if (!(inst instanceof TernaryInstruction)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean dimsKnownForTernaryInstructions() {
        if (this.mixed_instructions != null) {
            for (MRInstruction inst : this.mixed_instructions) {
                if (!(inst instanceof TernaryInstruction) || ((TernaryInstruction)inst).knownOutputDims()) continue;
                return false;
            }
        }
        return true;
    }

    protected void prepareMatrixCharacteristicsTernaryInstruction(JobConf job) {
        if (this.mixed_instructions != null) {
            for (MRInstruction inst : this.mixed_instructions) {
                if (!(inst instanceof TernaryInstruction)) continue;
                TernaryInstruction tinst = (TernaryInstruction)inst;
                if (tinst.input1 == -1) continue;
                this.dimensions.put(tinst.input1, MRJobConfiguration.getMatrixCharacteristicsForInput(job, tinst.input1));
            }
        }
    }

    public static enum Counters {
        COMBINE_OR_REDUCE_TIME;

    }
}

